(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){
// Keep in sync with ..\CoreClr\src\Microsoft.ServiceHub.Client\ExitCode.cs
"use strict";
/**
 * Exit code from a Node ServiceHub process.
 * Range 1-19 and 128+ is used by Node itself.
 * Range 20 - 127 is used by ServiceHub.
 * Non-node ServiceHub hosts are supposed to use the same ServiceHub exit codes in ServiceHub range 20-127.
 * */
var ExitCode;
(function (ExitCode) {
    /** Successful termination, no error */
    ExitCode[ExitCode["Success"] = 0] = "Success";
    // Node error codes
    /** There was an uncaught exception, and it was not handled by a domain or an 'uncaughtException' event handler. */
    ExitCode[ExitCode["NodeUncaughtFatalException"] = 1] = "NodeUncaughtFatalException";
    /** The JavaScript source code internal in Node.js's bootstrapping process caused a parse error.
     * This is extremely rare, and generally can only happen during development of Node.js itself. */
    ExitCode[ExitCode["NodeInternalJavaScriptParseError"] = 3] = "NodeInternalJavaScriptParseError";
    /** The JavaScript source code internal in Node.js's bootstrapping process failed to return a function value when evaluated.
     * This is extremely rare, and generally can only happen during development of Node.js itself. */
    ExitCode[ExitCode["NodeInternalJavaScriptEvaluationFailure"] = 4] = "NodeInternalJavaScriptEvaluationFailure";
    /** There was a fatal unrecoverable error in V8. Typically a message will be printed to stderr with the prefix FATAL ERROR */
    ExitCode[ExitCode["NodeFatalError"] = 5] = "NodeFatalError";
    /** There was an uncaught exception, but the internal fatal exception handler function was somehow set to a non-function, and could not be called. */
    ExitCode[ExitCode["NodeNonFunctionInternalExceptionHandler"] = 6] = "NodeNonFunctionInternalExceptionHandler";
    /** There was an uncaught exception, and the internal fatal exception handler function itself threw an error while attempting to handle it.
     * This can happen, for example, if a process.on('uncaughtException') or domain.on('error') handler throws an error. */
    ExitCode[ExitCode["NodeInternalExceptionHandlerRunTimeFailure"] = 7] = "NodeInternalExceptionHandlerRunTimeFailure";
    /** Either an unknown option was specified, or an option requiring a value was provided without a value. */
    ExitCode[ExitCode["NodeInvalidArgument"] = 9] = "NodeInvalidArgument";
    /** The JavaScript source code internal in Node.js's bootstrapping process threw an error when the bootstrapping function was called.
     * This is extremely rare, and generally can only happen during development of Node.js itself. */
    ExitCode[ExitCode["NodeInternalJavaScriptRunTimeFailure"] = 10] = "NodeInternalJavaScriptRunTimeFailure";
    /** The --debug and/or --debug-brk options were set, but an invalid port number was chosen. */
    ExitCode[ExitCode["NodeInvalidDebugArgument"] = 12] = "NodeInvalidDebugArgument";
    // ServiceHub exit codes
    // -------------------------------------------------------------------------------------------------------
    /** Invalid command line argument for servicehub process */
    ExitCode[ExitCode["InvalidArgument"] = 20] = "InvalidArgument";
    /** Cannot start a new pipe server because the supplied pipe address is already in use.
     * This may happen when starting a controller where there is already a controller running */
    ExitCode[ExitCode["ErrorStartingServerPipeInUse"] = 21] = "ErrorStartingServerPipeInUse";
    /** Cannot start a new pipe server due to some error */
    ExitCode[ExitCode["ErrorStartingServer"] = 22] = "ErrorStartingServer";
    /** Uncaught exception */
    ExitCode[ExitCode["UncaughtException"] = 23] = "UncaughtException";
    /** Error shutting down */
    ExitCode[ExitCode["ShutdownError"] = 24] = "ShutdownError";
    /** Configuration error in servicehub.config.json */
    ExitCode[ExitCode["ConfigurationError"] = 25] = "ConfigurationError";
    // Signals
    // -------------------------------------------------------------------------------------------------------
    /** Node process was terminated by SIGHUP signal (when the console window is closed)*/
    ExitCode[ExitCode["SigHup"] = 129] = "SigHup";
    /** Node process was terminated by SIGINT signal (by pressing Ctrl-C in the console) */
    ExitCode[ExitCode["SigInt"] = 130] = "SigInt";
    /** Node process was terminated by SIGKILL signal */
    ExitCode[ExitCode["SigKill"] = 137] = "SigKill";
    /** Node  process was terminated by SIGTERM signal */
    ExitCode[ExitCode["SigTerm"] = 143] = "SigTerm";
    /** Node  process was terminated by SIGBREAK signal (by pressing Ctrl-Break in the console) */
    ExitCode[ExitCode["SigBreak"] = 149] = "SigBreak";
})(ExitCode || (ExitCode = {}));
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = ExitCode;


},{}],2:[function(require,module,exports){
"use strict";
var net = require('net');
var path = require('path');
var os = require('os');
var fs = require('fs');
var q = require('q');
var ec = require('errno-codes');
var mkdirp = require('mkdir-parents');
var osLocale = require('os-locale');
var rmdirRecursive = require('rmdir-recursive');
var config_1 = require('./config');
var randomHexString_1 = require('./randomHexString');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
var report_errors_1 = require('report-errors');
var tmp = require('tmp');
// Enable long stack support for Q promises
// TODO: revisit. Long stack support in Q may impose some perf costs if there are many promises or many users.
q.longStackSupport = true;
/**
 * Sets OS locale to Hub host.
 */
function setOsLocale(localeConfigs) {
    var locale = osLocale.sync();
    localeConfigs.forEach(function (config) {
        config(locale, /* cache */ true);
    });
}
exports.setOsLocale = setOsLocale;
;
var WatsonReporter;
function registerForCrashReporting(crashFileLogPrefix) {
    var errorHandler = new report_errors_1.ErrorHandlerNode({ appRoot: __dirname, packageInfo: require(path.join(__dirname, 'package.json')) });
    if (process.platform === 'win32') {
        // Report failures to Watson
        if (!WatsonReporter) {
            try {
                WatsonReporter = require('wer-reporter').WatsonReporter;
            }
            catch (e) {
                WatsonReporter = null;
            }
        }
        if (WatsonReporter) {
            errorHandler.addReportingChannel(new WatsonReporter({ nonCritical: true /* set nonCritical to true so that WER dialog is hidden */ }));
        }
    }
    // Write failures to a log file
    var crashLogFilePrefix = tmp.tmpNameSync({ template: crashFileLogPrefix + "-" + process.pid + "-XXXXXX", postfix: '.log' });
    errorHandler.addReportingChannel(new report_errors_1.FileReporter(getLogFilesDir(), crashLogFilePrefix + ".log", /* stripStack */ true));
}
exports.registerForCrashReporting = registerForCrashReporting;
/* ServiceHub error classes */
(function (ErrorKind) {
    ErrorKind[ErrorKind["Error"] = 0] = "Error";
    ErrorKind[ErrorKind["InvalidArgument"] = 1] = "InvalidArgument";
    ErrorKind[ErrorKind["InvalidOperation"] = 2] = "InvalidOperation";
    ErrorKind[ErrorKind["ConfigurationError"] = 3] = "ConfigurationError";
    ErrorKind[ErrorKind["ServiceModuleInfoNotFound"] = 4] = "ServiceModuleInfoNotFound";
    ErrorKind[ErrorKind["ServiceModuleInfoLoadError"] = 5] = "ServiceModuleInfoLoadError";
    ErrorKind[ErrorKind["ServiceModuleInfoInvalidPropertyError"] = 6] = "ServiceModuleInfoInvalidPropertyError";
    ErrorKind[ErrorKind["HubHostInfoLoadError"] = 7] = "HubHostInfoLoadError";
    ErrorKind[ErrorKind["JsonParseError"] = 8] = "JsonParseError";
    ErrorKind[ErrorKind["HostGroupsNotSupported"] = 9] = "HostGroupsNotSupported";
    ErrorKind[ErrorKind["ObjectDisposed"] = 10] = "ObjectDisposed";
})(exports.ErrorKind || (exports.ErrorKind = {}));
var ErrorKind = exports.ErrorKind;
// Default error messages for the cases where caller can pass only error kind to ServiceHubError ctor.
var defaultErrorMessages = {};
var ServiceHubError = (function () {
    function ServiceHubError(kind, message) {
        this.name = 'ServiceHubError';
        this.kind = kind || ErrorKind.Error;
        this.message = message;
        if (!this.message) {
            ServiceHubError.initDefaultErrorMessages();
            this.message = defaultErrorMessages[this.kind] || ErrorKind[this.kind];
        }
        this.stack = (new Error).stack;
    }
    ServiceHubError.initDefaultErrorMessages = function () {
        if (!ServiceHubError.areDefaultErrorMessagesInitialized) {
            defaultErrorMessages[ErrorKind.ObjectDisposed] = libraryResourceStrings_1.LibraryResourceStrings.objectDisposed;
            ServiceHubError.areDefaultErrorMessagesInitialized = true;
        }
    };
    return ServiceHubError;
}());
exports.ServiceHubError = ServiceHubError;
var Constants = (function () {
    function Constants() {
    }
    Constants.HostInfoFolderName = 'host';
    Constants.HubHostScript = 'HubHost.js';
    Constants.PipeScheme = 'net.pipe://';
    return Constants;
}());
exports.Constants = Constants;
var ServerManager = (function () {
    function ServerManager() {
        this.activeStreams = [];
        this.activeServers = [];
    }
    // Returns the endpoint that people connect to in order to have an instance of 'name' created and hooked up to the proper callback stream
    ServerManager.prototype.startService = function (options, connectionCallback) {
        var _this = this;
        if (!options) {
            throw new ServiceHubError(ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variablesAreNotDefined('options'));
        }
        if (!options.logger) {
            throw new ServiceHubError(ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('options.logger'));
        }
        var serverOnConnectionCallback = null;
        var url;
        serverOnConnectionCallback = function (stream) {
            _this.activeStreams.push(stream);
            connectionCallback(stream, options.logger);
        };
        var server = net.createServer(serverOnConnectionCallback);
        this.activeServers.push(server);
        // Start the pipe listener
        return q.resolve(options.pipeName || randomHexString_1.default())
            .then(function (pipeName) {
            pipeName = formatPipeName(pipeName);
            return getServerPipePath(pipeName)
                .then(function (serverPath) {
                var url = Constants.PipeScheme + pipeName;
                options.logger.info(libraryResourceStrings_1.LibraryResourceStrings.startingServer(options.name, url, serverPath));
                if (options.onErrorCb) {
                    server.on('error', options.onErrorCb);
                }
                q.ninvoke(server, 'once', 'close').done(function () {
                    options.logger.info(libraryResourceStrings_1.LibraryResourceStrings.stoppedServer(options.name, url));
                    _this.activeServers.splice(_this.activeServers.indexOf(server), 1);
                });
                server.listen(serverPath);
                return url;
            });
        });
    };
    ServerManager.prototype.stop = function () {
        var promises = [];
        this.activeServers.forEach(function (server) { return promises.push(q.ninvoke(server, 'close')); });
        return q.all(promises);
    };
    return ServerManager;
}());
exports.serverManager = new ServerManager();
function getPipeName(url) {
    if (!url) {
        throw new ServiceHubError(ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('url'));
    }
    if (url.indexOf(Constants.PipeScheme) !== 0) {
        throw new ServiceHubError(ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.urlShouldStartWith(Constants.PipeScheme));
    }
    var pipeName = url.slice(Constants.PipeScheme.length).trim();
    if (!pipeName) {
        throw new ServiceHubError(ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.urlHasNoPipeName(Constants.PipeScheme));
    }
    return pipeName;
}
exports.getPipeName = getPipeName;
var unixSocketDir = null;
// For *nix platforms we create a socket dir that looks like this: '~/.ServiceHub/<controllerPipeName>'
// ~ avoids pipe name collisions between different users who are running apps with the same ServiceHub config file.
// <controllerPipeName> sub dir ensures each ServiceHub session gets its own dir for socket files.
function getUnixSocketDir() {
    if (unixSocketDir) {
        return q.resolve(unixSocketDir);
    }
    var controllerPipeNamePromise = null;
    // see if we can get the controller pipe name from env var
    var controllerPipeName = getLocationServicePipeName();
    if (controllerPipeName) {
        controllerPipeNamePromise = q.resolve(controllerPipeName);
    }
    else {
        controllerPipeNamePromise = config_1.getConfig()
            .then(function (config) {
            return config.controller.pipeName;
        });
    }
    return controllerPipeNamePromise
        .then(function (controllerPipeName) { return path.join(getServiceHubBaseDirForUnix(), controllerPipeName); });
}
exports.getUnixSocketDir = getUnixSocketDir;
var unixSocketDirCreated = false;
exports.unixOwnerOnlyAccessMode = parseInt('0700', 8); // 'rwx------'
function getServerPipePath(pipeNameOrUrl) {
    if (!pipeNameOrUrl) {
        throw new Error(libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('pipeName'));
    }
    if (pipeNameOrUrl.indexOf(Constants.PipeScheme) === 0) {
        pipeNameOrUrl = pipeNameOrUrl.slice(Constants.PipeScheme.length).trim();
        if (!pipeNameOrUrl) {
            throw new ServiceHubError(ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.noPipeName(Constants.PipeScheme));
        }
    }
    if (os.platform() === 'win32') {
        return q.resolve(path.join('\\\\?\\pipe', pipeNameOrUrl));
    }
    return getUnixSocketDir()
        .then(function (socketDir) {
        var serverPipePath = path.join(socketDir, pipeNameOrUrl);
        if (unixSocketDirCreated) {
            return q.resolve(serverPipePath);
        }
        var dirCheck = q.defer();
        fs.exists(socketDir, function (exists) { return dirCheck.resolve(exists); });
        return dirCheck.promise
            .then(function (exists) {
            if (exists) {
                unixSocketDirCreated = true;
                return serverPipePath;
            }
            else {
                return q.nfcall(mkdirp, socketDir, exports.unixOwnerOnlyAccessMode)
                    .then(function () {
                    unixSocketDirCreated = true;
                    return serverPipePath;
                })
                    .catch(function (e) {
                    if (e.code !== ec.EEXIST.code) {
                        throw e;
                    }
                    unixSocketDirCreated = true;
                    return serverPipePath;
                });
            }
        });
    });
}
exports.getServerPipePath = getServerPipePath;
function deleteUnixSocketDir() {
    if (process.platform === 'win32') {
        return q.resolve({});
    }
    return getUnixSocketDir()
        .then(function (socketDir) {
        var dirCheck = q.defer();
        fs.access(socketDir, function (err) { return dirCheck.resolve(err ? false : true); });
        return dirCheck.promise
            .then(function (exists) {
            if (exists) {
                // delete socket dir
                unixSocketDirCreated = false;
                return q.nfcall(rmdirRecursive, socketDir);
            }
        });
    });
}
exports.deleteUnixSocketDir = deleteUnixSocketDir;
function getPropertyNoCase(obj, propertyName) {
    if (!obj || !propertyName) {
        return null;
    }
    if (obj.hasOwnProperty(propertyName)) {
        return obj[propertyName];
    }
    propertyName = propertyName.toLowerCase();
    for (var prop in obj) {
        if (obj.hasOwnProperty(prop) && prop.toLowerCase() === propertyName) {
            return obj[prop];
        }
    }
}
exports.getPropertyNoCase = getPropertyNoCase;
function getPropertiesArray(obj) {
    var result = [];
    if (obj !== null && typeof obj === 'object') {
        for (var prop in obj) {
            if (obj.hasOwnProperty(prop)) {
                result.push(obj[prop]);
            }
        }
    }
    return result;
}
exports.getPropertiesArray = getPropertiesArray;
function getLogFilesDir() {
    if (process.platform == 'win32') {
        return path.join(os.tmpdir(), 'servicehub', 'logs');
    }
    else {
        return path.join(getServiceHubBaseDirForUnix(), 'logs');
    }
}
exports.getLogFilesDir = getLogFilesDir;
var locationServicePipeNameEnvironmentVariable = 'ServiceHubLocationServicePipeName';
function getLocationServicePipeName() {
    return process.env[locationServicePipeNameEnvironmentVariable];
}
exports.getLocationServicePipeName = getLocationServicePipeName;
function setLocationServicePipeName(pipeName) {
    process.env[locationServicePipeNameEnvironmentVariable] = pipeName || ''; // Process environment variables are always strings.
}
exports.setLocationServicePipeName = setLocationServicePipeName;
exports.maxPipeNameLength = 10;
function formatPipeName(pipeName) {
    if (process.platform === 'win32' || pipeName.length <= exports.maxPipeNameLength) {
        return pipeName;
    }
    else {
        return pipeName.substring(0, exports.maxPipeNameLength);
    }
}
exports.formatPipeName = formatPipeName;
function parseFileAsJson(filePath, encoding) {
    if (!filePath) {
        throw new ServiceHubError(ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('filePath'));
    }
    encoding = encoding || 'utf8';
    return q.ninvoke(fs, 'readFile', filePath, encoding)
        .then(function (json) {
        try {
            // BOM is not a valid JSON token, remove it.
            // Node doesn't do that automatically, see https://github.com/nodejs/node-v0.x-archive/issues/1918
            return JSON.parse(json.replace(/^\uFEFF/, ''));
        }
        catch (err) {
            throw new ServiceHubError(ErrorKind.JsonParseError, libraryResourceStrings_1.LibraryResourceStrings.errorParsingJson(filePath, err.message));
        }
    });
}
exports.parseFileAsJson = parseFileAsJson;
// Private (non-exported) helper methods
var serviceHubBaseDirForUnix;
function getServiceHubBaseDirForUnix() {
    if (!serviceHubBaseDirForUnix) {
        serviceHubBaseDirForUnix = path.join(require('user-home'), '.ServiceHub');
    }
    return serviceHubBaseDirForUnix;
}
function transferListeners(eventNames, source, target) {
    for (var _i = 0, eventNames_1 = eventNames; _i < eventNames_1.length; _i++) {
        var event_1 = eventNames_1[_i];
        for (var _a = 0, _b = source.listeners(event_1); _a < _b.length; _a++) {
            var listener = _b[_a];
            target.addListener(event_1, listener);
        }
    }
}
function transferReadableStreamListeners(source, target) {
    var events = ['readable', 'data', 'end', 'close', 'error'];
    transferListeners(events, source, target);
}
function transferWritableStreamListeners(source, target) {
    var events = ['drain', 'finish', 'pipe', 'unpipe', 'error'];
    transferListeners(events, source, target);
}


},{"./config":3,"./libraryResourceStrings":16,"./randomHexString":19,"errno-codes":27,"fs":undefined,"mkdir-parents":38,"net":undefined,"os":undefined,"os-locale":41,"path":undefined,"q":44,"report-errors":51,"rmdir-recursive":54,"tmp":55,"user-home":56,"wer-reporter":"wer-reporter"}],3:[function(require,module,exports){
"use strict";
var path = require('path');
var fs = require('fs');
var q = require('q');
var mkdirp = require('mkdir-parents');
var sha256 = require('js-sha256').sha256;
var isElevated_1 = require('./isElevated');
var findFile_1 = require('./findFile');
var relativePath_1 = require('./relativePath');
var common_1 = require('./common');
var randomHexString_1 = require('./randomHexString');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
exports.serviceHubConfigFileName = 'servicehub.config.json';
var config = null;
var pipeToken = '$PIPE';
/**
 * Directory to search for servicehub.config.json
 * The default is __dirname. HubController sets it to process.cwd().
 */
exports.configDir = __dirname;
function getConfig(logger) {
    if (!config) {
        config = loadConfig(exports.configDir, logger);
    }
    return config;
}
exports.getConfig = getConfig;
function setConfig(cfg) {
    config = q.resolve(cfg);
}
exports.setConfig = setConfig;
function loadConfig(dir, logger, env) {
    return findFile_1.default(exports.serviceHubConfigFileName, { cwd: dir, goUp: true, nodir: true })
        .then(function (serviceHubConfigPath) {
        if (!serviceHubConfigPath) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.ConfigurationError, libraryResourceStrings_1.LibraryResourceStrings.serviceHubConfigJsonNotFound(exports.serviceHubConfigFileName, dir));
        }
        if (logger) {
            logger.info(libraryResourceStrings_1.LibraryResourceStrings.loading(serviceHubConfigPath));
        }
        var result = require(serviceHubConfigPath);
        result.filePath = serviceHubConfigPath;
        if (!result.controller) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.ConfigurationError, libraryResourceStrings_1.LibraryResourceStrings.noValueForProperty(exports.serviceHubConfigFileName, dir, 'controller'));
        }
        if (!result.controller.args) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.ConfigurationError, exports.serviceHubConfigFileName + " in " + dir + " does not have a value for controller.args property");
        }
        result.controller = relativePath_1.expandDotRelativePaths(result.controller, path.dirname(serviceHubConfigPath), ['executable']);
        result.services = relativePath_1.expandDotRelativePaths(result.services, path.dirname(serviceHubConfigPath), ['rootDir']);
        result.hosts = relativePath_1.expandDotRelativePaths(result.hosts, path.dirname(serviceHubConfigPath), ['rootDir']);
        return getPipeName(result, logger, env)
            .then(function (pipeName) {
            pipeName = common_1.formatPipeName(pipeName);
            result.controller.pipeName = pipeName;
            result.controller.args = result.controller.args.map(function (arg) {
                return arg.replace(pipeToken, function () { return result.controller.pipeName; });
            });
            return result;
        });
    });
}
exports.loadConfig = loadConfig;
function getPipeName(config, logger, env) {
    // Use lower case SHA256 hash of a string created by concatenating following strings with pipeNameInputDelimiter
    // 1. config file path
    // 2. config file contents
    // 3. elevation status
    // 4. additional context that is not null or empty
    // 5. salt string on windows platform.
    // Elevation status and Username should be all lowercase to match with other ServiceHub clients like nodejs clients
    // (1) and (2) ensures apps that share ServiceHub config file also share the service hosts.
    // (3) ensures elevated and unelevated clients don't share ServiceHub instances.
    // (5) provides security by preventing windows users from connecting to each other's controller pipes.
    // On %nix platforms this pipename is used as a socket file name and we create this socket files under the current user's home dir.
    // As a result we automatically prevent pipe name collisions between different users as well as prevent users from accessing each other's controller pipes
    // and so don't need to include salt string in pipe name generation for *nix platforms.
    var pipeNameInputDelimiter = '//\\\\';
    var sha256Input = config.filePath;
    return q.ninvoke(fs, 'readFile', config.filePath, 'utf8')
        .then(function (data) {
        sha256Input += pipeNameInputDelimiter + data;
        return isElevated_1.default();
    })
        .then(function (elevated) {
        sha256Input += pipeNameInputDelimiter + (elevated ? 'elevated' : 'unelevated');
        if (config.controller.contextEnvironmentVariables) {
            for (var _i = 0, _a = config.controller.contextEnvironmentVariables; _i < _a.length; _i++) {
                var name_1 = _a[_i];
                var value = (env ? env[name_1] : process.env[name_1]);
                if (value) {
                    sha256Input += pipeNameInputDelimiter + value;
                }
            }
        }
        if (process.platform !== 'win32') {
            return sha256(sha256Input).toLowerCase();
        }
        return getUserSpecificSalt()
            .then(function (salt) {
            sha256Input += pipeNameInputDelimiter + salt;
            return sha256(sha256Input).toLowerCase();
        });
    });
}
var saltMaxRetryCount = 3;
function getUserSpecificSalt() {
    if (process.platform !== 'win32') {
        return q.resolve(null);
    }
    var userSaltFileDir = path.join(process.env['LocalAppData'], 'ServiceHub');
    var userSaltFilePath = path.join(userSaltFileDir, 'salt');
    var result = q.defer();
    var saltCurrentRetryCount = 0;
    function loop(error) {
        if (saltCurrentRetryCount === saltMaxRetryCount) {
            if (error) {
                return result.reject(new Error(libraryResourceStrings_1.LibraryResourceStrings.failedGetSaltString + ' ' + (error.message || error)));
            }
            else {
                return result.reject(new Error(libraryResourceStrings_1.LibraryResourceStrings.failedGetSaltString));
            }
        }
        saltCurrentRetryCount++;
        var checkSaltFileExists = q.defer();
        fs.exists(userSaltFilePath, checkSaltFileExists.resolve);
        checkSaltFileExists.promise.then(function (exists) {
            // return salt file contents if it exists
            if (exists) {
                return q.ninvoke(fs, 'readFile', userSaltFilePath, 'utf8')
                    .then(function (salt) { return result.resolve(salt); });
            }
            // try to create a new salt file
            var fd = null;
            return q.nfcall(mkdirp, userSaltFileDir)
                .then(function () { return q.ninvoke(fs, 'open', userSaltFilePath, 'wx'); })
                .then(function (fd) {
                // useCrypto API here since we use this random string as a salt string for
                // security to prevent windows users from predicting each other's controller pipes.
                return randomHexString_1.default(/* length */ 32, /* useCrypto */ true)
                    .then(function (salt) {
                    return q.ninvoke(fs, 'write', fd, salt, 'utf8')
                        .then(function () { return q.ninvoke(fs, 'close', fd); })
                        .then(function () { return result.resolve(salt); });
                });
            });
        })
            .done(function () { }, function (reason) { return loop(reason); });
    }
    loop();
    return result.promise;
}


},{"./common":2,"./findFile":8,"./isElevated":14,"./libraryResourceStrings":16,"./randomHexString":19,"./relativePath":20,"fs":undefined,"js-sha256":34,"mkdir-parents":38,"path":undefined,"q":44}],4:[function(require,module,exports){
"use strict";
var net = require('net');
var q_1 = require('q');
var common_1 = require('./common');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
var ec = require('errno-codes');
var defaultTimeoutMs = 5000;
var defaultRetryIntervalMs = 100;
function connectWithRetries(options) {
    if (!options) {
        throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variablesAreNotDefined('options'));
    }
    if (!options.url) {
        throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variablesAreNotDefined('options.url'));
    }
    var noRetryAfterDateTime = new Date().getTime() + (options.timeoutMs || defaultTimeoutMs);
    var retryIntervalMs = options.retryIntervalMs || defaultRetryIntervalMs;
    return common_1.getServerPipePath(options.url)
        .then(function (serverPath) { return netConnectWithTimeout(serverPath, noRetryAfterDateTime, retryIntervalMs, options.cancellationToken); });
}
exports.connectWithRetries = connectWithRetries;
function connect(url) {
    if (!url) {
        throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variablesAreNotDefined('url'));
    }
    return common_1.getServerPipePath(url)
        .then(function (serverPath) { return netConnect(serverPath); });
}
exports.connect = connect;
function netConnect(pipePath) {
    var result = q_1.defer();
    var stream = net.connect(pipePath);
    stream.once('connect', function () {
        result.resolve(stream);
    });
    stream.once('error', function (err) {
        result.reject(err);
    });
    return result.promise;
}
function netConnectWithTimeout(pipePath, noRetryAfterDateTime, retryIntervalMs, cancellationToken) {
    return netConnect(pipePath)
        .catch(function (err) {
        // We check for ec.ENOENT for the case where there is no controller running yet. We also need to check for ec.ECONNREFUSED for the case where
        // stale unix domain sockets files prevent clients from connecting. In both cases the controller will eventually come online and so we keep
        // trying to connect in both cases until timeout.
        var retryErrorCode = (err && (err.code === ec.ENOENT.code || err.code === ec.ECONNREFUSED.code));
        var cancellationNotRequested = (!cancellationToken || !cancellationToken.isCancellationRequested);
        if (retryErrorCode && cancellationNotRequested && new Date().getTime() < noRetryAfterDateTime) {
            return q_1.delay(retryIntervalMs)
                .then(function () { return netConnectWithTimeout(pipePath, noRetryAfterDateTime, retryIntervalMs, cancellationToken); });
        }
        throw err;
    });
}


},{"./common":2,"./libraryResourceStrings":16,"errno-codes":27,"net":undefined,"q":44}],5:[function(require,module,exports){
"use strict";
var q = require('q');
var q_1 = require('q');
var path = require('path');
var cp = require('child_process');
var os = require('os');
var vscode_jsonrpc_1 = require('vscode-jsonrpc');
var common_1 = require('./common');
var config_1 = require('./config');
var ExitCode_1 = require('./ExitCode');
var logger_1 = require('./logger');
var connect_1 = require('./connect');
var ec = require('errno-codes');
var debugController = false; // Set this to true to start controller in debug mode (with --debug-brk Node arg)
var connectTimeoutMs = debugController ? 100000000 : 5000;
var ControllerConnection = (function () {
    function ControllerConnection(options) {
        this.options = options;
        this.connectCts = new vscode_jsonrpc_1.CancellationTokenSource();
        this.options = options || {};
        this.options.clientName = this.options.clientName || 'hubControllerLookup';
        this.options.logger = this.options.logger || new logger_1.Logger(this.options.clientName);
        this.options.getConfig = this.options.getConfig || config_1.getConfig;
        this.options.getPipeName = this.options.getPipeName || common_1.getLocationServicePipeName;
        this.pipeName = this.options.getPipeName();
        this.deferredControllerExitCode = q_1.defer();
        this.controllerExitCode = this.deferredControllerExitCode.promise;
    }
    ControllerConnection.connect = function (options) {
        var connection = new ControllerConnection(options);
        return connection.connectImpl();
    };
    ControllerConnection.prototype.connectImpl = function () {
        var _this = this;
        var streamPromise;
        // If we're in ServiceHub host process, it must have environment variable 'ServiceHubLocationServicePipeName' set.
        // We use this environment to populate this.pipeName via getLocationServicePipeName().
        // If the pipe name is already known, this means we're running in context of service hub and there is no need to start another controller.
        if (this.pipeName) {
            // Since we don't start the controller, we may not know its exit code.
            this.deferredControllerExitCode.resolve(undefined);
            streamPromise = connect_1.connectWithRetries({ url: this.pipeName, timeoutMs: connectTimeoutMs });
        }
        else {
            streamPromise = this.startController();
        }
        return streamPromise
            .then(function (stream) {
            _this.stream = stream;
            _this.isConnected = true;
            return _this;
        });
    };
    ControllerConnection.prototype.startController = function () {
        var _this = this;
        return this.options.getConfig()
            .then(function (config) {
            _this.pipeName = config.controller.pipeName;
            // If we can connect immediately without starting new controller, don't bother to start it.
            var connectPromise = _this.options.dontTryConnectBeforeStartingController ? q.reject() : connect_1.connect(_this.pipeName);
            return connectPromise
                .then(function (stream) {
                // Since we could just connect and don't start the controller, we will not know its exit code.
                _this.deferredControllerExitCode.resolve(undefined);
                return stream;
            }, function (err) {
                // We could not connect. Start a new controller.
                var executable = config.controller.executable;
                var args = debugController ? ['--debug-brk', '--nolazy'].concat(config.controller.args) : config.controller.args;
                var processOptions = {
                    cwd: config.filePath ? path.dirname(config.filePath) : undefined // Set the working directory to the directory of the servicehub.config.json file.
                };
                if (config.controller.additionalEnvironmentVariables) {
                    processOptions.env = addControllerEnv(cloneProcessEnv(), config.controller.additionalEnvironmentVariables);
                }
                // On non-windows platform node's child processes can outlive the parent by default.
                if (os.platform() === 'win32') {
                    // We want to enable our controller process to continue running after this client terminates. But on windows platform node by default
                    // creates process jobs where terminating the parent terminates all its child processes. To create a detached child process node
                    // provides a options.detached flag which lets the controller to outlive this client process. However, there's an undesirable
                    // side effect of this - child processes launched by such a "detached" controller end up with visible console windows. To get around
                    // this problem we launch the controller indirectly from a batch file. This works because node explicity uses JOB_OBJECT_LIMIT_SILENT_BREAKAWAY_OK
                    // flag. So, only the immediate child processes are added to process job while their subprocesses are not. This technique enables controller
                    // to outlive this client without having the undesirable console window side effect.
                    // Node.js has an issue that cp.spawn fails on windows if both the command and the argument have spaces.
                    // https://github.com/nodejs/node-v0.x-archive/issues/25895
                    // This issue may manifest itself if the service hub is located under "Program Files", and the controller executable is also
                    // located under "Program Files", which is the most common case of the service hub layout.
                    // To work around this issue, use cmd /c call "{path to bootstrapper cmd}" "{config.controller.executable}" ...other args.
                    executable = path.join(process.env.WINDIR, 'system32', 'cmd.exe');
                    args = ['/s',
                        '/d',
                        '/c',
                        'call',
                        path.join(__dirname, 'launchController.cmd'),
                        config.controller.executable]
                        .concat(args)
                        .map(function (arg) { return arg.indexOf(' ') >= 0 ? '"' + arg + '"' : arg; });
                    processOptions.windowsVerbatimArguments = true; // Do not change quotes in the args
                }
                _this.options.logger.info("Starting Service Hub controller '" + executable + " " + args.join(' ') + "'.");
                _this.controllerProcess = cp.spawn(executable, args, processOptions);
                _this.controllerProcess.once('error', function (err) { return _this.onControllerProcessExited(0, null, err); });
                _this.controllerProcess.once('exit', function (code, signal) { return _this.onControllerProcessExited(code, signal); });
                logger_1.traceProcessOutput(_this.options.logger, _this.controllerProcess, 'HubController');
                return connect_1.connectWithRetries({ url: _this.pipeName, timeoutMs: connectTimeoutMs, cancellationToken: _this.connectCts.token })
                    .catch(function (err) {
                    throw _this.controllerError || err; // If connect fails, controller process error may provide more insights than the pipe error.
                });
            });
        });
    };
    ControllerConnection.prototype.onControllerProcessExited = function (exitCode, signal, err) {
        this.deferredControllerExitCode.resolve(exitCode);
        // Controller may exit because there is another controller running already.
        // This is expectected, not an error.
        if (exitCode === ExitCode_1.default.ErrorStartingServerPipeInUse) {
            return;
        }
        // Controller can eventually exit after we have connected, e.g. due to inactivity.
        // No point in cancelling the connection in this case.
        // However, we will log an error if the exit code was not 0, or if node couldn't start the process,
        // and a warning if the controller process was killed.
        if (this.isConnected) {
            if (err) {
                this.error("Hub Controller process could not start properly: " + err.message);
            }
            else if (signal) {
                this.options.logger.warn("Hub Controller process exited with signal '" + signal + "'.");
            }
            else if (exitCode !== ExitCode_1.default.Success) {
                var exitCodeMessage = "" + exitCode + (ExitCode_1.default[exitCode] ? " (" + ExitCode_1.default[exitCode] + ")" : '');
                this.error("Hub controller process exited with exit code " + exitCodeMessage + ".");
            }
            return;
        }
        var error;
        if (err) {
            error = new Error("Hub Controller process could not start properly: " + err.message);
            error.inner = err;
        }
        else if (signal) {
            error = new Error("Hub Controller process exited prematurely with signal '" + signal + "'.");
            error.signal = signal;
        }
        else {
            var exitCodeMessage = "" + exitCode + (ExitCode_1.default[exitCode] ? " (" + ExitCode_1.default[exitCode] + ")" : '');
            error = new Error("Hub Controller process exited prematurely with exit code " + exitCodeMessage + ".");
            error.exitCode = exitCode;
        }
        this.error(error.message);
        this.controllerError = error;
        // No point in trying to connect to the Hub Controller pipe if the process has exited prematurely.
        this.connectCts.cancel();
    };
    ControllerConnection.prototype.error = function (message) {
        this.options.logger.error(message);
    };
    return ControllerConnection;
}());
exports.ControllerConnection = ControllerConnection;
function cloneProcessEnv() {
    var clonedEnv = {};
    for (var env in process.env) {
        clonedEnv[env] = process.env[env];
    }
    return clonedEnv;
}
function addControllerEnv(targetEnv, controllerEnv) {
    for (var env in controllerEnv) {
        targetEnv[env] = controllerEnv[env];
    }
    return targetEnv;
}


},{"./ExitCode":1,"./common":2,"./config":3,"./connect":4,"./logger":18,"child_process":undefined,"errno-codes":27,"os":undefined,"path":undefined,"q":44,"vscode-jsonrpc":60}],6:[function(require,module,exports){
"use strict";
var q = require('q');
var q_1 = require('q');
var jsonRpc_1 = require('./jsonRpc');
var hubClient_1 = require('./hubClient');
var DiscoveryServiceProxy = (function () {
    function DiscoveryServiceProxy(logger, locationService, discoveryService) {
        var clientName = 'hubController-' + discoveryService;
        var hubClient = new hubClient_1.HubClientInternal(clientName, logger, function () { return q_1.resolve(locationService); });
        this.endpoint = q(hubClient.requestService(discoveryService))
            .then(function (stream) { return jsonRpc_1.JsonRpcConnection.attach(stream, logger); });
    }
    DiscoveryServiceProxy.prototype.discoverService = function (service) {
        return this.endpoint.then(function (ep) { return ep.sendRequest('discoverService', [service]); });
    };
    DiscoveryServiceProxy.prototype.end = function () {
        return this.endpoint.then(function (ep) { return ep.dispose(); });
    };
    return DiscoveryServiceProxy;
}());
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = DiscoveryServiceProxy;


},{"./hubClient":12,"./jsonRpc":15,"q":44}],7:[function(require,module,exports){
arguments[4][1][0].apply(exports,arguments)
},{"dup":1}],8:[function(require,module,exports){
"use strict";
var glob = require('glob');
var path = require('path');
var q_1 = require('q');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
function findFile(globPattern, options) {
    if (!globPattern) {
        throw new Error(libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('globPattern'));
    }
    options = options || {};
    options.cwd = options.cwd || process.cwd();
    return findImpl(globPattern, options);
}
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = findFile;
var promisingGlob = q_1.denodeify(glob);
function findImpl(globPattern, options) {
    return promisingGlob(globPattern, options)
        .then(function (foundFiles) {
        if (foundFiles.length > 0) {
            var foundPaths = foundFiles.map(function (file) { return path.join(options.cwd, file); });
            if (options.fileSelector) {
                return options.fileSelector(foundPaths);
            }
            if (foundPaths.length === 1) {
                return foundPaths[0];
            }
            throw new Error(libraryResourceStrings_1.LibraryResourceStrings.multipleFileFound(options.cwd, foundFiles.map(function (f) { return ("'" + f + "'"); }).join(', ')));
        }
        else {
            if (!options.goUp) {
                return q_1.resolve(null);
            }
            var parentDir = path.dirname(options.cwd);
            // If parentDir is already root, its dirname() will return the same string
            if (parentDir === options.cwd) {
                return q_1.resolve(null);
            }
            options.cwd = parentDir;
            return findImpl(globPattern, options);
        }
    });
}


},{"./libraryResourceStrings":16,"glob":29,"path":undefined,"q":44}],9:[function(require,module,exports){
"use strict";
/** Tokens that dev hub recognizes in IHubHostInfo.hostArgs */
var HostArgsToken = (function () {
    function HostArgsToken() {
    }
    /** Host Id */
    HostArgsToken.HostId = '$HOSTID';
    /** Host callback pipe name */
    HostArgsToken.Pipe = '$PIPE';
    return HostArgsToken;
}());
exports.HostArgsToken = HostArgsToken;
/** Methods that dev hub can call on the host */
var HostMethod = (function () {
    function HostMethod() {
    }
    HostMethod.StartService = 'startService';
    HostMethod.Exit = 'exit';
    return HostMethod;
}());
exports.HostMethod = HostMethod;


},{}],10:[function(require,module,exports){
// Hub Controller
// Standalone js app that hosts ServiceHub Location Service and listens on a pipe for service requests.
// The pipe name can be provided as the first argument (process.argv[2] in node.js)
//
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var locationService_1 = require('../locationService');
var c = require('../common');
var cfg = require('../config');
var logger_1 = require('../logger');
var jsonRpc_1 = require('../jsonRpc');
var exitCode_1 = require('../exitCode');
var controllerResourceStrings_1 = require('./controllerResourceStrings');
var connect_1 = require('../connect');
var ec = require('errno-codes');
c.registerForCrashReporting(/* crashFileLogPrefix */ 'ControllerCrash');
c.setOsLocale([controllerResourceStrings_1.ControllerResourceStrings.config]);
var HubController = (function (_super) {
    __extends(HubController, _super);
    function HubController(logger, config, cleanUpOldLogsTimerId) {
        _super.call(this, logger, config);
        this.controllerCooldownMs = 10 * 1000;
        this.lastAccessTimeMs = new Date().getTime();
        // Start controller cooldown immediately, to account for the case
        // when clients starts the hub controller but don't connect to it.
        this.onLastHostDisconnected();
        this.cleanUpOldLogsTimerId = cleanUpOldLogsTimerId;
    }
    HubController.prototype.locate = function (service, clientInfo) {
        this.setLastAccessTime();
        var serviceDescriptor = typeof service === 'string' ? { name: service } : service;
        return _super.prototype.locate.call(this, serviceDescriptor, clientInfo);
    };
    HubController.prototype.exit = function (reason) {
        var _this = this;
        this.logger.info(reason ? controllerResourceStrings_1.ControllerResourceStrings.exitingHubControllerWithReason(reason) : controllerResourceStrings_1.ControllerResourceStrings.exitingHubController);
        if (this.cleanUpOldLogsTimerId) {
            global.clearTimeout(this.cleanUpOldLogsTimerId);
        }
        if (this.controllerShutdownTimer) {
            global.clearTimeout(this.controllerShutdownTimer);
        }
        this.stop()
            .then(function () {
            if (process.platform !== 'win32') {
                return c.deleteUnixSocketDir();
            }
        })
            .done(function () { return process.exit(); }, function (reason) {
            _this.logger.error(controllerResourceStrings_1.ControllerResourceStrings.errorShuttingDownHosts(reason.message || reason));
            process.exit(exitCode_1.default.ShutdownError);
        });
    };
    /** Instrumentation: start heap diffing */
    HubController.prototype.startHeapDiff = function () {
        if (this.heapDiff) {
            throw new Error('Call endHeapDiff() first before calling this method.');
        }
        this.memwatch = this.memwatch || require('memwatch-next');
        this.heapDiff = new this.memwatch.HeapDiff();
    };
    /** Instrumentation: end heap diffing and return heap diff */
    HubController.prototype.endHeapDiff = function () {
        if (!this.heapDiff) {
            throw new Error('Call startHeapDiff() first before calling this method.');
        }
        var result = this.heapDiff.end();
        this.heapDiff = null;
        return result;
    };
    /** Instrumentation: run GC on Hub controller */
    HubController.prototype.runGC = function () {
        try {
            global.gc();
        }
        catch (e) {
            throw new Error('You must run Hub Controller with \'--expose-gc\' node argument');
        }
    };
    /** Instrumentation: capture heap dump */
    HubController.prototype.captureHeapDump = function (filePath) {
        var heapdump = require('heapdump');
        heapdump.writeSnapshot(filePath);
    };
    /** Instrumentation: get hub controller pid */
    HubController.prototype.getHubControllerPid = function () {
        return process.pid;
    };
    HubController.prototype.onHostConnected = function () {
        this.hostsConnected = true;
        this.setLastAccessTime();
        _super.prototype.onHostConnected.call(this);
    };
    HubController.prototype.onLastHostDisconnected = function () {
        this.hostsConnected = false;
        if (this.isInFastShutdown) {
            this.exit(controllerResourceStrings_1.ControllerResourceStrings.allExternalClientsDisconnected);
        }
        else {
            if (this.controllerShutdownTimer) {
                global.clearTimeout(this.controllerShutdownTimer);
            }
            this.controllerShutdownTimer = global.setTimeout(this.shutdownInactiveController.bind(this), this.controllerCooldownMs);
        }
        _super.prototype.onLastHostDisconnected.call(this);
    };
    ;
    HubController.prototype.setLastAccessTime = function () {
        this.lastAccessTimeMs = new Date().getTime();
    };
    HubController.prototype.shutdownInactiveController = function () {
        if (this.hostsConnected) {
            return;
        }
        var currentTime = new Date().getTime();
        if (this.lastAccessTimeMs < currentTime - this.controllerCooldownMs) {
            // The controller is inactive and no host has started or service located there since the cooldown begin.
            this.exit(controllerResourceStrings_1.ControllerResourceStrings.inactivity);
        }
        else {
            // The controller is inactive but there was some service being located there during the cooldown period.
            // Start another cooldown period to account for the new service.
            this.onLastHostDisconnected();
        }
    };
    return HubController;
}(locationService_1.LocationService));
var name = 'hubController';
var logger = new logger_1.Logger(name);
if (process.argv.length !== 3) {
    console.error(controllerResourceStrings_1.ControllerResourceStrings.InvalidCommandLine(__filename));
    logger.error("Invalid command line: '" + process.argv.map(function (arg) { return arg.indexOf(' ') >= 0 ? '"' + arg + '"' : arg; }).join(' ') + "''");
    process.exit(exitCode_1.default.InvalidArgument);
}
var delayInMsecBeforeStartingLogCleanup = 5000;
var deleteLogFilesNotUsedInNumberOfDays = 7;
// set deleteLogFilesOlderThanDate to be a week old
var deleteLogFilesOlderThanDate = new Date();
deleteLogFilesOlderThanDate.setDate(deleteLogFilesOlderThanDate.getDate() - deleteLogFilesNotUsedInNumberOfDays);
var cleanUpOldLogsTimerId = logger_1.cleanUpOldLogs(delayInMsecBeforeStartingLogCleanup, deleteLogFilesOlderThanDate);
var options;
// Set the lookup directory for servicehub.config.json to be the current process directory.
// The clients must set the process working directory appropriately.
cfg.configDir = process.cwd();
cfg.getConfig(logger)
    .catch(function (err) { logErrorAndExit(err, exitCode_1.default.ConfigurationError); return null; })
    .then(function (config) {
    var controller = new HubController(logger, config, cleanUpOldLogsTimerId);
    options = {
        name: name,
        pipeName: process.argv[2],
        logger: logger,
        onErrorCb: function (e) { return retryStartServer(e, controller, logger, /* retryStartingController */ true); }
    };
    // Set location service pipe name as process-level environment variable.
    // When the location service spawns a new host, it'll pass it to the host process.
    c.setLocationServicePipeName(options.pipeName);
    startServer(options, controller, logger);
})
    .catch(function (err) { return logErrorAndExit(err, exitCode_1.default.ErrorStartingServer); })
    .done();
function retryStartServer(e, controller, logger, retryStartingController) {
    if (e.code === ec.EADDRINUSE.code) {
        // It appears another controller already running.
        if (process.platform === 'win32' || !retryStartingController) {
            logger.info("Terminating controller because it's already running. retryStartingController flag=" + retryStartingController);
            process.exit(exitCode_1.default.ErrorStartingServerPipeInUse);
        }
        options.onErrorCb = function (e) { return retryStartServer(e, controller, logger, /* retryStartingController */ false); };
        // On *nix platforms sometimes there can be a stale unix socket file that can trick us into assuming the controller is already running.
        // So, let's verify that there's really a controller running by trying to connect to it just like any client would.
        logger.info('Controller appears to be already running. Verifying it is not a stale socket file by trying to connect to it just like any client would.');
        connect_1.connect(options.pipeName)
            .then(function () {
            // Another controller is really running
            logger.info("Terminating controller because we verified it's already running");
            process.exit(exitCode_1.default.ErrorStartingServerPipeInUse);
        }, function (err) { return clearSocketFilesAndStartServer(options, controller, logger); });
    }
    else {
        logger.error("Terminating controller due to some unknown error: " + e.message);
        process.exit(exitCode_1.default.ErrorStartingServer);
    }
}
function clearSocketFilesAndStartServer(options, controller, logger) {
    if (process.platform === 'win32') {
        var errorMsg = 'clearSocketFilesAndStartServer method cannot be called on win32 platform';
        logger.error(errorMsg);
        throw new Error(errorMsg);
    }
    logger.info("Cleaning up stale socket files");
    c.deleteUnixSocketDir()
        .then(function () {
        logger.info("Attempting to start controller again");
        startServer(options, controller, logger);
    })
        .done();
}
function startServer(options, controller, logger) {
    var endPoints = [];
    c.serverManager.startService(options, function (stream) {
        // Keep a reference to the end point so it is not garbage collected.
        var endPoint = jsonRpc_1.JsonRpcConnection.attach(stream, logger, controller, [
            'locate',
            'getSessionId',
            'exit',
            // Instrumentation entry points
            'startHeapDiff',
            'endHeapDiff',
            'runGC',
            'captureHeapDump',
            'getHubControllerPid',
        ]);
        endPoints.push(endPoint);
        endPoint.onClose(function (e) {
            var index = endPoints.indexOf(endPoint);
            if (index >= 0) {
                endPoints.splice(index, 1);
            }
        });
    })
        .catch(function (err) { return logErrorAndExit(err, exitCode_1.default.ErrorStartingServer); })
        .done();
}
function logErrorAndExit(err, exitCode) {
    exitCode = exitCode || exitCode_1.default.UncaughtException;
    var logMessage = err.stack ?
        controllerResourceStrings_1.ControllerResourceStrings.uncaughtExceptionWithStack(exitCode.toString(), err.message || err, err.stack) :
        controllerResourceStrings_1.ControllerResourceStrings.uncaughtException(exitCode.toString(), err.message || err);
    logger.error(logMessage);
    process.exit(exitCode);
}


},{"../common":2,"../config":3,"../connect":4,"../exitCode":7,"../jsonRpc":15,"../locationService":17,"../logger":18,"./controllerResourceStrings":11,"errno-codes":27,"heapdump":"heapdump","memwatch-next":"memwatch-next"}],11:[function(require,module,exports){
"use strict";
var nls = require('vscode-nls');
var path = require('path');
var defaultLocale = 'en';
// nls.config(...)() call below will be rewritten to nls.config(...)(__filename) in build time where __filename is supposed to '*ResourceStrings.js'
// so that nls can find *ResourceStrings.nls.json.
// Redefining __filename here because when using browserify, otherwise the __filename will point to browserified file instead of this file.
var __filename = path.join(__dirname, 'controllerResourceStrings.js');
var localize = nls.config({ locale: defaultLocale, cacheLanguageResolution: false })(__filename);
var ControllerResourceStrings = (function () {
    function ControllerResourceStrings() {
    }
    ControllerResourceStrings.config = function (locale, cache) {
        if (cache === void 0) { cache = false; }
        // nls.config(...)() call below will be rewritten to nls.config(...)(__filename) in build time where __filename is supposed to '*ResourceStrings.js'
        // so that nls can find *ResourceStrings.nls.json.
        // Redefining __filename here because when using browserify, otherwise the __filename will point to browserified file instead of this file.
        var __filename = path.join(__dirname, 'controllerResourceStrings.js');
        localize = nls.config({ locale: locale, cacheLanguageResolution: cache })(__filename);
    };
    Object.defineProperty(ControllerResourceStrings, "exitingHubController", {
        get: function () {
            return localize(0, null);
        },
        enumerable: true,
        configurable: true
    });
    ControllerResourceStrings.exitingHubControllerWithReason = function (reason) {
        return localize(1, null, reason);
    };
    ControllerResourceStrings.errorShuttingDownHosts = function (reason) {
        return localize(2, null, reason);
    };
    Object.defineProperty(ControllerResourceStrings, "inactivity", {
        get: function () {
            return localize(3, null);
        },
        enumerable: true,
        configurable: true
    });
    ControllerResourceStrings.uncaughtExceptionWithStack = function (errorCode, errorMessage, errorStack) {
        return localize(4, null, errorCode, errorMessage, errorStack);
    };
    ControllerResourceStrings.uncaughtException = function (errorCode, errorMessage) {
        return localize(5, null, errorCode, errorMessage);
    };
    ControllerResourceStrings.InvalidCommandLine = function (hubController) {
        return localize(6, null, hubController);
    };
    Object.defineProperty(ControllerResourceStrings, "allExternalClientsDisconnected", {
        get: function () {
            return localize(7, null);
        },
        enumerable: true,
        configurable: true
    });
    return ControllerResourceStrings;
}());
exports.ControllerResourceStrings = ControllerResourceStrings;

},{"path":undefined,"vscode-nls":64}],12:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var path = require('path');
var fs = require('fs');
var q_1 = require('q');
var logger_1 = require('./logger');
var connect_1 = require('./connect');
var hubLookup_1 = require('./hubLookup');
var config_1 = require('./config');
var common_1 = require('./common');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
var ec = require('errno-codes');
var requestServiceMaxRetries = 40;
var requestServiceRetryDelayMs = 100;
var HubClient = (function () {
    function HubClient(clientName, logger, serviceHubConfigFilePath) {
        var _this = this;
        this.clientName = clientName || 'client';
        this._logger = logger || new logger_1.Logger(this.clientName);
        if (!serviceHubConfigFilePath) {
            this.hubLookup = new hubLookup_1.HubLookup();
        }
        else {
            if (!path.isAbsolute(serviceHubConfigFilePath)) {
                throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.serviceHubConfigFilePathIsNotAbsolute(serviceHubConfigFilePath));
            }
            if (path.basename(serviceHubConfigFilePath) !== config_1.serviceHubConfigFileName) {
                throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.serviceHubConfigFileNameIsIncorrect(serviceHubConfigFilePath));
            }
            if (!fs.existsSync(serviceHubConfigFilePath)) {
                throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.serviceHubConfigFileDoesNotExist(serviceHubConfigFilePath));
            }
            this.hubLookup = new hubLookup_1.HubLookup({
                getConfig: function () { return config_1.loadConfig(path.dirname(serviceHubConfigFilePath), _this._logger); }
            });
        }
        this.locationServiceFactory = this.hubLookup.getLocationService.bind(this.hubLookup);
    }
    Object.defineProperty(HubClient.prototype, "logger", {
        get: function () {
            return this._logger;
        },
        enumerable: true,
        configurable: true
    });
    ;
    HubClient.prototype.getSessionId = function () {
        this.throwIfDisposed();
        return this.locationServiceFactory()
            .then(function (ls) { return ls.getSessionId(); });
    };
    HubClient.prototype.requestService = function (service) {
        var _this = this;
        if (!service) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('service'));
        }
        this.throwIfDisposed();
        var serviceDescriptor = typeof service === 'string' ? { name: service } : service;
        return this.requestServiceWithRetries(serviceDescriptor, requestServiceMaxRetries)
            .then(function (serviceConnection) {
            _this.startClientWatch(serviceConnection.clientWatch);
            return serviceConnection.stream;
        });
    };
    HubClient.prototype.disposeAsync = function () {
        this.disposed = true;
        return this.hubLookup.disposeAsync();
    };
    HubClient.prototype.requestServiceWithRetries = function (serviceDescriptor, retries) {
        var _this = this;
        return this.locationServiceFactory()
            .then(function (ls) { return ls.locate(serviceDescriptor, { clientName: _this.clientName, pid: process.pid }); })
            .then(function (location) {
            return connect_1.connect(location.location)
                .then(function (stream) { return { stream: stream, clientWatch: location.clientWatch }; });
        })
            .catch(function (err) {
            // If the service host has shut down when we're requesting a service there,
            // request the service again.
            if (err.code === ec.ENOENT.code && retries > 1) {
                // Delay the next attempt to give host enough time to start the service.
                return q_1.delay(requestServiceRetryDelayMs)
                    .then(function () { return _this.requestServiceWithRetries(serviceDescriptor, retries - 1); });
            }
            throw err;
        });
    };
    HubClient.prototype.throwIfDisposed = function () {
        if (this.disposed) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.ObjectDisposed);
        }
    };
    HubClient.prototype.startClientWatch = function (clientWatch) {
        var _this = this;
        if (clientWatch && !HubClient.clientWatchStreams[clientWatch]) {
            HubClient.clientWatchStreams[clientWatch] = connect_1.connectWithRetries({ url: clientWatch, timeoutMs: 1000 })
                .then(function (stream) {
                _this.logger.info("Connected to Hub Controller's client watch '" + clientWatch + "'");
                stream.once('end', function () { delete HubClient.clientWatchStreams[clientWatch]; });
                return stream;
            }, function (err) {
                _this.logger.error("Error connecting to Hub Controller's client watch '" + clientWatch + "': " + err.message);
                delete HubClient.clientWatchStreams[clientWatch];
                return null;
            });
        }
    };
    HubClient.clientWatchStreams = {};
    return HubClient;
}());
exports.HubClient = HubClient;
var HubClientInternal = (function (_super) {
    __extends(HubClientInternal, _super);
    function HubClientInternal(clientName, logger, locationServiceFactory) {
        _super.call(this, clientName, logger);
        this.locationServiceFactory = locationServiceFactory;
    }
    return HubClientInternal;
}(HubClient));
exports.HubClientInternal = HubClientInternal;
var HubClientInternal2 = (function (_super) {
    __extends(HubClientInternal2, _super);
    function HubClientInternal2(clientName, logger, serviceHubConfigFilePath) {
        _super.call(this, clientName, logger, serviceHubConfigFilePath);
    }
    HubClientInternal2.prototype.getConfig = function () {
        return this.hubLookup.getConfig();
    };
    HubClientInternal2.prototype.stopHubController = function () {
        return this.hubLookup.stopHubController();
    };
    HubClientInternal2.prototype.exit = function () {
        var _this = this;
        var exitCode;
        return this.stopHubController()
            .then(function (code) {
            exitCode = code;
            return _this.disposeAsync();
        })
            .catch(function (err) {
            if (err.code !== ec.ENOENT.code) {
                throw err;
            }
        })
            .then(function () { return exitCode; });
    };
    HubClientInternal2.prototype.startHeapDiff = function () {
        return this.locationServiceFactory()
            .then(function (ls) { return ls.startHeapDiff(); });
    };
    HubClientInternal2.prototype.endHeapDiff = function () {
        return this.locationServiceFactory()
            .then(function (ls) { return ls.endHeapDiff(); });
    };
    HubClientInternal2.prototype.runGC = function () {
        return this.locationServiceFactory()
            .then(function (ls) { return ls.runGC(); });
    };
    HubClientInternal2.prototype.captureHeapDump = function (filePath) {
        return this.locationServiceFactory()
            .then(function (ls) { return ls.captureHeapDump(filePath); });
    };
    HubClientInternal2.prototype.getHubControllerPid = function () {
        return this.locationServiceFactory()
            .then(function (ls) { return ls.getHubControllerPid(); });
    };
    return HubClientInternal2;
}(HubClient));
exports.HubClientInternal2 = HubClientInternal2;


},{"./common":2,"./config":3,"./connect":4,"./hubLookup":13,"./libraryResourceStrings":16,"./logger":18,"errno-codes":27,"fs":undefined,"path":undefined,"q":44}],13:[function(require,module,exports){
"use strict";
var q_1 = require('q');
var logger_1 = require('./logger');
var jsonRpc_1 = require('./jsonRpc');
var locationService_1 = require('./locationService');
var controllerConnection_1 = require('./controllerConnection');
var common_1 = require('./common');
var ec = require('errno-codes');
var HubLookup = (function () {
    function HubLookup(options) {
        this.options = options || {};
        this.options.clientName = this.options.clientName || 'hubLookup';
        this.options.logger = this.options.logger || new logger_1.Logger(this.options.clientName);
    }
    HubLookup.prototype.getLocationService = function () {
        var _this = this;
        this.throwIfDisposed();
        if (!this.locationService) {
            this.locationService = controllerConnection_1.ControllerConnection.connect(this.options)
                .then(function (connection) {
                _this.connection = connection;
                var rpc = jsonRpc_1.JsonRpcConnection.attach(connection.stream, _this.options.logger);
                rpc.onClose(_this.resetLocationService, _this);
                return new locationService_1.LocationServiceProxy(rpc);
            }, function (err) {
                _this.resetLocationService();
                throw err;
            });
        }
        return this.locationService;
    };
    HubLookup.prototype.getConfig = function () {
        return this.options.getConfig();
    };
    HubLookup.prototype.stopHubController = function () {
        var _this = this;
        return q_1.resolve(this.locationService)
            .then(function (ls) { return ls ? ls.stop() : null; })
            .then(function () { return _this.connection ? _this.connection.controllerExitCode : undefined; });
    };
    HubLookup.prototype.disposeAsync = function () {
        this.disposed = true;
        return q_1.resolve(this.locationService)
            .then(function (ls) { return ls ? ls.dispose() : undefined; });
    };
    HubLookup.prototype.resetLocationService = function () {
        this.locationService = null;
    };
    HubLookup.prototype.throwIfDisposed = function () {
        if (this.disposed) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.ObjectDisposed);
        }
    };
    return HubLookup;
}());
exports.HubLookup = HubLookup;


},{"./common":2,"./controllerConnection":5,"./jsonRpc":15,"./locationService":17,"./logger":18,"errno-codes":27,"q":44}],14:[function(require,module,exports){
"use strict";
var child_process_1 = require('child_process');
var path = require('path');
var q_1 = require('q');
// TODO: Switch back to NPM is-elevated when https://github.com/sindresorhus/is-admin/issues/2 is fixed.
function isElevated() {
    try {
        if (process.platform !== 'win32') {
            // On Linux and OSX Superuser privilege is UID=0.
            return q_1.resolve(process.getuid && process.getuid() === 0);
        }
        // net.exe is usually on PATH. But it's not guaranteed.
        // Use more reliable built-in %SystemRoot% environment instead.
        var netPath = path.join(process.env.SystemRoot, 'System32', 'net.exe');
        var result_1 = q_1.defer();
        // execFile expects PATH to always have some value. It fails if PATH is empty.
        // So if PATH is empty, construct it artificially to point to SystemRoot.
        var env_1;
        if (process.env.PATH) {
            env_1 = process.env;
        }
        else {
            env_1 = {};
            Object.keys(process.env).forEach(function (k) { return env_1[k] = process.env[k]; });
            env_1.PATH = process.env.SystemRoot + ';';
        }
        // Use 'net session' to check if the process is elevated http://stackoverflow.com/a/11995662/64949
        child_process_1.execFile(netPath, ['session'], { env: env_1, maxBuffer: 10 * 1024 * 1024 }, function (err) { return result_1.resolve(!err); });
        return result_1.promise;
    }
    catch (err) {
        return q_1.reject(err);
    }
}
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = isElevated;
;


},{"child_process":undefined,"path":undefined,"q":44}],15:[function(require,module,exports){
"use strict";
var vscode_jsonrpc_1 = require('vscode-jsonrpc');
exports.Trace = vscode_jsonrpc_1.Trace;
exports.CancellationToken = vscode_jsonrpc_1.CancellationToken;
exports.CancellationTokenSource = vscode_jsonrpc_1.CancellationTokenSource;
var vscode = require('vscode-jsonrpc');
var q = require('q');
var q_1 = require('q');
var logger_1 = require('./logger');
var ec = require('errno-codes');
var JsonRpcConnection = (function () {
    function JsonRpcConnection(stream, logger) {
        this.stream = stream;
        this.logger = logger;
        this.requests = {};
        this.requestCount = 0;
        this.connection = vscode.createClientMessageConnection(stream, stream, logger);
        this.onClose = this.connection.onClose;
        this.connection.onClose(this.onConnectionClosed, this);
        this.onError = this.connection.onError;
        if (logger && logger.isEnabled(logger_1.LogLevel.Verbose)) {
            this.connection.trace(vscode_jsonrpc_1.Trace.Verbose, logger);
        }
    }
    JsonRpcConnection.attach = function (stream, logger, target, methodNames) {
        var connection = new JsonRpcConnection(stream, logger);
        if (target) {
            connection.onRequestInvokeTarget.apply(connection, [target].concat(methodNames));
        }
        connection.listen();
        return connection;
    };
    JsonRpcConnection.prototype.listen = function () {
        this.throwIfClosed();
        this.throwIfListening();
        this.connection.listen();
        this.listening = true;
    };
    JsonRpcConnection.prototype.sendRequest = function (method, params, token) {
        var _this = this;
        this.throwIfNotListening();
        if (this.closed) {
            return q.reject(JsonRpcConnection.createStreamClosedError(method));
        }
        var deferred = q_1.defer();
        var requestIndex = this.requestCount++;
        this.requests[requestIndex] = { method: method, deferred: deferred };
        this.connection
            .sendRequest({ 'method': method }, params, token)
            .then(function (value) {
            deferred.resolve(value);
            delete _this.requests[requestIndex];
        }, function (error) {
            deferred.reject(error);
            delete _this.requests[requestIndex];
        });
        return deferred.promise;
    };
    JsonRpcConnection.prototype.sendNotification = function (method, params) {
        if (this.closed) {
            return q.reject(JsonRpcConnection.createStreamClosedError(method));
        }
        this.connection.sendNotification({ 'method': method }, params);
        // Eventually we'll want to return a promise that is fulfilled after transmission has completed.
        return q(undefined);
    };
    JsonRpcConnection.prototype.onRequest = function (method, handler) {
        this.throwIfListening();
        this.throwIfClosed();
        this.connection.onRequest({ 'method': method }, function (args, ct) { return handler.apply(void 0, (args || []).concat([ct])); });
        this.connection.onNotification({ 'method': method }, function (args) { return handler.apply(void 0, args); });
    };
    JsonRpcConnection.prototype.onRequestInvokeTarget = function (target) {
        var _this = this;
        var methodNames = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            methodNames[_i - 1] = arguments[_i];
        }
        this.throwIfListening();
        this.throwIfClosed();
        if (!methodNames || methodNames.length === 0) {
            methodNames = getMethodNamesOf(target);
        }
        methodNames.forEach(function (methodName) {
            var method = target[methodName];
            if (!method)
                throw new Error("Method not found " + methodName + ".");
            _this.onRequest(methodName, method.bind(target));
        });
    };
    JsonRpcConnection.prototype.dispose = function () {
        // Reject any pending outbound requests that haven't resolved already, since we won't get responses here on out.
        // TODO: code here, or get fix for https://github.com/Microsoft/vscode-languageserver-node/issues/65
        this.stream.end();
        this.connection.dispose();
    };
    JsonRpcConnection.prototype.cancelPendingRequests = function (reason) {
        for (var propName in this.requests) {
            if (this.requests.hasOwnProperty(propName)) {
                var request = this.requests[propName];
                request.deferred.reject(reason || JsonRpcConnection.createStreamClosedError(request.method));
            }
        }
        this.requests = {};
    };
    JsonRpcConnection.prototype.throwIfNotListening = function () {
        if (!this.listening) {
            throw new Error('Call listen() first.');
        }
    };
    JsonRpcConnection.prototype.throwIfListening = function () {
        if (this.listening) {
            throw new Error('listen() has already been called.');
        }
    };
    JsonRpcConnection.prototype.throwIfClosed = function (method) {
        if (this.closed) {
            throw JsonRpcConnection.createStreamClosedError(method);
        }
    };
    JsonRpcConnection.prototype.onConnectionClosed = function () {
        this.closed = true;
        this.cancelPendingRequests();
    };
    JsonRpcConnection.createStreamClosedError = function (method) {
        var message = (method ? "Cannot execute '" + method + "'. " : '') + 'The underlying stream has closed.';
        var result = new Error(message);
        result.code = ec.ENOENT.code;
        return result;
    };
    return JsonRpcConnection;
}());
exports.JsonRpcConnection = JsonRpcConnection;
function getMethodNamesOf(target) {
    var methods = [];
    for (var propertyName in target) {
        var propertyValue = target[propertyName];
        if (typeof propertyValue === 'function') {
            methods.push(propertyName);
        }
    }
    return methods;
}


},{"./logger":18,"errno-codes":27,"q":44,"vscode-jsonrpc":60}],16:[function(require,module,exports){
"use strict";
var c = require('./common');
var nls = require('vscode-nls');
var path = require('path');
var defaultLocale = 'en';
// nls.config(...)() call below will be rewritten to nls.config(...)(__filename) in build time where __filename is supposed to '*ResourceStrings.js'
// so that nls can find *ResourceStrings.nls.json.
// Redefining __filename here because when using browserify, otherwise the __filename will point to browserified file instead of this file.
var __filename = path.join(__dirname, 'libraryResourceStrings.js');
var localize = nls.config({ locale: defaultLocale, cacheLanguageResolution: false })(__filename);
var LibraryResourceStrings = (function () {
    function LibraryResourceStrings() {
    }
    LibraryResourceStrings.init = function () {
        if (!LibraryResourceStrings.isOsLocaleSet) {
            c.setOsLocale([LibraryResourceStrings.config]);
            LibraryResourceStrings.isOsLocaleSet = true;
        }
    };
    LibraryResourceStrings.config = function (locale, cache) {
        if (cache === void 0) { cache = false; }
        // nls.config(...)() call below will be rewritten to nls.config(...)(__filename) in build time where __filename is supposed to '*ResourceStrings.js'
        // so that nls can find *ResourceStrings.nls.json.
        // Redefining __filename here because when using browserify, otherwise the __filename will point to browserified file instead of this file.
        var __filename = path.join(__dirname, 'libraryResourceStrings.js');
        localize = nls.config({ locale: locale, cacheLanguageResolution: cache })(__filename);
    };
    LibraryResourceStrings.variablesAreNotDefined = function (variable) {
        LibraryResourceStrings.init();
        return localize(0, null, variable);
    };
    LibraryResourceStrings.variableIsNotDefined = function (variable) {
        LibraryResourceStrings.init();
        return localize(1, null, variable);
    };
    LibraryResourceStrings.startingServer = function (name, url, serverPath) {
        LibraryResourceStrings.init();
        return localize(2, null, name, url, serverPath);
    };
    LibraryResourceStrings.stoppedServer = function (name, url) {
        LibraryResourceStrings.init();
        return localize(3, null, name, url);
    };
    LibraryResourceStrings.urlShouldStartWith = function (scheme) {
        LibraryResourceStrings.init();
        return localize(4, null, scheme);
    };
    LibraryResourceStrings.urlHasNoPipeName = function (scheme) {
        LibraryResourceStrings.init();
        return localize(5, null, scheme);
    };
    LibraryResourceStrings.noPipeName = function (scheme) {
        LibraryResourceStrings.init();
        return localize(6, null, scheme);
    };
    LibraryResourceStrings.errorParsingJson = function (filePath, err) {
        LibraryResourceStrings.init();
        return localize(7, null, filePath, err);
    };
    LibraryResourceStrings.serviceHubConfigJsonNotFound = function (fileName, dir) {
        LibraryResourceStrings.init();
        return localize(8, null, fileName, dir);
    };
    LibraryResourceStrings.loading = function (path) {
        LibraryResourceStrings.init();
        return localize(9, null, path);
    };
    LibraryResourceStrings.noValueForProperty = function (fileName, dir, property) {
        LibraryResourceStrings.init();
        return localize(10, null, fileName, dir, property);
    };
    Object.defineProperty(LibraryResourceStrings, "failedGetSaltString", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(11, null);
        },
        enumerable: true,
        configurable: true
    });
    LibraryResourceStrings.multipleFileFound = function (dir, files) {
        LibraryResourceStrings.init();
        return localize(12, null, dir, files);
    };
    LibraryResourceStrings.startingHubHost = function (hostId, pipeName) {
        LibraryResourceStrings.init();
        return localize(13, null, hostId, pipeName);
    };
    LibraryResourceStrings.startServiceRequestRejected = function (serviceName) {
        LibraryResourceStrings.init();
        return localize(14, null, serviceName);
    };
    LibraryResourceStrings.startServiceRequestReceived = function (serviceName) {
        LibraryResourceStrings.init();
        return localize(15, null, serviceName);
    };
    LibraryResourceStrings.serviceStarted = function (serviceName, pid, endPoint) {
        LibraryResourceStrings.init();
        return localize(16, null, serviceName, pid, endPoint);
    };
    Object.defineProperty(LibraryResourceStrings, "ignoringDuplicateExit", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(17, null);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(LibraryResourceStrings, "exitCommandReceived", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(18, null);
        },
        enumerable: true,
        configurable: true
    });
    LibraryResourceStrings.closeHubStreamFailed = function (error) {
        LibraryResourceStrings.init();
        return localize(19, null, error);
    };
    LibraryResourceStrings.serviceStartedAfterHostShutDown = function (serviceName) {
        LibraryResourceStrings.init();
        return localize(20, null, serviceName);
    };
    LibraryResourceStrings.notifyHubControllerForServicesStartedFailed = function (error) {
        LibraryResourceStrings.init();
        return localize(21, null, error);
    };
    LibraryResourceStrings.notifyHubControllerForServicesEndedFailed = function (error) {
        LibraryResourceStrings.init();
        return localize(22, null, error);
    };
    Object.defineProperty(LibraryResourceStrings, "serviceNameNotSpecified", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(23, null);
        },
        enumerable: true,
        configurable: true
    });
    LibraryResourceStrings.locatingService = function (serviceName, clientId) {
        LibraryResourceStrings.init();
        return localize(24, null, serviceName, clientId);
    };
    LibraryResourceStrings.serviceLocated = function (serviceId, serviceLocation, clientId) {
        LibraryResourceStrings.init();
        return localize(25, null, serviceId, serviceLocation, clientId);
    };
    LibraryResourceStrings.startingServiceFailed = function (serviceId, clientId, error) {
        LibraryResourceStrings.init();
        return localize(26, null, serviceId, clientId, error);
    };
    Object.defineProperty(LibraryResourceStrings, "forceControllerShutDown", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(27, null);
        },
        enumerable: true,
        configurable: true
    });
    LibraryResourceStrings.locatingServcieError = function (discoveryService, service, error, callStack) {
        LibraryResourceStrings.init();
        return localize(28, null, discoveryService, service, error, callStack);
    };
    LibraryResourceStrings.disconnectingDiscoveryServiceFailed = function (discoveryService, error, callStack) {
        LibraryResourceStrings.init();
        return localize(29, null, discoveryService, error, callStack);
    };
    LibraryResourceStrings.hostTypeNotFoundInLocation = function (hostType, location, additionalLocation) {
        LibraryResourceStrings.init();
        return localize(30, null, hostType, location, additionalLocation);
    };
    LibraryResourceStrings.hostTypeNotFound = function (hostType, location) {
        LibraryResourceStrings.init();
        return localize(31, null, hostType, location);
    };
    LibraryResourceStrings.loadingHostInfo = function (host, filePath) {
        LibraryResourceStrings.init();
        return localize(32, null, host, filePath);
    };
    LibraryResourceStrings.cannotResolveHost = function (host, filePath, error) {
        LibraryResourceStrings.init();
        return localize(33, null, host, filePath, error);
    };
    LibraryResourceStrings.hostInfoNotDefined = function (path) {
        LibraryResourceStrings.init();
        return localize(34, null, path);
    };
    LibraryResourceStrings.hostInfoInvalid = function (path) {
        LibraryResourceStrings.init();
        return localize(35, null, path);
    };
    LibraryResourceStrings.hostInfoContainsReservedProperty = function (path) {
        LibraryResourceStrings.init();
        return localize(36, null, path);
    };
    LibraryResourceStrings.firstTimeLoadingService = function (serviceName) {
        LibraryResourceStrings.init();
        return localize(37, null, serviceName);
    };
    LibraryResourceStrings.launchingHostWithCmd = function (host, cmd) {
        LibraryResourceStrings.init();
        return localize(38, null, host, cmd);
    };
    LibraryResourceStrings.hostLaunched = function (host, pid) {
        LibraryResourceStrings.init();
        return localize(39, null, host, pid);
    };
    LibraryResourceStrings.hostExited = function (host, pid) {
        LibraryResourceStrings.init();
        return localize(40, null, host, pid);
    };
    LibraryResourceStrings.hostExitedWithCode = function (code, exitCode) {
        LibraryResourceStrings.init();
        return localize(41, null, code, exitCode);
    };
    LibraryResourceStrings.hostExitedWithSignal = function (signal) {
        LibraryResourceStrings.init();
        return localize(42, null, signal);
    };
    LibraryResourceStrings.startingHostError = function (executable, hostId, error) {
        LibraryResourceStrings.init();
        return localize(43, null, executable, hostId, error);
    };
    LibraryResourceStrings.hostInfoNotFound = function (id) {
        LibraryResourceStrings.init();
        return localize(44, null, id);
    };
    LibraryResourceStrings.getHostIdFailed = function (error) {
        LibraryResourceStrings.init();
        return localize(45, null, error);
    };
    Object.defineProperty(LibraryResourceStrings, "moreThanOneHostPending", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(46, null);
        },
        enumerable: true,
        configurable: true
    });
    LibraryResourceStrings.unknownHost = function (hostId) {
        LibraryResourceStrings.init();
        return localize(47, null, hostId);
    };
    LibraryResourceStrings.stoppingHost = function (hostId, pid, reason) {
        LibraryResourceStrings.init();
        return localize(48, null, hostId, pid, reason);
    };
    Object.defineProperty(LibraryResourceStrings, "cannotStopLocationService", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(49, null);
        },
        enumerable: true,
        configurable: true
    });
    LibraryResourceStrings.errorDecoding = function (error) {
        LibraryResourceStrings.init();
        return localize(50, null, error);
    };
    LibraryResourceStrings.logConfig = function (config) {
        LibraryResourceStrings.init();
        return localize(51, null, config);
    };
    Object.defineProperty(LibraryResourceStrings, "messageAt", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(52, null);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(LibraryResourceStrings, "lengthCannotBeNegative", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(53, null);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(LibraryResourceStrings, "noFolderSpecified", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(54, null);
        },
        enumerable: true,
        configurable: true
    });
    LibraryResourceStrings.cannotFindServiceModuleFile = function (filePattern, folder) {
        LibraryResourceStrings.init();
        return localize(55, null, filePattern, folder);
    };
    LibraryResourceStrings.cannotFindServiceModuleFileWithReason = function (filePattern, folder, error) {
        LibraryResourceStrings.init();
        return localize(56, null, filePattern, folder, error);
    };
    LibraryResourceStrings.loadingServiceModule = function (filePath, service) {
        LibraryResourceStrings.init();
        return localize(57, null, filePath, service);
    };
    LibraryResourceStrings.serviceInfoInvalid = function (filePath, service, property) {
        LibraryResourceStrings.init();
        return localize(58, null, filePath, service, property);
    };
    LibraryResourceStrings.serviceInfoInvalidSpaceInHostId = function (filePath, service, hostId) {
        LibraryResourceStrings.init();
        return localize(59, null, filePath, service, hostId);
    };
    LibraryResourceStrings.cannotResolveServiceModuleInfo = function (filePath, service, error) {
        LibraryResourceStrings.init();
        return localize(60, null, service, filePath, error);
    };
    LibraryResourceStrings.startingService = function (service) {
        LibraryResourceStrings.init();
        return localize(61, null, service);
    };
    LibraryResourceStrings.variableMustBeFunction = function (variable, moduleName, actualType) {
        LibraryResourceStrings.init();
        return localize(62, null, variable, moduleName, actualType);
    };
    LibraryResourceStrings.serviceEntryPointFileNameNotFound = function (name) {
        LibraryResourceStrings.init();
        return localize(63, null, name);
    };
    LibraryResourceStrings.serviceEntryPointConstructorNotFound = function (name) {
        LibraryResourceStrings.init();
        return localize(64, null, name);
    };
    LibraryResourceStrings.loadServiceModuleError = function (moduleName, error) {
        LibraryResourceStrings.init();
        return localize(65, null, moduleName, error);
    };
    LibraryResourceStrings.connectedToService = function (name) {
        LibraryResourceStrings.init();
        return localize(66, null, name);
    };
    LibraryResourceStrings.disposeServiceError = function (instanceName, name, error) {
        LibraryResourceStrings.init();
        return localize(67, null, instanceName, name, error);
    };
    LibraryResourceStrings.createServiceInstanceError = function (name, error) {
        LibraryResourceStrings.init();
        return localize(68, null, name, error);
    };
    LibraryResourceStrings.failedToDeleteFile = function (path, errCode, errMessage) {
        LibraryResourceStrings.init();
        return localize(69, null, path, errCode, errMessage);
    };
    LibraryResourceStrings.failedToGetFileStats = function (path, errCode, errMessage) {
        LibraryResourceStrings.init();
        return localize(70, null, path, errCode, errMessage);
    };
    LibraryResourceStrings.failedToEnumerateFilesInDir = function (path, errCode, errMessage) {
        LibraryResourceStrings.init();
        return localize(71, null, path, errCode, errMessage);
    };
    LibraryResourceStrings.serviceHubConfigFilePathIsNotAbsolute = function (serviceHubConfigFilePath) {
        LibraryResourceStrings.init();
        return localize(72, null, serviceHubConfigFilePath);
    };
    LibraryResourceStrings.serviceHubConfigFileNameIsIncorrect = function (serviceHubConfigFilePath) {
        LibraryResourceStrings.init();
        return localize(73, null, serviceHubConfigFilePath);
    };
    LibraryResourceStrings.serviceHubConfigFileDoesNotExist = function (serviceHubConfigFilePath) {
        LibraryResourceStrings.init();
        return localize(74, null, serviceHubConfigFilePath);
    };
    LibraryResourceStrings.HostGroupNotSupported = function (serviceName, hostGroup, propertyName) {
        LibraryResourceStrings.init();
        return localize(75, null, serviceName, hostGroup, propertyName);
    };
    Object.defineProperty(LibraryResourceStrings, "objectDisposed", {
        get: function () {
            LibraryResourceStrings.init();
            return localize(76, null);
        },
        enumerable: true,
        configurable: true
    });
    return LibraryResourceStrings;
}());
exports.LibraryResourceStrings = LibraryResourceStrings;

},{"./common":2,"path":undefined,"vscode-nls":64}],17:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var child_process_1 = require('child_process');
var q = require('q');
var path = require('path');
var ec = require('errno-codes');
var discoveryServiceProxy_1 = require('./discoveryServiceProxy');
var jsonRpc_1 = require('./jsonRpc');
var findFile_1 = require('./findFile');
var relativePath_1 = require('./relativePath');
var serviceDiscovery_1 = require('./serviceDiscovery');
var hostInfo_1 = require('./hostInfo');
var exitCode_1 = require('./exitCode');
var serviceDescriptor_1 = require('./serviceDescriptor');
var common_1 = require('./common');
var randomHexString_1 = require('./randomHexString');
var logger_1 = require('./logger');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
var controllerEngineToken = '$CONTROLLERENGINE';
var HostIdentity = (function () {
    function HostIdentity(host) {
        if (!host) {
            throw new Error(libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('host'));
        }
        if (!host.host) {
            throw new Error(libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('host.host'));
        }
        this.hostId = host.hostId;
        this.host = host.host;
        this.hostGroup = host.hostGroup;
    }
    HostIdentity.prototype.getId = function () {
        return this.host + (this.hostId ? '$' + this.hostId : '') + (this.hostGroup ? '$$' + this.hostGroup : '');
    };
    HostIdentity.prototype.getHostInfoFileGlobPattern = function () {
        // Glob allows searching for multiple files if {option1,option2} set notation is used.
        return this.hostId ? "{" + this.host + "." + this.hostId + "," + this.host + "}" : this.host;
    };
    HostIdentity.create = function (smi, serviceDescriptor) {
        var hostGroup = serviceDescriptor && serviceDescriptor.hasHostGroup() ? serviceDescriptor.hostGroup.id : null;
        return new HostIdentity({ hostId: smi.hostId, host: smi.host, hostGroup: hostGroup });
    };
    return HostIdentity;
}());
exports.HostIdentity = HostIdentity;
var HostInfo = (function (_super) {
    __extends(HostInfo, _super);
    function HostInfo(host, hostProcess) {
        _super.call(this, host);
        this.hostProcess = hostProcess;
        this.endPoint = q.defer();
        this.services = [];
        this.hasActiveServices = false;
        this.pendingStartServiceRequestCount = 0;
        this.touch();
    }
    HostInfo.prototype.setCooldownTimeout = function (callback, ms) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        this.clearCooldownTimeout();
        this.cooldownTimeout = global.setTimeout.apply(global, [callback, ms].concat(args));
    };
    HostInfo.prototype.clearCooldownTimeout = function () {
        if (this.cooldownTimeout) {
            global.clearTimeout(this.cooldownTimeout);
            this.cooldownTimeout = null;
        }
    };
    HostInfo.prototype.touch = function () {
        this.lastAccessTimeMs = new Date().getTime();
    };
    return HostInfo;
}(HostIdentity));
var LocationService = (function () {
    function LocationService(logger, config, options) {
        this.hosts = {};
        this.hostPids = [];
        this.locatedServices = {};
        this.hostInfoMap = {};
        this.externalClientCount = 0;
        if (!logger) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('logger'));
        }
        if (!config) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('config'));
        }
        options = options || {};
        this.hostCooldownMs = options.hostCooldownMs || 10 * 1000;
        this.fastShutdownHostCooldownMs = options.fastShutdownHostCooldownMs || 500;
        this.logger = logger;
        this.config = config;
        this.callbackPipeName = randomHexString_1.default().then(function (value) { return common_1.formatPipeName(value); });
        this.sessionId = randomHexString_1.default();
    }
    LocationService.prototype.locate = function (serviceDescriptor, clientInfo) {
        var _this = this;
        var service = new serviceDescriptor_1.ServiceDescriptor(serviceDescriptor);
        clientInfo = clientInfo || {};
        var clientId = "" + (clientInfo.clientName || 'client') + (clientInfo.pid ? " (pid: " + clientInfo.pid + ")" : '');
        var serviceKey = service.getServiceKey();
        this.logger.info(libraryResourceStrings_1.LibraryResourceStrings.locatingService(serviceKey, clientId));
        if (this.isExternalClient(clientInfo)) {
            this.stopFastShutdown();
        }
        return this.getHostedServiceLocation(service)
            .then(function (serviceLocation) {
            if (serviceLocation.host.shutdown) {
                // The host is shutting down; We need to locate the service again.
                return _this.locate(serviceDescriptor, clientInfo);
            }
            // Increase the host lifetime, to allow the client connect to the service,
            // and the host get back to us notifying about the started service.
            serviceLocation.host.touch();
            // Update the cached service location.
            // We don't cache IServiceLocation.clientWatch because it depends on whether the client is external or not.
            _this.locatedServices[serviceKey] = q.resolve(serviceLocation);
            var locationAndHost = serviceLocation.location + " @ " + serviceLocation.host.getId();
            _this.logger.info(libraryResourceStrings_1.LibraryResourceStrings.serviceLocated(serviceLocation.serviceId, locationAndHost, clientId));
            // Check if we want to watch for the client lifetime.
            return q.resolve(_this.isExternalClient(clientInfo) ? _this.getClientWatchServerName() : null)
                .then(function (clientWatch) { return { location: serviceLocation.location, serviceId: serviceLocation.serviceId, clientWatch: clientWatch }; });
        })
            .catch(function (reason) {
            _this.logger.error(libraryResourceStrings_1.LibraryResourceStrings.startingServiceFailed(serviceKey, clientId, "" + (reason.message || reason)));
            return q.reject(reason);
        });
    };
    LocationService.prototype.stop = function () {
        var _this = this;
        var hosts = common_1.getPropertiesArray(this.hosts).map(function (hostPromise) { return hostPromise.then(function (host) { return _this.stopHost(host, libraryResourceStrings_1.LibraryResourceStrings.forceControllerShutDown); }); });
        return q.all(hosts);
    };
    /**
    * Gets session ID
    *
    * Session ID is a unique string that stays the same during dev hub session (life time of hub controller)
    * and is different for different sessions.
    */
    LocationService.prototype.getSessionId = function () {
        return this.sessionId;
    };
    LocationService.prototype.getServiceModuleInfo = function (service) {
        var _this = this;
        var serviceDiscoveryConfig = {
            servicesFolderPath: this.config.services.rootDir,
            discoveryHelper: function (s) { return _this.discoverService(s); },
        };
        return serviceDiscovery_1.getServiceModuleInfo(this.logger, service, serviceDiscoveryConfig);
    };
    LocationService.prototype.discoverService = function (service, discoveryServices, discoveryServiceIndex) {
        var _this = this;
        if (!discoveryServices) {
            discoveryServices = this.config.services.discoveryServices;
            if (!discoveryServices || discoveryServices.length == 0 || discoveryServices.indexOf(service) >= 0) {
                return q.resolve(null);
            }
            return this.discoverService(service, discoveryServices, 0 /* discoveryServiceIndex */);
        }
        if (discoveryServices.length <= discoveryServiceIndex) {
            // We tried all known discovery services and couldn't find the service.
            return q.resolve(null);
        }
        var discoveryServiceName = discoveryServices[discoveryServiceIndex];
        var proxy = new discoveryServiceProxy_1.default(this.logger, this, discoveryServiceName);
        return proxy.discoverService(service)
            .then(function (filePath) { return filePath ? { filePath: filePath } : null; }, function (error) {
            _this.logger.error(libraryResourceStrings_1.LibraryResourceStrings.locatingServcieError(discoveryServiceName, service, error.message, error.stack));
            return { error: new Error(discoveryServiceName + ": " + error.message) };
        })
            .finally(function () {
            proxy.end()
                .catch(function (err) { return _this.logger.error(libraryResourceStrings_1.LibraryResourceStrings.disconnectingDiscoveryServiceFailed(discoveryServiceName, err.message, err.stack)); })
                .done();
        })
            .then(function (result) { return result || _this.discoverService(service, discoveryServices, discoveryServiceIndex + 1); });
    };
    /**
     * Find hub host info for the given host type by locating and parsing <host>.servicehub.host.json
     */
    LocationService.prototype.getHubHostInfo = function (hostIdentity) {
        var _this = this;
        if (!hostIdentity || !hostIdentity.host) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined(!hostIdentity ? 'hostIdentity' : 'hostIdentity.host'));
        }
        var hostId = hostIdentity.getId();
        if (this.hostInfoMap.hasOwnProperty(hostId)) {
            return this.hostInfoMap[hostId];
        }
        var globPattern = hostIdentity.getHostInfoFileGlobPattern();
        return this.hostInfoMap[hostId] = this.findHostConfigFile(globPattern)
            .then(function (filePath) {
            _this.logger.info(libraryResourceStrings_1.LibraryResourceStrings.loadingHostInfo(hostId, filePath));
            return common_1.parseFileAsJson(filePath)
                .then(function (result) {
                LocationService.verifyHostInfo(result, filePath);
                result.filePath = filePath;
                result.hostExecutable = result.hostExecutable.replace(controllerEngineToken, function () { return process.execPath; });
                return relativePath_1.expandDotRelativePaths(result, path.dirname(filePath), ['host', 'hostExecutable']);
            })
                .catch(function (err) {
                throw new common_1.ServiceHubError(common_1.ErrorKind.HubHostInfoLoadError, libraryResourceStrings_1.LibraryResourceStrings.cannotResolveHost(hostId, filePath, err.message));
            });
        });
    };
    LocationService.prototype.findHostConfigFile = function (fileNameGlobPattern) {
        var filePattern = '*/' + fileNameGlobPattern + '.servicehub.host.json';
        var localHostDir = path.join(__dirname, common_1.Constants.HostInfoFolderName);
        var configHostDir = this.config.hosts ? this.config.hosts.rootDir : null;
        var hubHostFile = configHostDir ? findFile_1.default(filePattern, { cwd: configHostDir, nodir: true, fileSelector: fileSelector, nosort: true }) : q.resolve(null);
        return hubHostFile
            .then(function (filePath) { return filePath || findFile_1.default(filePattern, { cwd: localHostDir, nodir: true, fileSelector: fileSelector, nosort: true }); })
            .then(function (filePath) {
            if (filePath) {
                return filePath;
            }
            var message = configHostDir ?
                libraryResourceStrings_1.LibraryResourceStrings.hostTypeNotFoundInLocation(fileNameGlobPattern, configHostDir, localHostDir) :
                libraryResourceStrings_1.LibraryResourceStrings.hostTypeNotFound(fileNameGlobPattern, localHostDir);
            throw new common_1.ServiceHubError(common_1.ErrorKind.HubHostInfoLoadError, message);
        });
        // There may be multiple config files found by the glob pattern.
        // The first one is the most specific, always pick it.
        function fileSelector(files) {
            return files[0];
        }
    };
    /**
     * A host must report that it has at least one active client
     * by invoking this method on the host callback pipe.
     */
    LocationService.prototype.hostServicesStarted = function (hostId) {
        if (!hostId) {
            throw new Error(libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('hostId'));
        }
        if (this.hosts.hasOwnProperty(hostId)) {
            this.hosts[hostId].then(function (h) { return h.hasActiveServices = true; });
        }
    };
    /**
     * A host must report that it has no more active clients
     * by invoking this method on the host callback pipe.
     */
    LocationService.prototype.hostServicesEnded = function (hostId) {
        var _this = this;
        if (!hostId) {
            throw new Error(libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('hostId'));
        }
        if (this.hosts.hasOwnProperty(hostId)) {
            this.hosts[hostId].then(function (host) { return _this.startHostCooldown(host); });
        }
    };
    /** A new host has connected to the location service */
    LocationService.prototype.onHostConnected = function () { };
    /** Last host has disconnected from the location service */
    LocationService.prototype.onLastHostDisconnected = function () { };
    ;
    /**
     * Verify hub host info.
     *
     * This method checks if the hub host info has mandatory fields but does not have reserved fields.
     * It throws if these conditions are not met.
     */
    LocationService.verifyHostInfo = function (hostInfo, path) {
        if (!hostInfo) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.hostInfoNotDefined(path));
        }
        if (!hostInfo.hostExecutable || typeof hostInfo.hostExecutable !== 'string'
            || !hostInfo.hostArgs || typeof hostInfo.hostArgs !== 'object' || !Array.isArray(hostInfo.hostArgs)) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.hostInfoInvalid(path));
        }
        if (hostInfo.filePath) {
            var message = libraryResourceStrings_1.LibraryResourceStrings.hostInfoContainsReservedProperty(path);
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, message);
        }
    };
    /**
     * Start service module process if it is not running yet.
     * @param: service - service module name, resolvable to a .json or .js file that either conforms to c.IServiceModuleInfo
     *                   or provides 'serviceModule' export that conforms to c.IServiceModuleInfo.
     */
    LocationService.prototype.getHostedServiceLocation = function (service) {
        var _this = this;
        var serviceKey = service.getServiceKey();
        // If somebody else has asked for the service before, use that promise
        if (this.locatedServices.hasOwnProperty(serviceKey)) {
            return this.locatedServices[serviceKey];
        }
        return this.getServiceModuleInfo(service.name).then(function (smi) {
            // If somebody else has already started the service, use it instead.
            if (_this.locatedServices.hasOwnProperty(serviceKey)) {
                return _this.locatedServices[serviceKey];
            }
            var result = _this.startService(smi, service);
            // Save the service promise so the next calls for the same service name can use that service.
            _this.locatedServices[serviceKey] = result;
            return result;
        });
    };
    LocationService.prototype.startService = function (smi, serviceDescriptor) {
        var _this = this;
        if (serviceDescriptor.hasHostGroup() && !smi.hostGroupAllowed) {
            var message = libraryResourceStrings_1.LibraryResourceStrings.HostGroupNotSupported(serviceDescriptor.name, serviceDescriptor.hostGroup.id, 'hostGroupAllowed');
            throw new common_1.ServiceHubError(common_1.ErrorKind.HostGroupsNotSupported, message);
        }
        var serviceKey = serviceDescriptor.getServiceKey();
        this.logger.info(libraryResourceStrings_1.LibraryResourceStrings.firstTimeLoadingService(serviceKey));
        var hostIdentity = HostIdentity.create(smi, serviceDescriptor);
        var hostId = hostIdentity.getId();
        var hostPromise;
        if (this.hosts.hasOwnProperty(hostId)) {
            hostPromise = this.hosts[hostId];
        }
        else {
            hostPromise = this.hosts[hostId] = this.startNewHost(hostIdentity);
        }
        // Sign up our continuation that we will run after the host has launched and is ready for a service request. The given channel is used to communicate
        // our launch request with the host.
        return hostPromise.then(function (host) {
            if (host.shutdown) {
                _this.logger.info("The host '" + host.getId() + "' for service '" + serviceDescriptor.name + "' is shutting down. We'll start a new host then.");
                return _this.startService(smi, serviceDescriptor);
            }
            // Track serivce running by the host.
            host.services.push(serviceKey);
            // Starting a new service may take some time.
            // Increase the pending request count to prevent the host from shutting down while the new service is starting.
            host.pendingStartServiceRequestCount++;
            return host.endPoint.promise
                .then(function (endPoint) { return endPoint.sendRequest(hostInfo_1.HostMethod.StartService, [smi]); })
                .then(function (location) {
                // Delay host shutdown after it started a new service to allow the client to connect to it.
                host.touch();
                return { location: location, host: host, serviceId: serviceDescriptor.name };
            })
                .finally(function () { return host.pendingStartServiceRequestCount--; });
        });
    };
    LocationService.prototype.startNewHost = function (hostIdentity) {
        var _this = this;
        var hostId = hostIdentity.getId();
        var hostCallbackPipeName = null;
        return this.getHostCallbackPipe()
            .then(function (pipeName) {
            hostCallbackPipeName = pipeName;
            return _this.getHubHostInfo(hostIdentity);
        })
            .then(function (hostInfo) {
            var hostDir = path.dirname(hostInfo.filePath);
            var args = []
                .concat(hostInfo.hostArgs.map(function (arg) { return arg
                .replace(hostInfo_1.HostArgsToken.HostId, function () { return hostId; })
                .replace(hostInfo_1.HostArgsToken.Pipe, function () { return hostCallbackPipeName; }); }));
            _this.logger.info(libraryResourceStrings_1.LibraryResourceStrings.launchingHostWithCmd(hostId, hostInfo.hostExecutable + " " + args.map(function (arg) { return ("\"" + arg + "\""); }).join(' ')));
            var process = child_process_1.spawn(hostInfo.hostExecutable, args, { cwd: hostDir });
            logger_1.traceProcessOutput(_this.logger, process, "HubHost '" + hostId + "'");
            var result = new HostInfo(hostIdentity, process);
            process.once('exit', function (code, signal) { return _this.onHostExit(result, code, signal); });
            process.once('error', function (err) { return _this.onHostError(result, err); });
            // When the host just starts, it doesn't have any service on it yet.
            // Even though the hub controller will immediately ask it to start a service,
            // the client may still not connect to the service for a long time, so we'll shut down
            // the host due to inactivity.
            _this.startHostCooldown(result);
            _this.logger.info(libraryResourceStrings_1.LibraryResourceStrings.hostLaunched(hostId, result.hostProcess.pid.toString()));
            return result;
        });
    };
    LocationService.prototype.onHostExit = function (host, code, signal) {
        var withCode = code !== undefined && code !== null ? libraryResourceStrings_1.LibraryResourceStrings.hostExitedWithCode(code, exitCode_1.default[code] ? " (" + exitCode_1.default[code] + ")" : '') : '';
        var withSignal = signal !== undefined && signal !== null ? libraryResourceStrings_1.LibraryResourceStrings.hostExitedWithSignal(signal) : '';
        var message = libraryResourceStrings_1.LibraryResourceStrings.hostExited(host.host, host.hostProcess.pid.toString()) + withCode + withSignal;
        // Remove the host pid
        var pidIndex = this.hostPids.indexOf(host.hostProcess.pid);
        if (pidIndex >= 0) {
            this.hostPids.splice(pidIndex, 1);
        }
        this.forgetHost(host, new common_1.ServiceHubError(common_1.ErrorKind.InvalidOperation, message));
    };
    LocationService.prototype.onHostError = function (host, error) {
        this.forgetHost(host, error);
    };
    LocationService.prototype.forgetHost = function (host, rejectHostEndpointReason) {
        if (!host.shutdown) {
            if (rejectHostEndpointReason) {
                host.endPoint.reject(rejectHostEndpointReason);
            }
            host.shutdown = true;
            delete this.hosts[host.getId()];
            for (var _i = 0, _a = host.services; _i < _a.length; _i++) {
                var serviceKey = _a[_i];
                delete this.locatedServices[serviceKey];
            }
            if (Object.getOwnPropertyNames(this.hosts).length === 0) {
                this.onLastHostDisconnected();
            }
        }
    };
    LocationService.prototype.onHostConnecting = function (endPoint, id) {
        // The host has gotten back to us on the host callback pipe we passed as a command line arg. This means we now have a duplex
        // connection with the host that we can use to send startService requests. Since we only launch hosts in response to a service request from a
        // client, this callback means we have a pending launch, we need to complete our promise so the launch code can then communicate the service launch
        // request over the given endpoint to the host.
        var _this = this;
        if (this.hosts.hasOwnProperty(id)) {
            this.hosts[id].done(function (host) {
                // Save the host PID.
                _this.hostPids.push(host.hostProcess.pid);
                // Stash away the endpoint in the host info.
                host.endPoint.resolve(endPoint);
                // If the host end point ends, consider the host gone.
                // Another case when the host is gone is when its process exits.
                endPoint.onClose(function () { return _this.forgetHost(host); }, _this);
                _this.onHostConnected();
            });
        }
        else {
            this.logger.error(libraryResourceStrings_1.LibraryResourceStrings.hostInfoNotFound(id));
        }
    };
    LocationService.prototype.onGetHostIdFailed = function (error) {
        this.logger.error(libraryResourceStrings_1.LibraryResourceStrings.getHostIdFailed("" + (error.message || error)));
        // See if we have only one pending host and reject it if so.
        var singleHostEndpoint = null;
        for (var id in this.hosts) {
            if (!this.hosts.hasOwnProperty(id)) {
                continue;
            }
            var state = this.hosts[id].inspect();
            if (state.state !== 'fulfilled') {
                continue;
            }
            var endPoint = state.value.endPoint;
            if (endPoint.promise.isPending) {
                if (singleHostEndpoint !== null) {
                    // If there is more than one host pending, we do not know which one failed, so just log an error.
                    this.logger.error(libraryResourceStrings_1.LibraryResourceStrings.moreThanOneHostPending);
                    return;
                }
                singleHostEndpoint = endPoint;
            }
        }
        if (singleHostEndpoint !== null) {
            singleHostEndpoint.reject(error);
        }
    };
    LocationService.prototype.getHostCallbackPipe = function () {
        var _this = this;
        return this.callbackPipeName
            .then(function (pipeName) {
            if (_this.callbackPipeCreated) {
                return pipeName;
            }
            var options = {
                name: 'hostCallback',
                logger: _this.logger,
                pipeName: pipeName
            };
            return common_1.serverManager.startService(options, function (stream) {
                var endPoint = jsonRpc_1.JsonRpcConnection.attach(stream, _this.logger, _this, [
                    'hostServicesStarted',
                    'hostServicesEnded'
                ]);
                q(endPoint.sendRequest('getHostId'))
                    .then(function (id) { return _this.onHostConnecting(endPoint, id); })
                    .catch(function (error) { return _this.onGetHostIdFailed(error); })
                    .done();
            })
                .then(function () {
                _this.callbackPipeCreated = true;
                return pipeName;
            });
        });
    };
    LocationService.prototype.getClientWatchServerName = function () {
        var _this = this;
        if (!this.clientWatchServerName) {
            var serverOptions = {
                name: 'clientWatch',
                logger: this.logger,
                onErrorCb: function (e) {
                    var message = "Error in Client Watch server: " + e.message;
                    _this.logger.error(message);
                },
            };
            this.clientWatchServerName = common_1.serverManager.startService(serverOptions, this.onClientWatchConnection.bind(this));
        }
        return this.clientWatchServerName;
    };
    LocationService.prototype.onClientWatchConnection = function (stream) {
        var _this = this;
        this.logger.info('External client connected to client watch.');
        this.externalClientCount++;
        this.stopFastShutdown();
        stream.once('end', function () {
            _this.logger.info('External client disconnected from client watch.');
            _this.externalClientCount--;
            if (_this.externalClientCount === 0) {
                _this.startFastShutdown();
            }
        });
    };
    Object.defineProperty(LocationService.prototype, "currentHostCooldownMs", {
        get: function () {
            return this.isInFastShutdown ? this.fastShutdownHostCooldownMs : this.hostCooldownMs;
        },
        enumerable: true,
        configurable: true
    });
    LocationService.prototype.startFastShutdown = function () {
        if (!this.isInFastShutdown) {
            this.isInFastShutdown = true;
            this.logger.info('Starting fast shutdown');
            this.updateHostCooldownTimeouts();
        }
    };
    LocationService.prototype.stopFastShutdown = function () {
        if (this.isInFastShutdown) {
            this.isInFastShutdown = false;
            this.logger.info('Stopping fast shutdown');
        }
    };
    LocationService.prototype.updateHostCooldownTimeouts = function () {
        var _this = this;
        for (var hostId in this.hosts) {
            this.hosts[hostId].done(function (host) {
                if (!host.hasActiveServices) {
                    _this.startHostCooldown(host);
                }
            }, function (err) {
                _this.logger.error("Error getting host: " + err.message);
            });
        }
    };
    LocationService.prototype.getHost = function (hostId) {
        if (!hostId) {
            throw new Error(libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('hostid'));
        }
        if (!this.hosts.hasOwnProperty(hostId)) {
            throw new Error(libraryResourceStrings_1.LibraryResourceStrings.unknownHost(hostId));
        }
        return this.hosts[hostId];
    };
    LocationService.prototype.startHostCooldown = function (host) {
        host.hasActiveServices = false;
        // Start cooldown unless the host is already shutting down
        if (!host.shutdown) {
            host.setCooldownTimeout(this.shutdownInactiveHost.bind(this), this.currentHostCooldownMs, host);
        }
    };
    LocationService.prototype.shutdownInactiveHost = function (host) {
        if (host.hasActiveServices || host.shutdown) {
            // The host become active again or it has already shutdown
            return;
        }
        var currentTime = new Date().getTime();
        if (host.pendingStartServiceRequestCount === 0
            && host.lastAccessTimeMs < currentTime - this.currentHostCooldownMs) {
            // The host is inactive and no service has started there since the cooldown began.
            this.stopHost(host, 'inactivity').done();
        }
        else {
            // The host is inactive but there was some service started there during the cooldown period.
            // Start another cooldown period to account for the new service.
            this.startHostCooldown(host);
        }
    };
    LocationService.prototype.stopHost = function (host, reason) {
        this.logger.info(libraryResourceStrings_1.LibraryResourceStrings.stoppingHost(host.getId(), host.hostProcess.pid.toString(), reason));
        this.forgetHost(host);
        // No need to fire host cooldown timer if the host is exiting right now.
        host.clearCooldownTimeout();
        var hostProcessExit = q.defer();
        host.hostProcess.once('exit', function (code) { return hostProcessExit.resolve(code); });
        return host.endPoint.promise
            .then(function (endPoint) { return endPoint.sendNotification(hostInfo_1.HostMethod.Exit); })
            .then(function () { return hostProcessExit.promise; });
    };
    LocationService.prototype.isExternalClient = function (clientInfo) {
        // External client is the one that doesn't run in any of Service Hub processes.
        return clientInfo && clientInfo.pid && clientInfo.pid !== process.pid && this.hostPids.indexOf(clientInfo.pid) === -1;
    };
    return LocationService;
}());
exports.LocationService = LocationService;
var LocationServiceProxy = (function () {
    function LocationServiceProxy(endPoint) {
        this.endPoint = endPoint;
        if (!endPoint) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variablesAreNotDefined('endPoint'));
        }
    }
    LocationServiceProxy.prototype.locate = function (serviceDescriptor, clientInfo) {
        // To support backward compat between client and hub controller,
        // only use service descriptor if the service name alone is not enough.
        var isServiceNameOnly = (new serviceDescriptor_1.ServiceDescriptor(serviceDescriptor)).isServiceNameOnly();
        var serviceNameOrDescriptor = isServiceNameOnly ? serviceDescriptor.name : serviceDescriptor;
        return q(this.endPoint.sendRequest('locate', [serviceNameOrDescriptor, clientInfo]));
    };
    LocationServiceProxy.prototype.stop = function () {
        return q(this.endPoint.sendNotification('exit', ['explicit request from the client']))
            .catch(function (err) {
            // If the controller has already closed, ignore the json rpc error.
            if (err.code !== ec.ENOENT.code) {
                throw err;
            }
        });
    };
    LocationServiceProxy.prototype.getSessionId = function () {
        return q(this.endPoint.sendRequest('getSessionId'));
    };
    LocationServiceProxy.prototype.dispose = function () {
        this.endPoint.dispose();
    };
    LocationServiceProxy.prototype.startHeapDiff = function () {
        return q(this.endPoint.sendRequest('startHeapDiff'));
    };
    LocationServiceProxy.prototype.endHeapDiff = function () {
        return q(this.endPoint.sendRequest('endHeapDiff'));
    };
    LocationServiceProxy.prototype.runGC = function () {
        return q(this.endPoint.sendRequest('runGC'));
    };
    LocationServiceProxy.prototype.captureHeapDump = function (filePath) {
        return q(this.endPoint.sendRequest('captureHeapDump', [filePath]));
    };
    LocationServiceProxy.prototype.getHubControllerPid = function () {
        return q(this.endPoint.sendRequest('getHubControllerPid'));
    };
    return LocationServiceProxy;
}());
exports.LocationServiceProxy = LocationServiceProxy;


},{"./common":2,"./discoveryServiceProxy":6,"./exitCode":7,"./findFile":8,"./hostInfo":9,"./jsonRpc":15,"./libraryResourceStrings":16,"./logger":18,"./randomHexString":19,"./relativePath":20,"./serviceDescriptor":21,"./serviceDiscovery":22,"child_process":undefined,"errno-codes":27,"path":undefined,"q":44}],18:[function(require,module,exports){
"use strict";
var fs = require('fs');
var path = require('path');
var os = require('os');
var util = require('util');
var c = require('./common');
var mkdirp = require('mkdir-parents');
var ec = require('errno-codes');
var tmp = require('tmp');
var exitCode_1 = require('./exitCode');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
/**
 * Log levels
 */
(function (LogLevel) {
    LogLevel[LogLevel["Critical"] = 1] = "Critical";
    LogLevel[LogLevel["Error"] = 2] = "Error";
    LogLevel[LogLevel["Warning"] = 4] = "Warning";
    LogLevel[LogLevel["Information"] = 8] = "Information";
    LogLevel[LogLevel["Verbose"] = 16] = "Verbose";
})(exports.LogLevel || (exports.LogLevel = {}));
var LogLevel = exports.LogLevel;
exports.logFileDirectory = c.getLogFilesDir();
function traceProcessOutput(logger, process, processName) {
    if (!logger) {
        throw new c.ServiceHubError(c.ErrorKind.InvalidArgument, 'logger is not defined');
    }
    if (!process) {
        throw new c.ServiceHubError(c.ErrorKind.InvalidArgument, 'process is not defined');
    }
    if (!processName) {
        throw new c.ServiceHubError(c.ErrorKind.InvalidArgument, 'processName is not defined');
    }
    process.once('exit', function (code, signal) {
        var codeOrSignal = '';
        if (typeof code === 'number') {
            codeOrSignal = " with code " + code;
            if (exitCode_1.default[code]) {
                codeOrSignal += " (" + exitCode_1.default[code] + ")";
            }
        }
        if (signal) {
            codeOrSignal += " with signal '" + signal + "''";
        }
        logger.info("" + processName + getPid(process) + " exited" + codeOrSignal + ".");
    });
    process.once('error', function (err) {
        logger.error("" + processName + getPid(process) + " error " + err.message + ".");
    });
    process.stderr.on('data', function (data) {
        logger.error("" + processName + getPid(process) + " stderr: " + data.toString());
    });
    if (logger.isEnabled(LogLevel.Verbose)) {
        process.stdout.on('data', function (data) {
            logger.verbose("" + processName + getPid(process) + " stdout: " + data.toString());
        });
    }
}
exports.traceProcessOutput = traceProcessOutput;
function getPid(process) {
    return process.pid ? ' PID ' + process.pid : '';
}
/** Trace level, must be in sync with System.Diagnostic.SourceLevels */
var SourceLevels;
(function (SourceLevels) {
    /** Allows all events through. */
    SourceLevels[SourceLevels["All"] = -1] = "All";
    /** Does not allow any events through. */
    SourceLevels[SourceLevels["Off"] = 0] = "Off";
    /** Allows only Critical events through. */
    SourceLevels[SourceLevels["Critical"] = LogLevel.Critical] = "Critical";
    /** Allows Critical and Error events through. */
    SourceLevels[SourceLevels["Error"] = 3] = "Error";
    /** Allows Critical, Error, and Warning events through. */
    SourceLevels[SourceLevels["Warning"] = 7] = "Warning";
    /** Allows Critical, Error, Warning, and Information events through. */
    SourceLevels[SourceLevels["Information"] = 15] = "Information";
    /** Allows Critical, Error, Warning, Information, and Verbose events through. */
    SourceLevels[SourceLevels["Verbose"] = 31] = "Verbose";
})(SourceLevels || (SourceLevels = {}));
/** Trace level. Must be in sync with EnvUtils.TraceLevelEnvVarName */
exports.SourceLevelEnvironmentVariable = 'SERVICEHUBTRACELEVEL';
function cleanUpOldLogs(delayInMsecBeforeStartingLogCleanup, deleteLogFilesOlderThanDate) {
    return setTimeout(function () {
        fs.exists(exports.logFileDirectory, function (exists) {
            if (!exists) {
                return;
            }
            var logger = new Logger('oldLogsCleaner');
            // get list of log files
            fs.readdir(exports.logFileDirectory, function (err, files) {
                if (err) {
                    logger.error(libraryResourceStrings_1.LibraryResourceStrings.failedToEnumerateFilesInDir(exports.logFileDirectory, err.code, err.message));
                    return;
                }
                for (var i = 0; i < files.length; i++) {
                    // get "Change Time" for each log file
                    (function (file) {
                        fs.stat(file, function (err, stats) {
                            if (err) {
                                logger.error(libraryResourceStrings_1.LibraryResourceStrings.failedToGetFileStats(file, err.code, err.message));
                                return;
                            }
                            // check if the log file is old enough to be deleted based on its "Change Time"
                            if (stats.ctime.getTime() < deleteLogFilesOlderThanDate.getTime()) {
                                // delete file as it hasn't been used since the specified number of days
                                fs.unlink(file, function (err) {
                                    if (err) {
                                        logger.error(libraryResourceStrings_1.LibraryResourceStrings.failedToDeleteFile(file, err.code, err.message));
                                    }
                                });
                            }
                        });
                    })(path.join(exports.logFileDirectory, files[i]));
                }
            });
        });
    }, delayInMsecBeforeStartingLogCleanup);
}
exports.cleanUpOldLogs = cleanUpOldLogs;
var Logger = (function () {
    function Logger(logFilePrefix, options) {
        this.maxFileSizeInBytes = 500 * 1024; // 500 KB
        this.nextLogFileNumber = 1;
        this.currentFileSizeInBytes = 0;
        this.encoding = 'utf8';
        if (!logFilePrefix) {
            throw new Error(libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('LogFilePrefix'));
        }
        options = options || {};
        this.defaultLevel = options.defaultLevel || LogLevel.Verbose;
        var sourceLevelsEnvironment = options.logSourceLevel || process.env[exports.SourceLevelEnvironmentVariable];
        this.sourceLevels = parseInt(sourceLevelsEnvironment);
        if (isNaN(this.sourceLevels)) {
            var enumValue = c.getPropertyNoCase(SourceLevels, sourceLevelsEnvironment);
            this.sourceLevels = typeof enumValue === 'number' ? enumValue : SourceLevels.Error;
        }
        var dir = options.logFileDirectory || exports.logFileDirectory;
        this.logFilePath = path.join(dir, tmp.tmpNameSync({ template: logFilePrefix + "-" + process.pid + "-XXXXXX", postfix: '.log' }) + '.log');
        this.logFilePrefix = tmp.tmpNameSync({ template: logFilePrefix + "-" + process.pid + "-XXXXXX", postfix: '.log' });
        this.logFilePath = this.getLogFilePath();
        this.rollingEnabled = !this.isEnabled(LogLevel.Verbose);
    }
    Logger.prototype.critical = function (message) {
        this.LogInternal(LogLevel.Critical, message);
    };
    Logger.prototype.error = function (message) {
        this.LogInternal(LogLevel.Error, message);
    };
    Logger.prototype.warn = function (message) {
        this.LogInternal(LogLevel.Warning, message);
    };
    Logger.prototype.info = function (message) {
        this.LogInternal(LogLevel.Information, message);
    };
    Logger.prototype.verbose = function (message) {
        this.LogInternal(LogLevel.Verbose, message);
    };
    Logger.prototype.log = function (message) {
        this.LogInternal(this.defaultLevel, message);
    };
    Logger.prototype.isEnabled = function (level) {
        return (this.sourceLevels & level) != 0;
    };
    Logger.prototype.LogInternal = function (level, message) {
        if (this.isEnabled(level)) {
            if (!this.started) {
                this.started = true;
                this.startLogging();
            }
            this.logMessage(level, message);
        }
    };
    Logger.prototype.startLogging = function () {
        var logDirectory = path.dirname(this.logFilePath);
        if (!fs.existsSync(logDirectory)) {
            try {
                mkdirp.sync(logDirectory, c.unixOwnerOnlyAccessMode);
            }
            catch (e) {
                if (e.code !== ec.EEXIST.code) {
                    throw e;
                }
            }
        }
        this.logMessage(LogLevel.Information, libraryResourceStrings_1.LibraryResourceStrings.logConfig("$" + exports.SourceLevelEnvironmentVariable + "=\"" + (process.env[exports.SourceLevelEnvironmentVariable] || '') + "\""));
        // don't count this message for our roll over file size calculation
        this.currentFileSizeInBytes = 0;
    };
    Logger.prototype.logMessage = function (level, message) {
        if (!message) {
            return;
        }
        var text;
        if (typeof message === 'string') {
            text = message;
        }
        else if (message.message) {
            text = message;
            if (message.stack) {
                text += os.EOL + libraryResourceStrings_1.LibraryResourceStrings.messageAt + ("" + os.EOL + message.stack);
            }
        }
        else {
            text = util.inspect(message);
        }
        var finalMessage = formatMessage(text, level);
        // Since message header and footer are short and of constant length managed ServiceHub logger ignores them to simplify file size calculation.
        // To be consistent we do the same here for JS logger. This is ok because we don't need an accurate file size for rolling over to a new file.
        // This also helps in keeping the tests simple.
        var buffer = new Buffer(text, this.encoding);
        if (this.rollingEnabled && this.currentFileSizeInBytes > 0 && (this.currentFileSizeInBytes + buffer.length > this.maxFileSizeInBytes)) {
            // delete lastLogFilePath
            if (this.lastLogFilePath) {
                fs.unlink(this.lastLogFilePath, function (err) { });
            }
            this.lastLogFilePath = this.logFilePath;
            this.logFilePath = this.getLogFilePath();
            fs.appendFileSync(this.logFilePath, formatMessage(libraryResourceStrings_1.LibraryResourceStrings.logConfig("$" + exports.SourceLevelEnvironmentVariable + "=\"" + (process.env[exports.SourceLevelEnvironmentVariable] || '') + "\""), LogLevel.Information), { encoding: this.encoding });
            this.currentFileSizeInBytes = 0;
        }
        fs.appendFileSync(this.logFilePath, finalMessage, { encoding: this.encoding });
        this.currentFileSizeInBytes += buffer.length;
    };
    Logger.prototype.getLogFilePath = function () {
        return path.join(exports.logFileDirectory, this.logFilePrefix + "-" + this.nextLogFileNumber++ + ".log");
    };
    return Logger;
}());
exports.Logger = Logger;
function formatMessage(message, level) {
    return formatDateTime() + " : " + LogLevel[level] + " : " + message + os.EOL;
}
function twoDigits(v) {
    return "" + (v < 10 ? '0' : '') + v;
}
function formatTime(date) {
    return twoDigits(date.getHours()) + ":" + twoDigits(date.getMinutes()) + ":" + twoDigits(date.getSeconds());
}
function formatDateTime() {
    var now = new Date();
    return twoDigits(now.getMonth() + 1) + "/" + twoDigits(now.getDate()) + "/" + now.getFullYear() + " " + formatTime(now);
}


},{"./common":2,"./exitCode":7,"./libraryResourceStrings":16,"errno-codes":27,"fs":undefined,"mkdir-parents":38,"os":undefined,"path":undefined,"tmp":55,"util":undefined}],19:[function(require,module,exports){
"use strict";
var crypto_1 = require('crypto');
var q_1 = require('q');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
exports.defaultRandomHexStringLength = 32;
function randomHexString(length, useCrypto) {
    if (length < 0) {
        throw new Error(libraryResourceStrings_1.LibraryResourceStrings.lengthCannotBeNegative);
    }
    length = length || exports.defaultRandomHexStringLength;
    if (useCrypto) {
        return q_1.nfcall(crypto_1.randomBytes, Math.round(length / 2))
            .then(function (buffer) { return buffer.toString('hex').substr(0, length); });
    }
    else {
        return q_1.resolve(getRandomHexString(length));
    }
}
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = randomHexString;
function randomHexStringSync(length, useCrypto) {
    if (length < 0) {
        throw new Error(libraryResourceStrings_1.LibraryResourceStrings.lengthCannotBeNegative);
    }
    length = length || exports.defaultRandomHexStringLength;
    if (useCrypto) {
        return crypto_1.randomBytes(Math.round(length / 2)).toString('hex').substr(0, length);
    }
    else {
        return getRandomHexString(length);
    }
}
exports.randomHexStringSync = randomHexStringSync;
function getRandomHexString(length) {
    var random = ((1 + Math.random()) * 0x10000000000000).toString(16);
    while (random.length < length) {
        random = "" + random + ((1 + Math.random()) * 0x10000000000000).toString(16);
    }
    return (random.substr(0, length));
}


},{"./libraryResourceStrings":16,"crypto":undefined,"q":44}],20:[function(require,module,exports){
"use strict";
var path = require('path');
function isDotRelativePath(p) {
    return p !== null && typeof p === 'string'
        && (p.indexOf('./') === 0 || p.indexOf('.\\') === 0 || p.indexOf('../') === 0 || p.indexOf('..\\') === 0);
}
exports.isDotRelativePath = isDotRelativePath;
function expandDotRelativePaths(obj, dir, properties) {
    if (!obj) {
        return null;
    }
    if (dir && properties && properties.length > 0) {
        for (var i = 0; i < properties.length; i++) {
            var value = obj[properties[i]];
            if (typeof value === 'string' && value !== null && isDotRelativePath(value)) {
                obj[properties[i]] = path.resolve(dir, value);
            }
        }
    }
    return obj;
}
exports.expandDotRelativePaths = expandDotRelativePaths;


},{"path":undefined}],21:[function(require,module,exports){
"use strict";
var common_1 = require('./common');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
var ServiceDescriptor = (function () {
    function ServiceDescriptor(serviceDescriptor) {
        if (!serviceDescriptor) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('serviceDescriptor'));
        }
        if (!serviceDescriptor.name) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('serviceDescriptor.name'));
        }
        this.name = serviceDescriptor.name;
        this.hostGroup = serviceDescriptor.hostGroup;
    }
    ServiceDescriptor.prototype.hasHostGroup = function () {
        return (this.hostGroup && this.hostGroup.id ? true : false);
    };
    ServiceDescriptor.prototype.getServiceKey = function () {
        return this.name + (this.hasHostGroup() ? '$' + this.hostGroup.id : '');
    };
    ServiceDescriptor.prototype.isServiceNameOnly = function () {
        return !this.hasHostGroup();
    };
    return ServiceDescriptor;
}());
exports.ServiceDescriptor = ServiceDescriptor;


},{"./common":2,"./libraryResourceStrings":16}],22:[function(require,module,exports){
"use strict";
var fs = require('fs');
var path = require('path');
var q_1 = require('q');
var findFile_1 = require('./findFile');
var serviceModuleInfo_1 = require('./serviceModuleInfo');
var common_1 = require('./common');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
// Map of Service name -> Full service module info file path.
var knownServicePaths = {};
/**
* Locate and load service module info for the given service.
* @param: service - service module name, resolvable to a .json or .js file.
*
* To locate the service module info, ServiceHub will do the following:
*   * If servicehub.config.json does not exist or it doesn't have the services folder, servicehub will fail to locate the service.
*   * ServiceHub will search for '*\<service>.servicehub.service.json' in the services folder.
*   * If it cannot find it there, it'll use discoveryServices to delegate search to them.
*   * If the service module info is found, ServiceHub will load it by using fs.readFile and JSON.Parse
*/
function getServiceModuleInfo(logger, service, config) {
    if (!logger) {
        throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('logger'));
    }
    if (!service) {
        throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('service'));
    }
    if (!config) {
        throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('config'));
    }
    if (!config.servicesFolderPath) {
        throw new common_1.ServiceHubError(common_1.ErrorKind.ConfigurationError, libraryResourceStrings_1.LibraryResourceStrings.noFolderSpecified);
    }
    // Check known locations first and ensure the file still exist there
    var knownServicePath = knownServicePaths[service];
    if (knownServicePath) {
        logger.info("Service module info for '" + service + "' has been loaded before from '" + knownServicePath + "'. Trying to load it from there again.");
        return q_1.ninvoke(fs, 'access', knownServicePath, fs.R_OK)
            .then(function () { return loadServiceModuleInfo(logger, service, knownServicePath); }, function (err) {
            logger.info("Service module info for '" + service + "' is missing at '" + knownServicePath + "'. Trying to discover the service again.");
            delete knownServicePaths[service];
            return getServiceModuleInfo(logger, service, config);
        });
    }
    // Keep in sync with VsixDiscoveryService, \src\CoreClr\services\ServiceHubVsixServiceDiscovery\Service\DiscoveryService.cs
    var filePattern = '*/' + service + '.servicehub.service.json';
    return findFile_1.default(filePattern, { cwd: config.servicesFolderPath, nodir: true, fileSelector: serviceModuleFileSelector })
        .then(function (filePath) { return filePath || !config.discoveryHelper ? { filePath: filePath } : config.discoveryHelper(service); })
        .then(function (discoveryResult) {
        if (!discoveryResult || !discoveryResult.filePath) {
            var message = discoveryResult && discoveryResult.error ?
                libraryResourceStrings_1.LibraryResourceStrings.cannotFindServiceModuleFileWithReason(filePattern, config.servicesFolderPath, discoveryResult.error.message) :
                libraryResourceStrings_1.LibraryResourceStrings.cannotFindServiceModuleFile(filePattern, config.servicesFolderPath);
            throw new common_1.ServiceHubError(common_1.ErrorKind.ServiceModuleInfoNotFound, message);
        }
        return loadServiceModuleInfo(logger, service, discoveryResult.filePath);
    });
}
exports.getServiceModuleInfo = getServiceModuleInfo;
function serviceModuleFileSelector(files) {
    if (!files || files.length === 0) {
        return null;
    }
    for (var _i = 0, files_1 = files; _i < files_1.length; _i++) {
        var file = files_1[_i];
        if (path.extname(file) === '.json') {
            return file;
        }
    }
    return files[0];
}
function loadServiceModuleInfo(logger, service, filePath) {
    logger.info(libraryResourceStrings_1.LibraryResourceStrings.loadingServiceModule(filePath, service));
    // Use fs.readFile + JSON.parse to load service module instead of require() so:
    // 1. Only JSON format is supported;
    // 2. require() caches the files it loads. We add name and serviceBaseDirectory properties to the object after loading.
    //    The next time when we load the same service module info file, require() will return the cached instance
    //    with the name and serviceBaseDirectory set on it already, and we'll reject it.
    // 3. Service module info load is async and doesn't block the controller.
    // 4. The load happens from the specified path only. Node module discovery is not needed here.
    return common_1.parseFileAsJson(filePath)
        .then(function (serviceModule) {
        if (serviceModule.name) {
            var message = libraryResourceStrings_1.LibraryResourceStrings.serviceInfoInvalid(filePath, service, 'name');
            throw new common_1.ServiceHubError(common_1.ErrorKind.ServiceModuleInfoInvalidPropertyError, message);
        }
        if (serviceModule.serviceBaseDirectory) {
            var message = libraryResourceStrings_1.LibraryResourceStrings.serviceInfoInvalid(filePath, service, 'serviceBaseDirectory');
            throw new common_1.ServiceHubError(common_1.ErrorKind.ServiceModuleInfoInvalidPropertyError, message);
        }
        if (serviceModule.hostId && serviceModule.hostId.indexOf(' ') >= 0) {
            var message = libraryResourceStrings_1.LibraryResourceStrings.serviceInfoInvalidSpaceInHostId(filePath, service, serviceModule.hostId);
            throw new common_1.ServiceHubError(common_1.ErrorKind.ServiceModuleInfoInvalidPropertyError, message);
        }
        serviceModule.name = service;
        serviceModule.serviceBaseDirectory = path.dirname(filePath);
        var result = new serviceModuleInfo_1.ServiceModuleInfo(serviceModule);
        // Cache the service module info file path.
        knownServicePaths[service] = filePath;
        return result;
    })
        .catch(function (err) {
        throw new common_1.ServiceHubError(common_1.ErrorKind.ServiceModuleInfoLoadError, libraryResourceStrings_1.LibraryResourceStrings.cannotResolveServiceModuleInfo(filePath, service, err.message));
    });
}


},{"./common":2,"./findFile":8,"./libraryResourceStrings":16,"./serviceModuleInfo":23,"fs":undefined,"path":undefined,"q":44}],23:[function(require,module,exports){
"use strict";
var common_1 = require('./common');
var libraryResourceStrings_1 = require('./libraryResourceStrings');
// set the default host ID to be some guid to prevent name collisions with user specified host IDs
var defaultHostId = 'C94B8CFE-E3FD-4BAF-A941-2866DBB566FE';
var ServiceModuleInfo = (function () {
    function ServiceModuleInfo(source) {
        if (!source) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('source'));
        }
        this.name = source.name;
        this.host = source.host;
        this.hostId = source.hostId;
        if (!this.hostId) {
            this.hostId = defaultHostId;
        }
        this.hostGroupAllowed = source.hostGroupAllowed;
        this.serviceBaseDirectory = source.serviceBaseDirectory;
        this.entryPoint = source.entryPoint;
        if (!source.host) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('host'));
        }
        if (!this.entryPoint) {
            throw new common_1.ServiceHubError(common_1.ErrorKind.InvalidArgument, libraryResourceStrings_1.LibraryResourceStrings.variableIsNotDefined('entryPoint'));
        }
    }
    return ServiceModuleInfo;
}());
exports.ServiceModuleInfo = ServiceModuleInfo;


},{"./common":2,"./libraryResourceStrings":16}],24:[function(require,module,exports){
module.exports = balanced;
function balanced(a, b, str) {
  var r = range(a, b, str);

  return r && {
    start: r[0],
    end: r[1],
    pre: str.slice(0, r[0]),
    body: str.slice(r[0] + a.length, r[1]),
    post: str.slice(r[1] + b.length)
  };
}

balanced.range = range;
function range(a, b, str) {
  var begs, beg, left, right, result;
  var ai = str.indexOf(a);
  var bi = str.indexOf(b, ai + 1);
  var i = ai;

  if (ai >= 0 && bi > 0) {
    begs = [];
    left = str.length;

    while (i < str.length && i >= 0 && ! result) {
      if (i == ai) {
        begs.push(i);
        ai = str.indexOf(a, i + 1);
      } else if (begs.length == 1) {
        result = [ begs.pop(), bi ];
      } else {
        beg = begs.pop();
        if (beg < left) {
          left = beg;
          right = bi;
        }

        bi = str.indexOf(b, i + 1);
      }

      i = ai < bi && ai >= 0 ? ai : bi;
    }

    if (begs.length) {
      result = [ left, right ];
    }
  }

  return result;
}

},{}],25:[function(require,module,exports){
var concatMap = require('concat-map');
var balanced = require('balanced-match');

module.exports = expandTop;

var escSlash = '\0SLASH'+Math.random()+'\0';
var escOpen = '\0OPEN'+Math.random()+'\0';
var escClose = '\0CLOSE'+Math.random()+'\0';
var escComma = '\0COMMA'+Math.random()+'\0';
var escPeriod = '\0PERIOD'+Math.random()+'\0';

function numeric(str) {
  return parseInt(str, 10) == str
    ? parseInt(str, 10)
    : str.charCodeAt(0);
}

function escapeBraces(str) {
  return str.split('\\\\').join(escSlash)
            .split('\\{').join(escOpen)
            .split('\\}').join(escClose)
            .split('\\,').join(escComma)
            .split('\\.').join(escPeriod);
}

function unescapeBraces(str) {
  return str.split(escSlash).join('\\')
            .split(escOpen).join('{')
            .split(escClose).join('}')
            .split(escComma).join(',')
            .split(escPeriod).join('.');
}


// Basically just str.split(","), but handling cases
// where we have nested braced sections, which should be
// treated as individual members, like {a,{b,c},d}
function parseCommaParts(str) {
  if (!str)
    return [''];

  var parts = [];
  var m = balanced('{', '}', str);

  if (!m)
    return str.split(',');

  var pre = m.pre;
  var body = m.body;
  var post = m.post;
  var p = pre.split(',');

  p[p.length-1] += '{' + body + '}';
  var postParts = parseCommaParts(post);
  if (post.length) {
    p[p.length-1] += postParts.shift();
    p.push.apply(p, postParts);
  }

  parts.push.apply(parts, p);

  return parts;
}

function expandTop(str) {
  if (!str)
    return [];

  return expand(escapeBraces(str), true).map(unescapeBraces);
}

function identity(e) {
  return e;
}

function embrace(str) {
  return '{' + str + '}';
}
function isPadded(el) {
  return /^-?0\d/.test(el);
}

function lte(i, y) {
  return i <= y;
}
function gte(i, y) {
  return i >= y;
}

function expand(str, isTop) {
  var expansions = [];

  var m = balanced('{', '}', str);
  if (!m || /\$$/.test(m.pre)) return [str];

  var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
  var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
  var isSequence = isNumericSequence || isAlphaSequence;
  var isOptions = /^(.*,)+(.+)?$/.test(m.body);
  if (!isSequence && !isOptions) {
    // {a},b}
    if (m.post.match(/,.*\}/)) {
      str = m.pre + '{' + m.body + escClose + m.post;
      return expand(str);
    }
    return [str];
  }

  var n;
  if (isSequence) {
    n = m.body.split(/\.\./);
  } else {
    n = parseCommaParts(m.body);
    if (n.length === 1) {
      // x{{a,b}}y ==> x{a}y x{b}y
      n = expand(n[0], false).map(embrace);
      if (n.length === 1) {
        var post = m.post.length
          ? expand(m.post, false)
          : [''];
        return post.map(function(p) {
          return m.pre + n[0] + p;
        });
      }
    }
  }

  // at this point, n is the parts, and we know it's not a comma set
  // with a single entry.

  // no need to expand pre, since it is guaranteed to be free of brace-sets
  var pre = m.pre;
  var post = m.post.length
    ? expand(m.post, false)
    : [''];

  var N;

  if (isSequence) {
    var x = numeric(n[0]);
    var y = numeric(n[1]);
    var width = Math.max(n[0].length, n[1].length)
    var incr = n.length == 3
      ? Math.abs(numeric(n[2]))
      : 1;
    var test = lte;
    var reverse = y < x;
    if (reverse) {
      incr *= -1;
      test = gte;
    }
    var pad = n.some(isPadded);

    N = [];

    for (var i = x; test(i, y); i += incr) {
      var c;
      if (isAlphaSequence) {
        c = String.fromCharCode(i);
        if (c === '\\')
          c = '';
      } else {
        c = String(i);
        if (pad) {
          var need = width - c.length;
          if (need > 0) {
            var z = new Array(need + 1).join('0');
            if (i < 0)
              c = '-' + z + c.slice(1);
            else
              c = z + c;
          }
        }
      }
      N.push(c);
    }
  } else {
    N = concatMap(n, function(el) { return expand(el, false) });
  }

  for (var j = 0; j < N.length; j++) {
    for (var k = 0; k < post.length; k++) {
      var expansion = pre + N[j] + post[k];
      if (!isTop || isSequence || expansion)
        expansions.push(expansion);
    }
  }

  return expansions;
}


},{"balanced-match":24,"concat-map":26}],26:[function(require,module,exports){
module.exports = function (xs, fn) {
    var res = [];
    for (var i = 0; i < xs.length; i++) {
        var x = fn(xs[i], i);
        if (isArray(x)) res.push.apply(res, x);
        else res.push(x);
    }
    return res;
};

var isArray = Array.isArray || function (xs) {
    return Object.prototype.toString.call(xs) === '[object Array]';
};

},{}],27:[function(require,module,exports){
"use strict";var errors={UNKNOWN:{errno:-1,code:"UNKNOWN",description:"unknown error"},OK:{errno:0,code:"OK",description:"success"},EOF:{errno:1,code:"EOF",description:"end of file"},EADDRINFO:{errno:2,code:"EADDRINFO",description:"getaddrinfo error"},EACCES:{errno:3,code:"EACCES",description:"permission denied"},EAGAIN:{errno:4,code:"EAGAIN",description:"no more processes"},EADDRINUSE:{errno:5,code:"EADDRINUSE",description:"address already in use"},EADDRNOTAVAIL:{errno:6,code:"EADDRNOTAVAIL",description:""},EAFNOSUPPORT:{errno:7,code:"EAFNOSUPPORT",description:""},EALREADY:{errno:8,code:"EALREADY",description:""},EBADF:{errno:9,code:"EBADF",description:"bad file descriptor"},EBUSY:{errno:10,code:"EBUSY",description:"resource busy or locked"},ECONNABORTED:{errno:11,code:"ECONNABORTED",description:"software caused connection abort"},ECONNREFUSED:{errno:12,code:"ECONNREFUSED",description:"connection refused"},ECONNRESET:{errno:13,code:"ECONNRESET",description:"connection reset by peer"},EDESTADDRREQ:{errno:14,code:"EDESTADDRREQ",description:"destination address required"},EFAULT:{errno:15,code:"EFAULT",description:"bad address in system call argument"},EHOSTUNREACH:{errno:16,code:"EHOSTUNREACH",description:"host is unreachable"},EINTR:{errno:17,code:"EINTR",description:"interrupted system call"},EINVAL:{errno:18,code:"EINVAL",description:"invalid argument"},EISCONN:{errno:19,code:"EISCONN",description:"socket is already connected"},EMFILE:{errno:20,code:"EMFILE",description:"too many open files"},EMSGSIZE:{errno:21,code:"EMSGSIZE",description:"message too long"},ENETDOWN:{errno:22,code:"ENETDOWN",description:"network is down"},ENETUNREACH:{errno:23,code:"ENETUNREACH",description:"network is unreachable"},ENFILE:{errno:24,code:"ENFILE",description:"file table overflow"},ENOBUFS:{errno:25,code:"ENOBUFS",description:"no buffer space available"},ENOMEM:{errno:26,code:"ENOMEM",description:"not enough memory"},ENOTDIR:{errno:27,code:"ENOTDIR",description:"not a directory"},EISDIR:{errno:28,code:"EISDIR",description:"illegal operation on a directory"},ENONET:{errno:29,code:"ENONET",description:"machine is not on the network"},ENOTCONN:{errno:31,code:"ENOTCONN",description:"socket is not connected"},ENOTSOCK:{errno:32,code:"ENOTSOCK",description:"socket operation on non-socket"},ENOTSUP:{errno:33,code:"ENOTSUP",description:"operation not supported on socket"},ENOENT:{errno:34,code:"ENOENT",description:"no such file or directory"},ENOSYS:{errno:35,code:"ENOSYS",description:"function not implemented"},EPIPE:{errno:36,code:"EPIPE",description:"broken pipe"},EPROTO:{errno:37,code:"EPROTO",description:"protocol error"},EPROTONOSUPPORT:{errno:38,code:"EPROTONOSUPPORT",description:"protocol not supported"},EPROTOTYPE:{errno:39,code:"EPROTOTYPE",description:"protocol wrong type for socket"},ETIMEDOUT:{errno:40,code:"ETIMEDOUT",description:"connection timed out"},ECHARSET:{errno:41,code:"ECHARSET",description:""},EAIFAMNOSUPPORT:{errno:42,code:"EAIFAMNOSUPPORT",description:""},EAISERVICE:{errno:44,code:"EAISERVICE",description:""},EAISOCKTYPE:{errno:45,code:"EAISOCKTYPE",description:""},ESHUTDOWN:{errno:46,code:"ESHUTDOWN",description:""},EEXIST:{errno:47,code:"EEXIST",description:"file already exists"},ESRCH:{errno:48,code:"ESRCH",description:"no such process"},ENAMETOOLONG:{errno:49,code:"ENAMETOOLONG",description:"name too long"},EPERM:{errno:50,code:"EPERM",description:"operation not permitted"},ELOOP:{errno:51,code:"ELOOP",description:"too many symbolic links encountered"},EXDEV:{errno:52,code:"EXDEV",description:"cross-device link not permitted"},ENOTEMPTY:{errno:53,code:"ENOTEMPTY",description:"directory not empty"},ENOSPC:{errno:54,code:"ENOSPC",description:"no space left on device"},EIO:{errno:55,code:"EIO",description:"i/o error"},EROFS:{errno:56,code:"EROFS",description:"read-only file system"},ENODEV:{errno:57,code:"ENODEV",description:"no such device"},ESPIPE:{errno:58,code:"ESPIPE",description:"invalid seek"},ECANCELED:{errno:59,code:"ECANCELED",description:"operation canceled"}},codes={"-1":"UNKNOWN",0:"OK",1:"EOF",2:"EADDRINFO",3:"EACCES",4:"EAGAIN",5:"EADDRINUSE",6:"EADDRNOTAVAIL",7:"EAFNOSUPPORT",8:"EALREADY",9:"EBADF",10:"EBUSY",11:"ECONNABORTED",12:"ECONNREFUSED",13:"ECONNRESET",14:"EDESTADDRREQ",15:"EFAULT",16:"EHOSTUNREACH",17:"EINTR",18:"EINVAL",19:"EISCONN",20:"EMFILE",21:"EMSGSIZE",22:"ENETDOWN",23:"ENETUNREACH",24:"ENFILE",25:"ENOBUFS",26:"ENOMEM",27:"ENOTDIR",28:"EISDIR",29:"ENONET",31:"ENOTCONN",32:"ENOTSOCK",33:"ENOTSUP",34:"ENOENT",35:"ENOSYS",36:"EPIPE",37:"EPROTO",38:"EPROTONOSUPPORT",39:"EPROTOTYPE",40:"ETIMEDOUT",41:"ECHARSET",42:"EAIFAMNOSUPPORT",44:"EAISERVICE",45:"EAISOCKTYPE",46:"ESHUTDOWN",47:"EEXIST",48:"ESRCH",49:"ENAMETOOLONG",50:"EPERM",51:"ELOOP",52:"EXDEV",53:"ENOTEMPTY",54:"ENOSPC",55:"EIO",56:"EROFS",57:"ENODEV",58:"ESPIPE",59:"ECANCELED"},nextAvailableErrno=100;errors.create=function(a,b,c){var d={errno:a,code:b,description:c};errors[b]=d,codes[a]=b},errors.get=function(a,b){var c,d=typeof a;d==="number"?c=errors[codes[a]]:d==="string"?c=errors[a]:c=a;var e=new Error(c.code);e.errno=c.errno,e.code=c.code;var f=c.description;if(b)for(var g in b)f=f.replace(new RegExp("\\{"+g+"\\}","g"),b[g]);return e.description=f,e},errors.getNextAvailableErrno=function(){var a=nextAvailableErrno;return nextAvailableErrno++,a},module.exports=errors;
},{}],28:[function(require,module,exports){
exports.alphasort = alphasort
exports.alphasorti = alphasorti
exports.setopts = setopts
exports.ownProp = ownProp
exports.makeAbs = makeAbs
exports.finish = finish
exports.mark = mark
exports.isIgnored = isIgnored
exports.childrenIgnored = childrenIgnored

function ownProp (obj, field) {
  return Object.prototype.hasOwnProperty.call(obj, field)
}

var path = require("path")
var minimatch = require("minimatch")
var isAbsolute = require("path-is-absolute")
var Minimatch = minimatch.Minimatch

function alphasorti (a, b) {
  return a.toLowerCase().localeCompare(b.toLowerCase())
}

function alphasort (a, b) {
  return a.localeCompare(b)
}

function setupIgnores (self, options) {
  self.ignore = options.ignore || []

  if (!Array.isArray(self.ignore))
    self.ignore = [self.ignore]

  if (self.ignore.length) {
    self.ignore = self.ignore.map(ignoreMap)
  }
}

// ignore patterns are always in dot:true mode.
function ignoreMap (pattern) {
  var gmatcher = null
  if (pattern.slice(-3) === '/**') {
    var gpattern = pattern.replace(/(\/\*\*)+$/, '')
    gmatcher = new Minimatch(gpattern, { dot: true })
  }

  return {
    matcher: new Minimatch(pattern, { dot: true }),
    gmatcher: gmatcher
  }
}

function setopts (self, pattern, options) {
  if (!options)
    options = {}

  // base-matching: just use globstar for that.
  if (options.matchBase && -1 === pattern.indexOf("/")) {
    if (options.noglobstar) {
      throw new Error("base matching requires globstar")
    }
    pattern = "**/" + pattern
  }

  self.silent = !!options.silent
  self.pattern = pattern
  self.strict = options.strict !== false
  self.realpath = !!options.realpath
  self.realpathCache = options.realpathCache || Object.create(null)
  self.follow = !!options.follow
  self.dot = !!options.dot
  self.mark = !!options.mark
  self.nodir = !!options.nodir
  if (self.nodir)
    self.mark = true
  self.sync = !!options.sync
  self.nounique = !!options.nounique
  self.nonull = !!options.nonull
  self.nosort = !!options.nosort
  self.nocase = !!options.nocase
  self.stat = !!options.stat
  self.noprocess = !!options.noprocess

  self.maxLength = options.maxLength || Infinity
  self.cache = options.cache || Object.create(null)
  self.statCache = options.statCache || Object.create(null)
  self.symlinks = options.symlinks || Object.create(null)

  setupIgnores(self, options)

  self.changedCwd = false
  var cwd = process.cwd()
  if (!ownProp(options, "cwd"))
    self.cwd = cwd
  else {
    self.cwd = path.resolve(options.cwd)
    self.changedCwd = self.cwd !== cwd
  }

  self.root = options.root || path.resolve(self.cwd, "/")
  self.root = path.resolve(self.root)
  if (process.platform === "win32")
    self.root = self.root.replace(/\\/g, "/")

  self.cwdAbs = makeAbs(self, self.cwd)
  self.nomount = !!options.nomount

  // disable comments and negation in Minimatch.
  // Note that they are not supported in Glob itself anyway.
  options.nonegate = true
  options.nocomment = true

  self.minimatch = new Minimatch(pattern, options)
  self.options = self.minimatch.options
}

function finish (self) {
  var nou = self.nounique
  var all = nou ? [] : Object.create(null)

  for (var i = 0, l = self.matches.length; i < l; i ++) {
    var matches = self.matches[i]
    if (!matches || Object.keys(matches).length === 0) {
      if (self.nonull) {
        // do like the shell, and spit out the literal glob
        var literal = self.minimatch.globSet[i]
        if (nou)
          all.push(literal)
        else
          all[literal] = true
      }
    } else {
      // had matches
      var m = Object.keys(matches)
      if (nou)
        all.push.apply(all, m)
      else
        m.forEach(function (m) {
          all[m] = true
        })
    }
  }

  if (!nou)
    all = Object.keys(all)

  if (!self.nosort)
    all = all.sort(self.nocase ? alphasorti : alphasort)

  // at *some* point we statted all of these
  if (self.mark) {
    for (var i = 0; i < all.length; i++) {
      all[i] = self._mark(all[i])
    }
    if (self.nodir) {
      all = all.filter(function (e) {
        var notDir = !(/\/$/.test(e))
        var c = self.cache[e] || self.cache[makeAbs(self, e)]
        if (notDir && c)
          notDir = c !== 'DIR' && !Array.isArray(c)
        return notDir
      })
    }
  }

  if (self.ignore.length)
    all = all.filter(function(m) {
      return !isIgnored(self, m)
    })

  self.found = all
}

function mark (self, p) {
  var abs = makeAbs(self, p)
  var c = self.cache[abs]
  var m = p
  if (c) {
    var isDir = c === 'DIR' || Array.isArray(c)
    var slash = p.slice(-1) === '/'

    if (isDir && !slash)
      m += '/'
    else if (!isDir && slash)
      m = m.slice(0, -1)

    if (m !== p) {
      var mabs = makeAbs(self, m)
      self.statCache[mabs] = self.statCache[abs]
      self.cache[mabs] = self.cache[abs]
    }
  }

  return m
}

// lotta situps...
function makeAbs (self, f) {
  var abs = f
  if (f.charAt(0) === '/') {
    abs = path.join(self.root, f)
  } else if (isAbsolute(f) || f === '') {
    abs = f
  } else if (self.changedCwd) {
    abs = path.resolve(self.cwd, f)
  } else {
    abs = path.resolve(f)
  }

  if (process.platform === 'win32')
    abs = abs.replace(/\\/g, '/')

  return abs
}


// Return true, if pattern ends with globstar '**', for the accompanying parent directory.
// Ex:- If node_modules/** is the pattern, add 'node_modules' to ignore list along with it's contents
function isIgnored (self, path) {
  if (!self.ignore.length)
    return false

  return self.ignore.some(function(item) {
    return item.matcher.match(path) || !!(item.gmatcher && item.gmatcher.match(path))
  })
}

function childrenIgnored (self, path) {
  if (!self.ignore.length)
    return false

  return self.ignore.some(function(item) {
    return !!(item.gmatcher && item.gmatcher.match(path))
  })
}

},{"minimatch":37,"path":undefined,"path-is-absolute":43}],29:[function(require,module,exports){
// Approach:
//
// 1. Get the minimatch set
// 2. For each pattern in the set, PROCESS(pattern, false)
// 3. Store matches per-set, then uniq them
//
// PROCESS(pattern, inGlobStar)
// Get the first [n] items from pattern that are all strings
// Join these together.  This is PREFIX.
//   If there is no more remaining, then stat(PREFIX) and
//   add to matches if it succeeds.  END.
//
// If inGlobStar and PREFIX is symlink and points to dir
//   set ENTRIES = []
// else readdir(PREFIX) as ENTRIES
//   If fail, END
//
// with ENTRIES
//   If pattern[n] is GLOBSTAR
//     // handle the case where the globstar match is empty
//     // by pruning it out, and testing the resulting pattern
//     PROCESS(pattern[0..n] + pattern[n+1 .. $], false)
//     // handle other cases.
//     for ENTRY in ENTRIES (not dotfiles)
//       // attach globstar + tail onto the entry
//       // Mark that this entry is a globstar match
//       PROCESS(pattern[0..n] + ENTRY + pattern[n .. $], true)
//
//   else // not globstar
//     for ENTRY in ENTRIES (not dotfiles, unless pattern[n] is dot)
//       Test ENTRY against pattern[n]
//       If fails, continue
//       If passes, PROCESS(pattern[0..n] + item + pattern[n+1 .. $])
//
// Caveat:
//   Cache all stats and readdirs results to minimize syscall.  Since all
//   we ever care about is existence and directory-ness, we can just keep
//   `true` for files, and [children,...] for directories, or `false` for
//   things that don't exist.

module.exports = glob

var fs = require('fs')
var minimatch = require('minimatch')
var Minimatch = minimatch.Minimatch
var inherits = require('inherits')
var EE = require('events').EventEmitter
var path = require('path')
var assert = require('assert')
var isAbsolute = require('path-is-absolute')
var globSync = require('./sync.js')
var common = require('./common.js')
var alphasort = common.alphasort
var alphasorti = common.alphasorti
var setopts = common.setopts
var ownProp = common.ownProp
var inflight = require('inflight')
var util = require('util')
var childrenIgnored = common.childrenIgnored
var isIgnored = common.isIgnored

var once = require('once')

function glob (pattern, options, cb) {
  if (typeof options === 'function') cb = options, options = {}
  if (!options) options = {}

  if (options.sync) {
    if (cb)
      throw new TypeError('callback provided to sync glob')
    return globSync(pattern, options)
  }

  return new Glob(pattern, options, cb)
}

glob.sync = globSync
var GlobSync = glob.GlobSync = globSync.GlobSync

// old api surface
glob.glob = glob

function extend (origin, add) {
  if (add === null || typeof add !== 'object') {
    return origin
  }

  var keys = Object.keys(add)
  var i = keys.length
  while (i--) {
    origin[keys[i]] = add[keys[i]]
  }
  return origin
}

glob.hasMagic = function (pattern, options_) {
  var options = extend({}, options_)
  options.noprocess = true

  var g = new Glob(pattern, options)
  var set = g.minimatch.set
  if (set.length > 1)
    return true

  for (var j = 0; j < set[0].length; j++) {
    if (typeof set[0][j] !== 'string')
      return true
  }

  return false
}

glob.Glob = Glob
inherits(Glob, EE)
function Glob (pattern, options, cb) {
  if (typeof options === 'function') {
    cb = options
    options = null
  }

  if (options && options.sync) {
    if (cb)
      throw new TypeError('callback provided to sync glob')
    return new GlobSync(pattern, options)
  }

  if (!(this instanceof Glob))
    return new Glob(pattern, options, cb)

  setopts(this, pattern, options)
  this._didRealPath = false

  // process each pattern in the minimatch set
  var n = this.minimatch.set.length

  // The matches are stored as {<filename>: true,...} so that
  // duplicates are automagically pruned.
  // Later, we do an Object.keys() on these.
  // Keep them as a list so we can fill in when nonull is set.
  this.matches = new Array(n)

  if (typeof cb === 'function') {
    cb = once(cb)
    this.on('error', cb)
    this.on('end', function (matches) {
      cb(null, matches)
    })
  }

  var self = this
  var n = this.minimatch.set.length
  this._processing = 0
  this.matches = new Array(n)

  this._emitQueue = []
  this._processQueue = []
  this.paused = false

  if (this.noprocess)
    return this

  if (n === 0)
    return done()

  var sync = true
  for (var i = 0; i < n; i ++) {
    this._process(this.minimatch.set[i], i, false, done)
  }
  sync = false

  function done () {
    --self._processing
    if (self._processing <= 0) {
      if (sync) {
        process.nextTick(function () {
          self._finish()
        })
      } else {
        self._finish()
      }
    }
  }
}

Glob.prototype._finish = function () {
  assert(this instanceof Glob)
  if (this.aborted)
    return

  if (this.realpath && !this._didRealpath)
    return this._realpath()

  common.finish(this)
  this.emit('end', this.found)
}

Glob.prototype._realpath = function () {
  if (this._didRealpath)
    return

  this._didRealpath = true

  var n = this.matches.length
  if (n === 0)
    return this._finish()

  var self = this
  for (var i = 0; i < this.matches.length; i++)
    this._realpathSet(i, next)

  function next () {
    if (--n === 0)
      self._finish()
  }
}

Glob.prototype._realpathSet = function (index, cb) {
  var matchset = this.matches[index]
  if (!matchset)
    return cb()

  var found = Object.keys(matchset)
  var self = this
  var n = found.length

  if (n === 0)
    return cb()

  var set = this.matches[index] = Object.create(null)
  found.forEach(function (p, i) {
    // If there's a problem with the stat, then it means that
    // one or more of the links in the realpath couldn't be
    // resolved.  just return the abs value in that case.
    p = self._makeAbs(p)
    fs.realpath(p, self.realpathCache, function (er, real) {
      if (!er)
        set[real] = true
      else if (er.syscall === 'stat')
        set[p] = true
      else
        self.emit('error', er) // srsly wtf right here

      if (--n === 0) {
        self.matches[index] = set
        cb()
      }
    })
  })
}

Glob.prototype._mark = function (p) {
  return common.mark(this, p)
}

Glob.prototype._makeAbs = function (f) {
  return common.makeAbs(this, f)
}

Glob.prototype.abort = function () {
  this.aborted = true
  this.emit('abort')
}

Glob.prototype.pause = function () {
  if (!this.paused) {
    this.paused = true
    this.emit('pause')
  }
}

Glob.prototype.resume = function () {
  if (this.paused) {
    this.emit('resume')
    this.paused = false
    if (this._emitQueue.length) {
      var eq = this._emitQueue.slice(0)
      this._emitQueue.length = 0
      for (var i = 0; i < eq.length; i ++) {
        var e = eq[i]
        this._emitMatch(e[0], e[1])
      }
    }
    if (this._processQueue.length) {
      var pq = this._processQueue.slice(0)
      this._processQueue.length = 0
      for (var i = 0; i < pq.length; i ++) {
        var p = pq[i]
        this._processing--
        this._process(p[0], p[1], p[2], p[3])
      }
    }
  }
}

Glob.prototype._process = function (pattern, index, inGlobStar, cb) {
  assert(this instanceof Glob)
  assert(typeof cb === 'function')

  if (this.aborted)
    return

  this._processing++
  if (this.paused) {
    this._processQueue.push([pattern, index, inGlobStar, cb])
    return
  }

  //console.error('PROCESS %d', this._processing, pattern)

  // Get the first [n] parts of pattern that are all strings.
  var n = 0
  while (typeof pattern[n] === 'string') {
    n ++
  }
  // now n is the index of the first one that is *not* a string.

  // see if there's anything else
  var prefix
  switch (n) {
    // if not, then this is rather simple
    case pattern.length:
      this._processSimple(pattern.join('/'), index, cb)
      return

    case 0:
      // pattern *starts* with some non-trivial item.
      // going to readdir(cwd), but not include the prefix in matches.
      prefix = null
      break

    default:
      // pattern has some string bits in the front.
      // whatever it starts with, whether that's 'absolute' like /foo/bar,
      // or 'relative' like '../baz'
      prefix = pattern.slice(0, n).join('/')
      break
  }

  var remain = pattern.slice(n)

  // get the list of entries.
  var read
  if (prefix === null)
    read = '.'
  else if (isAbsolute(prefix) || isAbsolute(pattern.join('/'))) {
    if (!prefix || !isAbsolute(prefix))
      prefix = '/' + prefix
    read = prefix
  } else
    read = prefix

  var abs = this._makeAbs(read)

  //if ignored, skip _processing
  if (childrenIgnored(this, read))
    return cb()

  var isGlobStar = remain[0] === minimatch.GLOBSTAR
  if (isGlobStar)
    this._processGlobStar(prefix, read, abs, remain, index, inGlobStar, cb)
  else
    this._processReaddir(prefix, read, abs, remain, index, inGlobStar, cb)
}

Glob.prototype._processReaddir = function (prefix, read, abs, remain, index, inGlobStar, cb) {
  var self = this
  this._readdir(abs, inGlobStar, function (er, entries) {
    return self._processReaddir2(prefix, read, abs, remain, index, inGlobStar, entries, cb)
  })
}

Glob.prototype._processReaddir2 = function (prefix, read, abs, remain, index, inGlobStar, entries, cb) {

  // if the abs isn't a dir, then nothing can match!
  if (!entries)
    return cb()

  // It will only match dot entries if it starts with a dot, or if
  // dot is set.  Stuff like @(.foo|.bar) isn't allowed.
  var pn = remain[0]
  var negate = !!this.minimatch.negate
  var rawGlob = pn._glob
  var dotOk = this.dot || rawGlob.charAt(0) === '.'

  var matchedEntries = []
  for (var i = 0; i < entries.length; i++) {
    var e = entries[i]
    if (e.charAt(0) !== '.' || dotOk) {
      var m
      if (negate && !prefix) {
        m = !e.match(pn)
      } else {
        m = e.match(pn)
      }
      if (m)
        matchedEntries.push(e)
    }
  }

  //console.error('prd2', prefix, entries, remain[0]._glob, matchedEntries)

  var len = matchedEntries.length
  // If there are no matched entries, then nothing matches.
  if (len === 0)
    return cb()

  // if this is the last remaining pattern bit, then no need for
  // an additional stat *unless* the user has specified mark or
  // stat explicitly.  We know they exist, since readdir returned
  // them.

  if (remain.length === 1 && !this.mark && !this.stat) {
    if (!this.matches[index])
      this.matches[index] = Object.create(null)

    for (var i = 0; i < len; i ++) {
      var e = matchedEntries[i]
      if (prefix) {
        if (prefix !== '/')
          e = prefix + '/' + e
        else
          e = prefix + e
      }

      if (e.charAt(0) === '/' && !this.nomount) {
        e = path.join(this.root, e)
      }
      this._emitMatch(index, e)
    }
    // This was the last one, and no stats were needed
    return cb()
  }

  // now test all matched entries as stand-ins for that part
  // of the pattern.
  remain.shift()
  for (var i = 0; i < len; i ++) {
    var e = matchedEntries[i]
    var newPattern
    if (prefix) {
      if (prefix !== '/')
        e = prefix + '/' + e
      else
        e = prefix + e
    }
    this._process([e].concat(remain), index, inGlobStar, cb)
  }
  cb()
}

Glob.prototype._emitMatch = function (index, e) {
  if (this.aborted)
    return

  if (this.matches[index][e])
    return

  if (isIgnored(this, e))
    return

  if (this.paused) {
    this._emitQueue.push([index, e])
    return
  }

  var abs = this._makeAbs(e)

  if (this.nodir) {
    var c = this.cache[abs]
    if (c === 'DIR' || Array.isArray(c))
      return
  }

  if (this.mark)
    e = this._mark(e)

  this.matches[index][e] = true

  var st = this.statCache[abs]
  if (st)
    this.emit('stat', e, st)

  this.emit('match', e)
}

Glob.prototype._readdirInGlobStar = function (abs, cb) {
  if (this.aborted)
    return

  // follow all symlinked directories forever
  // just proceed as if this is a non-globstar situation
  if (this.follow)
    return this._readdir(abs, false, cb)

  var lstatkey = 'lstat\0' + abs
  var self = this
  var lstatcb = inflight(lstatkey, lstatcb_)

  if (lstatcb)
    fs.lstat(abs, lstatcb)

  function lstatcb_ (er, lstat) {
    if (er)
      return cb()

    var isSym = lstat.isSymbolicLink()
    self.symlinks[abs] = isSym

    // If it's not a symlink or a dir, then it's definitely a regular file.
    // don't bother doing a readdir in that case.
    if (!isSym && !lstat.isDirectory()) {
      self.cache[abs] = 'FILE'
      cb()
    } else
      self._readdir(abs, false, cb)
  }
}

Glob.prototype._readdir = function (abs, inGlobStar, cb) {
  if (this.aborted)
    return

  cb = inflight('readdir\0'+abs+'\0'+inGlobStar, cb)
  if (!cb)
    return

  //console.error('RD %j %j', +inGlobStar, abs)
  if (inGlobStar && !ownProp(this.symlinks, abs))
    return this._readdirInGlobStar(abs, cb)

  if (ownProp(this.cache, abs)) {
    var c = this.cache[abs]
    if (!c || c === 'FILE')
      return cb()

    if (Array.isArray(c))
      return cb(null, c)
  }

  var self = this
  fs.readdir(abs, readdirCb(this, abs, cb))
}

function readdirCb (self, abs, cb) {
  return function (er, entries) {
    if (er)
      self._readdirError(abs, er, cb)
    else
      self._readdirEntries(abs, entries, cb)
  }
}

Glob.prototype._readdirEntries = function (abs, entries, cb) {
  if (this.aborted)
    return

  // if we haven't asked to stat everything, then just
  // assume that everything in there exists, so we can avoid
  // having to stat it a second time.
  if (!this.mark && !this.stat) {
    for (var i = 0; i < entries.length; i ++) {
      var e = entries[i]
      if (abs === '/')
        e = abs + e
      else
        e = abs + '/' + e
      this.cache[e] = true
    }
  }

  this.cache[abs] = entries
  return cb(null, entries)
}

Glob.prototype._readdirError = function (f, er, cb) {
  if (this.aborted)
    return

  // handle errors, and cache the information
  switch (er.code) {
    case 'ENOTSUP': // https://github.com/isaacs/node-glob/issues/205
    case 'ENOTDIR': // totally normal. means it *does* exist.
      var abs = this._makeAbs(f)
      this.cache[abs] = 'FILE'
      if (abs === this.cwdAbs) {
        var error = new Error(er.code + ' invalid cwd ' + this.cwd)
        error.path = this.cwd
        error.code = er.code
        this.emit('error', error)
        this.abort()
      }
      break

    case 'ENOENT': // not terribly unusual
    case 'ELOOP':
    case 'ENAMETOOLONG':
    case 'UNKNOWN':
      this.cache[this._makeAbs(f)] = false
      break

    default: // some unusual error.  Treat as failure.
      this.cache[this._makeAbs(f)] = false
      if (this.strict) {
        this.emit('error', er)
        // If the error is handled, then we abort
        // if not, we threw out of here
        this.abort()
      }
      if (!this.silent)
        console.error('glob error', er)
      break
  }

  return cb()
}

Glob.prototype._processGlobStar = function (prefix, read, abs, remain, index, inGlobStar, cb) {
  var self = this
  this._readdir(abs, inGlobStar, function (er, entries) {
    self._processGlobStar2(prefix, read, abs, remain, index, inGlobStar, entries, cb)
  })
}


Glob.prototype._processGlobStar2 = function (prefix, read, abs, remain, index, inGlobStar, entries, cb) {
  //console.error('pgs2', prefix, remain[0], entries)

  // no entries means not a dir, so it can never have matches
  // foo.txt/** doesn't match foo.txt
  if (!entries)
    return cb()

  // test without the globstar, and with every child both below
  // and replacing the globstar.
  var remainWithoutGlobStar = remain.slice(1)
  var gspref = prefix ? [ prefix ] : []
  var noGlobStar = gspref.concat(remainWithoutGlobStar)

  // the noGlobStar pattern exits the inGlobStar state
  this._process(noGlobStar, index, false, cb)

  var isSym = this.symlinks[abs]
  var len = entries.length

  // If it's a symlink, and we're in a globstar, then stop
  if (isSym && inGlobStar)
    return cb()

  for (var i = 0; i < len; i++) {
    var e = entries[i]
    if (e.charAt(0) === '.' && !this.dot)
      continue

    // these two cases enter the inGlobStar state
    var instead = gspref.concat(entries[i], remainWithoutGlobStar)
    this._process(instead, index, true, cb)

    var below = gspref.concat(entries[i], remain)
    this._process(below, index, true, cb)
  }

  cb()
}

Glob.prototype._processSimple = function (prefix, index, cb) {
  // XXX review this.  Shouldn't it be doing the mounting etc
  // before doing stat?  kinda weird?
  var self = this
  this._stat(prefix, function (er, exists) {
    self._processSimple2(prefix, index, er, exists, cb)
  })
}
Glob.prototype._processSimple2 = function (prefix, index, er, exists, cb) {

  //console.error('ps2', prefix, exists)

  if (!this.matches[index])
    this.matches[index] = Object.create(null)

  // If it doesn't exist, then just mark the lack of results
  if (!exists)
    return cb()

  if (prefix && isAbsolute(prefix) && !this.nomount) {
    var trail = /[\/\\]$/.test(prefix)
    if (prefix.charAt(0) === '/') {
      prefix = path.join(this.root, prefix)
    } else {
      prefix = path.resolve(this.root, prefix)
      if (trail)
        prefix += '/'
    }
  }

  if (process.platform === 'win32')
    prefix = prefix.replace(/\\/g, '/')

  // Mark this as a match
  this._emitMatch(index, prefix)
  cb()
}

// Returns either 'DIR', 'FILE', or false
Glob.prototype._stat = function (f, cb) {
  var abs = this._makeAbs(f)
  var needDir = f.slice(-1) === '/'

  if (f.length > this.maxLength)
    return cb()

  if (!this.stat && ownProp(this.cache, abs)) {
    var c = this.cache[abs]

    if (Array.isArray(c))
      c = 'DIR'

    // It exists, but maybe not how we need it
    if (!needDir || c === 'DIR')
      return cb(null, c)

    if (needDir && c === 'FILE')
      return cb()

    // otherwise we have to stat, because maybe c=true
    // if we know it exists, but not what it is.
  }

  var exists
  var stat = this.statCache[abs]
  if (stat !== undefined) {
    if (stat === false)
      return cb(null, stat)
    else {
      var type = stat.isDirectory() ? 'DIR' : 'FILE'
      if (needDir && type === 'FILE')
        return cb()
      else
        return cb(null, type, stat)
    }
  }

  var self = this
  var statcb = inflight('stat\0' + abs, lstatcb_)
  if (statcb)
    fs.lstat(abs, statcb)

  function lstatcb_ (er, lstat) {
    if (lstat && lstat.isSymbolicLink()) {
      // If it's a symlink, then treat it as the target, unless
      // the target does not exist, then treat it as a file.
      return fs.stat(abs, function (er, stat) {
        if (er)
          self._stat2(f, abs, null, lstat, cb)
        else
          self._stat2(f, abs, er, stat, cb)
      })
    } else {
      self._stat2(f, abs, er, lstat, cb)
    }
  }
}

Glob.prototype._stat2 = function (f, abs, er, stat, cb) {
  if (er) {
    this.statCache[abs] = false
    return cb()
  }

  var needDir = f.slice(-1) === '/'
  this.statCache[abs] = stat

  if (abs.slice(-1) === '/' && !stat.isDirectory())
    return cb(null, false, stat)

  var c = stat.isDirectory() ? 'DIR' : 'FILE'
  this.cache[abs] = this.cache[abs] || c

  if (needDir && c !== 'DIR')
    return cb()

  return cb(null, c, stat)
}

},{"./common.js":28,"./sync.js":30,"assert":undefined,"events":undefined,"fs":undefined,"inflight":31,"inherits":32,"minimatch":37,"once":39,"path":undefined,"path-is-absolute":43,"util":undefined}],30:[function(require,module,exports){
module.exports = globSync
globSync.GlobSync = GlobSync

var fs = require('fs')
var minimatch = require('minimatch')
var Minimatch = minimatch.Minimatch
var Glob = require('./glob.js').Glob
var util = require('util')
var path = require('path')
var assert = require('assert')
var isAbsolute = require('path-is-absolute')
var common = require('./common.js')
var alphasort = common.alphasort
var alphasorti = common.alphasorti
var setopts = common.setopts
var ownProp = common.ownProp
var childrenIgnored = common.childrenIgnored

function globSync (pattern, options) {
  if (typeof options === 'function' || arguments.length === 3)
    throw new TypeError('callback provided to sync glob\n'+
                        'See: https://github.com/isaacs/node-glob/issues/167')

  return new GlobSync(pattern, options).found
}

function GlobSync (pattern, options) {
  if (!pattern)
    throw new Error('must provide pattern')

  if (typeof options === 'function' || arguments.length === 3)
    throw new TypeError('callback provided to sync glob\n'+
                        'See: https://github.com/isaacs/node-glob/issues/167')

  if (!(this instanceof GlobSync))
    return new GlobSync(pattern, options)

  setopts(this, pattern, options)

  if (this.noprocess)
    return this

  var n = this.minimatch.set.length
  this.matches = new Array(n)
  for (var i = 0; i < n; i ++) {
    this._process(this.minimatch.set[i], i, false)
  }
  this._finish()
}

GlobSync.prototype._finish = function () {
  assert(this instanceof GlobSync)
  if (this.realpath) {
    var self = this
    this.matches.forEach(function (matchset, index) {
      var set = self.matches[index] = Object.create(null)
      for (var p in matchset) {
        try {
          p = self._makeAbs(p)
          var real = fs.realpathSync(p, self.realpathCache)
          set[real] = true
        } catch (er) {
          if (er.syscall === 'stat')
            set[self._makeAbs(p)] = true
          else
            throw er
        }
      }
    })
  }
  common.finish(this)
}


GlobSync.prototype._process = function (pattern, index, inGlobStar) {
  assert(this instanceof GlobSync)

  // Get the first [n] parts of pattern that are all strings.
  var n = 0
  while (typeof pattern[n] === 'string') {
    n ++
  }
  // now n is the index of the first one that is *not* a string.

  // See if there's anything else
  var prefix
  switch (n) {
    // if not, then this is rather simple
    case pattern.length:
      this._processSimple(pattern.join('/'), index)
      return

    case 0:
      // pattern *starts* with some non-trivial item.
      // going to readdir(cwd), but not include the prefix in matches.
      prefix = null
      break

    default:
      // pattern has some string bits in the front.
      // whatever it starts with, whether that's 'absolute' like /foo/bar,
      // or 'relative' like '../baz'
      prefix = pattern.slice(0, n).join('/')
      break
  }

  var remain = pattern.slice(n)

  // get the list of entries.
  var read
  if (prefix === null)
    read = '.'
  else if (isAbsolute(prefix) || isAbsolute(pattern.join('/'))) {
    if (!prefix || !isAbsolute(prefix))
      prefix = '/' + prefix
    read = prefix
  } else
    read = prefix

  var abs = this._makeAbs(read)

  //if ignored, skip processing
  if (childrenIgnored(this, read))
    return

  var isGlobStar = remain[0] === minimatch.GLOBSTAR
  if (isGlobStar)
    this._processGlobStar(prefix, read, abs, remain, index, inGlobStar)
  else
    this._processReaddir(prefix, read, abs, remain, index, inGlobStar)
}


GlobSync.prototype._processReaddir = function (prefix, read, abs, remain, index, inGlobStar) {
  var entries = this._readdir(abs, inGlobStar)

  // if the abs isn't a dir, then nothing can match!
  if (!entries)
    return

  // It will only match dot entries if it starts with a dot, or if
  // dot is set.  Stuff like @(.foo|.bar) isn't allowed.
  var pn = remain[0]
  var negate = !!this.minimatch.negate
  var rawGlob = pn._glob
  var dotOk = this.dot || rawGlob.charAt(0) === '.'

  var matchedEntries = []
  for (var i = 0; i < entries.length; i++) {
    var e = entries[i]
    if (e.charAt(0) !== '.' || dotOk) {
      var m
      if (negate && !prefix) {
        m = !e.match(pn)
      } else {
        m = e.match(pn)
      }
      if (m)
        matchedEntries.push(e)
    }
  }

  var len = matchedEntries.length
  // If there are no matched entries, then nothing matches.
  if (len === 0)
    return

  // if this is the last remaining pattern bit, then no need for
  // an additional stat *unless* the user has specified mark or
  // stat explicitly.  We know they exist, since readdir returned
  // them.

  if (remain.length === 1 && !this.mark && !this.stat) {
    if (!this.matches[index])
      this.matches[index] = Object.create(null)

    for (var i = 0; i < len; i ++) {
      var e = matchedEntries[i]
      if (prefix) {
        if (prefix.slice(-1) !== '/')
          e = prefix + '/' + e
        else
          e = prefix + e
      }

      if (e.charAt(0) === '/' && !this.nomount) {
        e = path.join(this.root, e)
      }
      this.matches[index][e] = true
    }
    // This was the last one, and no stats were needed
    return
  }

  // now test all matched entries as stand-ins for that part
  // of the pattern.
  remain.shift()
  for (var i = 0; i < len; i ++) {
    var e = matchedEntries[i]
    var newPattern
    if (prefix)
      newPattern = [prefix, e]
    else
      newPattern = [e]
    this._process(newPattern.concat(remain), index, inGlobStar)
  }
}


GlobSync.prototype._emitMatch = function (index, e) {
  var abs = this._makeAbs(e)
  if (this.mark)
    e = this._mark(e)

  if (this.matches[index][e])
    return

  if (this.nodir) {
    var c = this.cache[this._makeAbs(e)]
    if (c === 'DIR' || Array.isArray(c))
      return
  }

  this.matches[index][e] = true
  if (this.stat)
    this._stat(e)
}


GlobSync.prototype._readdirInGlobStar = function (abs) {
  // follow all symlinked directories forever
  // just proceed as if this is a non-globstar situation
  if (this.follow)
    return this._readdir(abs, false)

  var entries
  var lstat
  var stat
  try {
    lstat = fs.lstatSync(abs)
  } catch (er) {
    // lstat failed, doesn't exist
    return null
  }

  var isSym = lstat.isSymbolicLink()
  this.symlinks[abs] = isSym

  // If it's not a symlink or a dir, then it's definitely a regular file.
  // don't bother doing a readdir in that case.
  if (!isSym && !lstat.isDirectory())
    this.cache[abs] = 'FILE'
  else
    entries = this._readdir(abs, false)

  return entries
}

GlobSync.prototype._readdir = function (abs, inGlobStar) {
  var entries

  if (inGlobStar && !ownProp(this.symlinks, abs))
    return this._readdirInGlobStar(abs)

  if (ownProp(this.cache, abs)) {
    var c = this.cache[abs]
    if (!c || c === 'FILE')
      return null

    if (Array.isArray(c))
      return c
  }

  try {
    return this._readdirEntries(abs, fs.readdirSync(abs))
  } catch (er) {
    this._readdirError(abs, er)
    return null
  }
}

GlobSync.prototype._readdirEntries = function (abs, entries) {
  // if we haven't asked to stat everything, then just
  // assume that everything in there exists, so we can avoid
  // having to stat it a second time.
  if (!this.mark && !this.stat) {
    for (var i = 0; i < entries.length; i ++) {
      var e = entries[i]
      if (abs === '/')
        e = abs + e
      else
        e = abs + '/' + e
      this.cache[e] = true
    }
  }

  this.cache[abs] = entries

  // mark and cache dir-ness
  return entries
}

GlobSync.prototype._readdirError = function (f, er) {
  // handle errors, and cache the information
  switch (er.code) {
    case 'ENOTSUP': // https://github.com/isaacs/node-glob/issues/205
    case 'ENOTDIR': // totally normal. means it *does* exist.
      var abs = this._makeAbs(f)
      this.cache[abs] = 'FILE'
      if (abs === this.cwdAbs) {
        var error = new Error(er.code + ' invalid cwd ' + this.cwd)
        error.path = this.cwd
        error.code = er.code
        throw error
      }
      break

    case 'ENOENT': // not terribly unusual
    case 'ELOOP':
    case 'ENAMETOOLONG':
    case 'UNKNOWN':
      this.cache[this._makeAbs(f)] = false
      break

    default: // some unusual error.  Treat as failure.
      this.cache[this._makeAbs(f)] = false
      if (this.strict)
        throw er
      if (!this.silent)
        console.error('glob error', er)
      break
  }
}

GlobSync.prototype._processGlobStar = function (prefix, read, abs, remain, index, inGlobStar) {

  var entries = this._readdir(abs, inGlobStar)

  // no entries means not a dir, so it can never have matches
  // foo.txt/** doesn't match foo.txt
  if (!entries)
    return

  // test without the globstar, and with every child both below
  // and replacing the globstar.
  var remainWithoutGlobStar = remain.slice(1)
  var gspref = prefix ? [ prefix ] : []
  var noGlobStar = gspref.concat(remainWithoutGlobStar)

  // the noGlobStar pattern exits the inGlobStar state
  this._process(noGlobStar, index, false)

  var len = entries.length
  var isSym = this.symlinks[abs]

  // If it's a symlink, and we're in a globstar, then stop
  if (isSym && inGlobStar)
    return

  for (var i = 0; i < len; i++) {
    var e = entries[i]
    if (e.charAt(0) === '.' && !this.dot)
      continue

    // these two cases enter the inGlobStar state
    var instead = gspref.concat(entries[i], remainWithoutGlobStar)
    this._process(instead, index, true)

    var below = gspref.concat(entries[i], remain)
    this._process(below, index, true)
  }
}

GlobSync.prototype._processSimple = function (prefix, index) {
  // XXX review this.  Shouldn't it be doing the mounting etc
  // before doing stat?  kinda weird?
  var exists = this._stat(prefix)

  if (!this.matches[index])
    this.matches[index] = Object.create(null)

  // If it doesn't exist, then just mark the lack of results
  if (!exists)
    return

  if (prefix && isAbsolute(prefix) && !this.nomount) {
    var trail = /[\/\\]$/.test(prefix)
    if (prefix.charAt(0) === '/') {
      prefix = path.join(this.root, prefix)
    } else {
      prefix = path.resolve(this.root, prefix)
      if (trail)
        prefix += '/'
    }
  }

  if (process.platform === 'win32')
    prefix = prefix.replace(/\\/g, '/')

  // Mark this as a match
  this.matches[index][prefix] = true
}

// Returns either 'DIR', 'FILE', or false
GlobSync.prototype._stat = function (f) {
  var abs = this._makeAbs(f)
  var needDir = f.slice(-1) === '/'

  if (f.length > this.maxLength)
    return false

  if (!this.stat && ownProp(this.cache, abs)) {
    var c = this.cache[abs]

    if (Array.isArray(c))
      c = 'DIR'

    // It exists, but maybe not how we need it
    if (!needDir || c === 'DIR')
      return c

    if (needDir && c === 'FILE')
      return false

    // otherwise we have to stat, because maybe c=true
    // if we know it exists, but not what it is.
  }

  var exists
  var stat = this.statCache[abs]
  if (!stat) {
    var lstat
    try {
      lstat = fs.lstatSync(abs)
    } catch (er) {
      return false
    }

    if (lstat.isSymbolicLink()) {
      try {
        stat = fs.statSync(abs)
      } catch (er) {
        stat = lstat
      }
    } else {
      stat = lstat
    }
  }

  this.statCache[abs] = stat

  var c = stat.isDirectory() ? 'DIR' : 'FILE'
  this.cache[abs] = this.cache[abs] || c

  if (needDir && c !== 'DIR')
    return false

  return c
}

GlobSync.prototype._mark = function (p) {
  return common.mark(this, p)
}

GlobSync.prototype._makeAbs = function (f) {
  return common.makeAbs(this, f)
}

},{"./common.js":28,"./glob.js":29,"assert":undefined,"fs":undefined,"minimatch":37,"path":undefined,"path-is-absolute":43,"util":undefined}],31:[function(require,module,exports){
var wrappy = require('wrappy')
var reqs = Object.create(null)
var once = require('once')

module.exports = wrappy(inflight)

function inflight (key, cb) {
  if (reqs[key]) {
    reqs[key].push(cb)
    return null
  } else {
    reqs[key] = [cb]
    return makeres(key)
  }
}

function makeres (key) {
  return once(function RES () {
    var cbs = reqs[key]
    var len = cbs.length
    var args = slice(arguments)
    for (var i = 0; i < len; i++) {
      cbs[i].apply(null, args)
    }
    if (cbs.length > len) {
      // added more in the interim.
      // de-zalgo, just in case, but don't call again.
      cbs.splice(0, len)
      process.nextTick(function () {
        RES.apply(null, args)
      })
    } else {
      delete reqs[key]
    }
  })
}

function slice (args) {
  var length = args.length
  var array = []

  for (var i = 0; i < length; i++) array[i] = args[i]
  return array
}

},{"once":39,"wrappy":65}],32:[function(require,module,exports){
module.exports = require('util').inherits

},{"util":undefined}],33:[function(require,module,exports){
'use strict';
module.exports = function (obj) {
	if (typeof obj !== 'object') {
		throw new TypeError('Expected an object');
	}

	var ret = {};

	for (var key in obj) {
		var val = obj[key];
		ret[val] = key;
	}

	return ret;
};

},{}],34:[function(require,module,exports){
/*
 * js-sha256 v0.3.0
 * https://github.com/emn178/js-sha256
 *
 * Copyright 2014-2015, emn178@gmail.com
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */
;(function(root, undefined) {
  'use strict';

  var NODE_JS = typeof(module) != 'undefined';
  if(NODE_JS) {
    root = global;
  }
  var TYPED_ARRAY = typeof(Uint8Array) != 'undefined';
  var HEX_CHARS = '0123456789abcdef'.split('');
  var EXTRA = [-2147483648, 8388608, 32768, 128];
  var SHIFT = [24, 16, 8, 0];
  var K =[0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5, 0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5,
          0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3, 0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174,
          0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc, 0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da,
          0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7, 0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967,
          0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13, 0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85,
          0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3, 0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070,
          0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5, 0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3,
          0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208, 0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2];

  var blocks = [];

  var sha224 = function(message) {
    return sha256(message, true);
  };

  var sha256 = function(message, is224) {
    var notString = typeof(message) != 'string';
    if(notString && message.constructor == root.ArrayBuffer) {
      message = new Uint8Array(message);
    }

    var h0, h1, h2, h3, h4, h5, h6, h7, block, code, first = true, end = false,
        i, j, index = 0, start = 0, bytes = 0, length = message.length,
        s0, s1, maj, t1, t2, ch, ab, da, cd, bc;

    if(is224) {
      h0 = 0xc1059ed8;
      h1 = 0x367cd507;
      h2 = 0x3070dd17;
      h3 = 0xf70e5939;
      h4 = 0xffc00b31;
      h5 = 0x68581511;
      h6 = 0x64f98fa7;
      h7 = 0xbefa4fa4;
    } else { // 256
      h0 = 0x6a09e667;
      h1 = 0xbb67ae85;
      h2 = 0x3c6ef372;
      h3 = 0xa54ff53a;
      h4 = 0x510e527f;
      h5 = 0x9b05688c;
      h6 = 0x1f83d9ab;
      h7 = 0x5be0cd19;
    }
    block = 0;
    do {
      blocks[0] = block;
      blocks[16] = blocks[1] = blocks[2] = blocks[3] =
      blocks[4] = blocks[5] = blocks[6] = blocks[7] =
      blocks[8] = blocks[9] = blocks[10] = blocks[11] =
      blocks[12] = blocks[13] = blocks[14] = blocks[15] = 0;
      if(notString) {
        for (i = start;index < length && i < 64; ++index) {
          blocks[i >> 2] |= message[index] << SHIFT[i++ & 3];
        }
      } else {
        for (i = start;index < length && i < 64; ++index) {
          code = message.charCodeAt(index);
          if (code < 0x80) {
            blocks[i >> 2] |= code << SHIFT[i++ & 3];
          } else if (code < 0x800) {
            blocks[i >> 2] |= (0xc0 | (code >> 6)) << SHIFT[i++ & 3];
            blocks[i >> 2] |= (0x80 | (code & 0x3f)) << SHIFT[i++ & 3];
          } else if (code < 0xd800 || code >= 0xe000) {
            blocks[i >> 2] |= (0xe0 | (code >> 12)) << SHIFT[i++ & 3];
            blocks[i >> 2] |= (0x80 | ((code >> 6) & 0x3f)) << SHIFT[i++ & 3];
            blocks[i >> 2] |= (0x80 | (code & 0x3f)) << SHIFT[i++ & 3];
          } else {
            code = 0x10000 + (((code & 0x3ff) << 10) | (message.charCodeAt(++index) & 0x3ff));
            blocks[i >> 2] |= (0xf0 | (code >> 18)) << SHIFT[i++ & 3];
            blocks[i >> 2] |= (0x80 | ((code >> 12) & 0x3f)) << SHIFT[i++ & 3];
            blocks[i >> 2] |= (0x80 | ((code >> 6) & 0x3f)) << SHIFT[i++ & 3];
            blocks[i >> 2] |= (0x80 | (code & 0x3f)) << SHIFT[i++ & 3];
          }
        }
      }
      bytes += i - start;
      start = i - 64;
      if(index == length) {
        blocks[i >> 2] |= EXTRA[i & 3];
        ++index;
      }
      block = blocks[16];
      if(index > length && i < 56) {
        blocks[15] = bytes << 3;
        end = true;
      }

      var a = h0, b = h1, c = h2, d = h3, e = h4, f = h5, g = h6, h = h7;
      for(j = 16;j < 64;++j) {
        // rightrotate
        t1 = blocks[j - 15];
        s0 = ((t1 >>> 7) | (t1 << 25)) ^ ((t1 >>> 18) | (t1 << 14)) ^ (t1 >>> 3);
        t1 = blocks[j - 2];
        s1 = ((t1 >>> 17) | (t1 << 15)) ^ ((t1 >>> 19) | (t1 << 13)) ^ (t1 >>> 10);
        blocks[j] = blocks[j - 16] + s0 + blocks[j - 7] + s1 << 0;
      }

      bc = b & c;
      for(j = 0;j < 64;j += 4) {
        if(first) {
          if(is224) {
            ab = 300032;
            t1 = blocks[0] - 1413257819;
            h = t1 - 150054599 << 0;
            d = t1 + 24177077 << 0;
          } else {
            ab = 704751109;
            t1 = blocks[0] - 210244248;
            h = t1 - 1521486534 << 0;
            d = t1 + 143694565 << 0;
          }
          first = false;
        } else {
          s0 = ((a >>> 2) | (a << 30)) ^ ((a >>> 13) | (a << 19)) ^ ((a >>> 22) | (a << 10));
          s1 = ((e >>> 6) | (e << 26)) ^ ((e >>> 11) | (e << 21)) ^ ((e >>> 25) | (e << 7));
          ab = a & b;
          maj = ab ^ (a & c) ^ bc;
          ch = (e & f) ^ (~e & g);
          t1 = h + s1 + ch + K[j] + blocks[j];
          t2 = s0 + maj;
          h = d + t1 << 0;
          d = t1 + t2 << 0;
        }
        s0 = ((d >>> 2) | (d << 30)) ^ ((d >>> 13) | (d << 19)) ^ ((d >>> 22) | (d << 10));
        s1 = ((h >>> 6) | (h << 26)) ^ ((h >>> 11) | (h << 21)) ^ ((h >>> 25) | (h << 7));
        da = d & a;
        maj = da ^ (d & b) ^ ab;
        ch = (h & e) ^ (~h & f);
        t1 = g + s1 + ch + K[j + 1] + blocks[j + 1];
        t2 = s0 + maj;
        g = c + t1 << 0;
        c = t1 + t2 << 0;
        s0 = ((c >>> 2) | (c << 30)) ^ ((c >>> 13) | (c << 19)) ^ ((c >>> 22) | (c << 10));
        s1 = ((g >>> 6) | (g << 26)) ^ ((g >>> 11) | (g << 21)) ^ ((g >>> 25) | (g << 7));
        cd = c & d;
        maj = cd ^ (c & a) ^ da;
        ch = (g & h) ^ (~g & e);
        t1 = f + s1 + ch + K[j + 2] + blocks[j + 2];
        t2 = s0 + maj;
        f = b + t1 << 0;
        b = t1 + t2 << 0;
        s0 = ((b >>> 2) | (b << 30)) ^ ((b >>> 13) | (b << 19)) ^ ((b >>> 22) | (b << 10));
        s1 = ((f >>> 6) | (f << 26)) ^ ((f >>> 11) | (f << 21)) ^ ((f >>> 25) | (f << 7));
        bc = b & c;
        maj = bc ^ (b & d) ^ cd;
        ch = (f & g) ^ (~f & h);
        t1 = e + s1 + ch + K[j + 3] + blocks[j + 3];
        t2 = s0 + maj;
        e = a + t1 << 0;
        a = t1 + t2 << 0;
      }

      h0 = h0 + a << 0;
      h1 = h1 + b << 0;
      h2 = h2 + c << 0;
      h3 = h3 + d << 0;
      h4 = h4 + e << 0;
      h5 = h5 + f << 0;
      h6 = h6 + g << 0;
      h7 = h7 + h << 0;
    } while(!end);

    var hex = HEX_CHARS[(h0 >> 28) & 0x0F] + HEX_CHARS[(h0 >> 24) & 0x0F] +
              HEX_CHARS[(h0 >> 20) & 0x0F] + HEX_CHARS[(h0 >> 16) & 0x0F] +
              HEX_CHARS[(h0 >> 12) & 0x0F] + HEX_CHARS[(h0 >> 8) & 0x0F] +
              HEX_CHARS[(h0 >> 4) & 0x0F] + HEX_CHARS[h0 & 0x0F] +
              HEX_CHARS[(h1 >> 28) & 0x0F] + HEX_CHARS[(h1 >> 24) & 0x0F] +
              HEX_CHARS[(h1 >> 20) & 0x0F] + HEX_CHARS[(h1 >> 16) & 0x0F] +
              HEX_CHARS[(h1 >> 12) & 0x0F] + HEX_CHARS[(h1 >> 8) & 0x0F] +
              HEX_CHARS[(h1 >> 4) & 0x0F] + HEX_CHARS[h1 & 0x0F] +
              HEX_CHARS[(h2 >> 28) & 0x0F] + HEX_CHARS[(h2 >> 24) & 0x0F] +
              HEX_CHARS[(h2 >> 20) & 0x0F] + HEX_CHARS[(h2 >> 16) & 0x0F] +
              HEX_CHARS[(h2 >> 12) & 0x0F] + HEX_CHARS[(h2 >> 8) & 0x0F] +
              HEX_CHARS[(h2 >> 4) & 0x0F] + HEX_CHARS[h2 & 0x0F] +
              HEX_CHARS[(h3 >> 28) & 0x0F] + HEX_CHARS[(h3 >> 24) & 0x0F] +
              HEX_CHARS[(h3 >> 20) & 0x0F] + HEX_CHARS[(h3 >> 16) & 0x0F] +
              HEX_CHARS[(h3 >> 12) & 0x0F] + HEX_CHARS[(h3 >> 8) & 0x0F] +
              HEX_CHARS[(h3 >> 4) & 0x0F] + HEX_CHARS[h3 & 0x0F] +
              HEX_CHARS[(h4 >> 28) & 0x0F] + HEX_CHARS[(h4 >> 24) & 0x0F] +
              HEX_CHARS[(h4 >> 20) & 0x0F] + HEX_CHARS[(h4 >> 16) & 0x0F] +
              HEX_CHARS[(h4 >> 12) & 0x0F] + HEX_CHARS[(h4 >> 8) & 0x0F] +
              HEX_CHARS[(h4 >> 4) & 0x0F] + HEX_CHARS[h4 & 0x0F] +
              HEX_CHARS[(h5 >> 28) & 0x0F] + HEX_CHARS[(h5 >> 24) & 0x0F] +
              HEX_CHARS[(h5 >> 20) & 0x0F] + HEX_CHARS[(h5 >> 16) & 0x0F] +
              HEX_CHARS[(h5 >> 12) & 0x0F] + HEX_CHARS[(h5 >> 8) & 0x0F] +
              HEX_CHARS[(h5 >> 4) & 0x0F] + HEX_CHARS[h5 & 0x0F] +
              HEX_CHARS[(h6 >> 28) & 0x0F] + HEX_CHARS[(h6 >> 24) & 0x0F] +
              HEX_CHARS[(h6 >> 20) & 0x0F] + HEX_CHARS[(h6 >> 16) & 0x0F] +
              HEX_CHARS[(h6 >> 12) & 0x0F] + HEX_CHARS[(h6 >> 8) & 0x0F] +
              HEX_CHARS[(h6 >> 4) & 0x0F] + HEX_CHARS[h6 & 0x0F];
    if(!is224) {
      hex += HEX_CHARS[(h7 >> 28) & 0x0F] + HEX_CHARS[(h7 >> 24) & 0x0F] +
             HEX_CHARS[(h7 >> 20) & 0x0F] + HEX_CHARS[(h7 >> 16) & 0x0F] +
             HEX_CHARS[(h7 >> 12) & 0x0F] + HEX_CHARS[(h7 >> 8) & 0x0F] +
             HEX_CHARS[(h7 >> 4) & 0x0F] + HEX_CHARS[h7 & 0x0F];
    }
    return hex;
  };
  
  if(!root.JS_SHA256_TEST && NODE_JS) {
    sha256.sha256 = sha256;
    sha256.sha224 = sha224;
    module.exports = sha256;
  } else if(root) {
    root.sha256 = sha256;
    root.sha224 = sha224;
  }
}(this));

},{}],35:[function(require,module,exports){
'use strict';
var invertKv = require('invert-kv');
var all = require('./lcid.json');
var inverted = invertKv(all);

exports.from = function (lcidCode) {
	if (typeof lcidCode !== 'number') {
		throw new TypeError('Expected a number');
	}

	return inverted[lcidCode];
};

exports.to = function (localeId) {
	if (typeof localeId !== 'string') {
		throw new TypeError('Expected a string');
	}

	return all[localeId];
};

exports.all = all;

},{"./lcid.json":36,"invert-kv":33}],36:[function(require,module,exports){
module.exports={
	"af_ZA": 1078,
	"am_ET": 1118,
	"ar_AE": 14337,
	"ar_BH": 15361,
	"ar_DZ": 5121,
	"ar_EG": 3073,
	"ar_IQ": 2049,
	"ar_JO": 11265,
	"ar_KW": 13313,
	"ar_LB": 12289,
	"ar_LY": 4097,
	"ar_MA": 6145,
	"ar_OM": 8193,
	"ar_QA": 16385,
	"ar_SA": 1025,
	"ar_SY": 10241,
	"ar_TN": 7169,
	"ar_YE": 9217,
	"arn_CL": 1146,
	"as_IN": 1101,
	"az_AZ": 2092,
	"ba_RU": 1133,
	"be_BY": 1059,
	"bg_BG": 1026,
	"bn_IN": 1093,
	"bo_BT": 2129,
	"bo_CN": 1105,
	"br_FR": 1150,
	"bs_BA": 8218,
	"ca_ES": 1027,
	"co_FR": 1155,
	"cs_CZ": 1029,
	"cy_GB": 1106,
	"da_DK": 1030,
	"de_AT": 3079,
	"de_CH": 2055,
	"de_DE": 1031,
	"de_LI": 5127,
	"de_LU": 4103,
	"div_MV": 1125,
	"dsb_DE": 2094,
	"el_GR": 1032,
	"en_AU": 3081,
	"en_BZ": 10249,
	"en_CA": 4105,
	"en_CB": 9225,
	"en_GB": 2057,
	"en_IE": 6153,
	"en_IN": 18441,
	"en_JA": 8201,
	"en_MY": 17417,
	"en_NZ": 5129,
	"en_PH": 13321,
	"en_TT": 11273,
	"en_US": 1033,
	"en_ZA": 7177,
	"en_ZW": 12297,
	"es_AR": 11274,
	"es_BO": 16394,
	"es_CL": 13322,
	"es_CO": 9226,
	"es_CR": 5130,
	"es_DO": 7178,
	"es_EC": 12298,
	"es_ES": 3082,
	"es_GT": 4106,
	"es_HN": 18442,
	"es_MX": 2058,
	"es_NI": 19466,
	"es_PA": 6154,
	"es_PE": 10250,
	"es_PR": 20490,
	"es_PY": 15370,
	"es_SV": 17418,
	"es_UR": 14346,
	"es_US": 21514,
	"es_VE": 8202,
	"et_EE": 1061,
	"eu_ES": 1069,
	"fa_IR": 1065,
	"fi_FI": 1035,
	"fil_PH": 1124,
	"fo_FO": 1080,
	"fr_BE": 2060,
	"fr_CA": 3084,
	"fr_CH": 4108,
	"fr_FR": 1036,
	"fr_LU": 5132,
	"fr_MC": 6156,
	"fy_NL": 1122,
	"ga_IE": 2108,
	"gbz_AF": 1164,
	"gl_ES": 1110,
	"gsw_FR": 1156,
	"gu_IN": 1095,
	"ha_NG": 1128,
	"he_IL": 1037,
	"hi_IN": 1081,
	"hr_BA": 4122,
	"hr_HR": 1050,
	"hu_HU": 1038,
	"hy_AM": 1067,
	"id_ID": 1057,
	"ii_CN": 1144,
	"is_IS": 1039,
	"it_CH": 2064,
	"it_IT": 1040,
	"iu_CA": 2141,
	"ja_JP": 1041,
	"ka_GE": 1079,
	"kh_KH": 1107,
	"kk_KZ": 1087,
	"kl_GL": 1135,
	"kn_IN": 1099,
	"ko_KR": 1042,
	"kok_IN": 1111,
	"ky_KG": 1088,
	"lb_LU": 1134,
	"lo_LA": 1108,
	"lt_LT": 1063,
	"lv_LV": 1062,
	"mi_NZ": 1153,
	"mk_MK": 1071,
	"ml_IN": 1100,
	"mn_CN": 2128,
	"mn_MN": 1104,
	"moh_CA": 1148,
	"mr_IN": 1102,
	"ms_BN": 2110,
	"ms_MY": 1086,
	"mt_MT": 1082,
	"my_MM": 1109,
	"nb_NO": 1044,
	"ne_NP": 1121,
	"nl_BE": 2067,
	"nl_NL": 1043,
	"nn_NO": 2068,
	"ns_ZA": 1132,
	"oc_FR": 1154,
	"or_IN": 1096,
	"pa_IN": 1094,
	"pl_PL": 1045,
	"ps_AF": 1123,
	"pt_BR": 1046,
	"pt_PT": 2070,
	"qut_GT": 1158,
	"quz_BO": 1131,
	"quz_EC": 2155,
	"quz_PE": 3179,
	"rm_CH": 1047,
	"ro_RO": 1048,
	"ru_RU": 1049,
	"rw_RW": 1159,
	"sa_IN": 1103,
	"sah_RU": 1157,
	"se_FI": 3131,
	"se_NO": 1083,
	"se_SE": 2107,
	"si_LK": 1115,
	"sk_SK": 1051,
	"sl_SI": 1060,
	"sma_NO": 6203,
	"sma_SE": 7227,
	"smj_NO": 4155,
	"smj_SE": 5179,
	"smn_FI": 9275,
	"sms_FI": 8251,
	"sq_AL": 1052,
	"sr_BA": 7194,
	"sr_SP": 3098,
	"sv_FI": 2077,
	"sv_SE": 1053,
	"sw_KE": 1089,
	"syr_SY": 1114,
	"ta_IN": 1097,
	"te_IN": 1098,
	"tg_TJ": 1064,
	"th_TH": 1054,
	"tk_TM": 1090,
	"tmz_DZ": 2143,
	"tn_ZA": 1074,
	"tr_TR": 1055,
	"tt_RU": 1092,
	"ug_CN": 1152,
	"uk_UA": 1058,
	"ur_IN": 2080,
	"ur_PK": 1056,
	"uz_UZ": 2115,
	"vi_VN": 1066,
	"wen_DE": 1070,
	"wo_SN": 1160,
	"xh_ZA": 1076,
	"yo_NG": 1130,
	"zh_CHS": 4,
	"zh_CHT": 31748,
	"zh_CN": 2052,
	"zh_HK": 3076,
	"zh_MO": 5124,
	"zh_SG": 4100,
	"zh_TW": 1028,
	"zu_ZA": 1077
}

},{}],37:[function(require,module,exports){
module.exports = minimatch
minimatch.Minimatch = Minimatch

var path = { sep: '/' }
try {
  path = require('path')
} catch (er) {}

var GLOBSTAR = minimatch.GLOBSTAR = Minimatch.GLOBSTAR = {}
var expand = require('brace-expansion')

// any single thing other than /
// don't need to escape / when using new RegExp()
var qmark = '[^/]'

// * => any number of characters
var star = qmark + '*?'

// ** when dots are allowed.  Anything goes, except .. and .
// not (^ or / followed by one or two dots followed by $ or /),
// followed by anything, any number of times.
var twoStarDot = '(?:(?!(?:\\\/|^)(?:\\.{1,2})($|\\\/)).)*?'

// not a ^ or / followed by a dot,
// followed by anything, any number of times.
var twoStarNoDot = '(?:(?!(?:\\\/|^)\\.).)*?'

// characters that need to be escaped in RegExp.
var reSpecials = charSet('().*{}+?[]^$\\!')

// "abc" -> { a:true, b:true, c:true }
function charSet (s) {
  return s.split('').reduce(function (set, c) {
    set[c] = true
    return set
  }, {})
}

// normalizes slashes.
var slashSplit = /\/+/

minimatch.filter = filter
function filter (pattern, options) {
  options = options || {}
  return function (p, i, list) {
    return minimatch(p, pattern, options)
  }
}

function ext (a, b) {
  a = a || {}
  b = b || {}
  var t = {}
  Object.keys(b).forEach(function (k) {
    t[k] = b[k]
  })
  Object.keys(a).forEach(function (k) {
    t[k] = a[k]
  })
  return t
}

minimatch.defaults = function (def) {
  if (!def || !Object.keys(def).length) return minimatch

  var orig = minimatch

  var m = function minimatch (p, pattern, options) {
    return orig.minimatch(p, pattern, ext(def, options))
  }

  m.Minimatch = function Minimatch (pattern, options) {
    return new orig.Minimatch(pattern, ext(def, options))
  }

  return m
}

Minimatch.defaults = function (def) {
  if (!def || !Object.keys(def).length) return Minimatch
  return minimatch.defaults(def).Minimatch
}

function minimatch (p, pattern, options) {
  if (typeof pattern !== 'string') {
    throw new TypeError('glob pattern string required')
  }

  if (!options) options = {}

  // shortcut: comments match nothing.
  if (!options.nocomment && pattern.charAt(0) === '#') {
    return false
  }

  // "" only matches ""
  if (pattern.trim() === '') return p === ''

  return new Minimatch(pattern, options).match(p)
}

function Minimatch (pattern, options) {
  if (!(this instanceof Minimatch)) {
    return new Minimatch(pattern, options)
  }

  if (typeof pattern !== 'string') {
    throw new TypeError('glob pattern string required')
  }

  if (!options) options = {}
  pattern = pattern.trim()

  // windows support: need to use /, not \
  if (path.sep !== '/') {
    pattern = pattern.split(path.sep).join('/')
  }

  this.options = options
  this.set = []
  this.pattern = pattern
  this.regexp = null
  this.negate = false
  this.comment = false
  this.empty = false

  // make the set of regexps etc.
  this.make()
}

Minimatch.prototype.debug = function () {}

Minimatch.prototype.make = make
function make () {
  // don't do it more than once.
  if (this._made) return

  var pattern = this.pattern
  var options = this.options

  // empty patterns and comments match nothing.
  if (!options.nocomment && pattern.charAt(0) === '#') {
    this.comment = true
    return
  }
  if (!pattern) {
    this.empty = true
    return
  }

  // step 1: figure out negation, etc.
  this.parseNegate()

  // step 2: expand braces
  var set = this.globSet = this.braceExpand()

  if (options.debug) this.debug = console.error

  this.debug(this.pattern, set)

  // step 3: now we have a set, so turn each one into a series of path-portion
  // matching patterns.
  // These will be regexps, except in the case of "**", which is
  // set to the GLOBSTAR object for globstar behavior,
  // and will not contain any / characters
  set = this.globParts = set.map(function (s) {
    return s.split(slashSplit)
  })

  this.debug(this.pattern, set)

  // glob --> regexps
  set = set.map(function (s, si, set) {
    return s.map(this.parse, this)
  }, this)

  this.debug(this.pattern, set)

  // filter out everything that didn't compile properly.
  set = set.filter(function (s) {
    return s.indexOf(false) === -1
  })

  this.debug(this.pattern, set)

  this.set = set
}

Minimatch.prototype.parseNegate = parseNegate
function parseNegate () {
  var pattern = this.pattern
  var negate = false
  var options = this.options
  var negateOffset = 0

  if (options.nonegate) return

  for (var i = 0, l = pattern.length
    ; i < l && pattern.charAt(i) === '!'
    ; i++) {
    negate = !negate
    negateOffset++
  }

  if (negateOffset) this.pattern = pattern.substr(negateOffset)
  this.negate = negate
}

// Brace expansion:
// a{b,c}d -> abd acd
// a{b,}c -> abc ac
// a{0..3}d -> a0d a1d a2d a3d
// a{b,c{d,e}f}g -> abg acdfg acefg
// a{b,c}d{e,f}g -> abdeg acdeg abdeg abdfg
//
// Invalid sets are not expanded.
// a{2..}b -> a{2..}b
// a{b}c -> a{b}c
minimatch.braceExpand = function (pattern, options) {
  return braceExpand(pattern, options)
}

Minimatch.prototype.braceExpand = braceExpand

function braceExpand (pattern, options) {
  if (!options) {
    if (this instanceof Minimatch) {
      options = this.options
    } else {
      options = {}
    }
  }

  pattern = typeof pattern === 'undefined'
    ? this.pattern : pattern

  if (typeof pattern === 'undefined') {
    throw new Error('undefined pattern')
  }

  if (options.nobrace ||
    !pattern.match(/\{.*\}/)) {
    // shortcut. no need to expand.
    return [pattern]
  }

  return expand(pattern)
}

// parse a component of the expanded set.
// At this point, no pattern may contain "/" in it
// so we're going to return a 2d array, where each entry is the full
// pattern, split on '/', and then turned into a regular expression.
// A regexp is made at the end which joins each array with an
// escaped /, and another full one which joins each regexp with |.
//
// Following the lead of Bash 4.1, note that "**" only has special meaning
// when it is the *only* thing in a path portion.  Otherwise, any series
// of * is equivalent to a single *.  Globstar behavior is enabled by
// default, and can be disabled by setting options.noglobstar.
Minimatch.prototype.parse = parse
var SUBPARSE = {}
function parse (pattern, isSub) {
  var options = this.options

  // shortcuts
  if (!options.noglobstar && pattern === '**') return GLOBSTAR
  if (pattern === '') return ''

  var re = ''
  var hasMagic = !!options.nocase
  var escaping = false
  // ? => one single character
  var patternListStack = []
  var negativeLists = []
  var plType
  var stateChar
  var inClass = false
  var reClassStart = -1
  var classStart = -1
  // . and .. never match anything that doesn't start with .,
  // even when options.dot is set.
  var patternStart = pattern.charAt(0) === '.' ? '' // anything
  // not (start or / followed by . or .. followed by / or end)
  : options.dot ? '(?!(?:^|\\\/)\\.{1,2}(?:$|\\\/))'
  : '(?!\\.)'
  var self = this

  function clearStateChar () {
    if (stateChar) {
      // we had some state-tracking character
      // that wasn't consumed by this pass.
      switch (stateChar) {
        case '*':
          re += star
          hasMagic = true
        break
        case '?':
          re += qmark
          hasMagic = true
        break
        default:
          re += '\\' + stateChar
        break
      }
      self.debug('clearStateChar %j %j', stateChar, re)
      stateChar = false
    }
  }

  for (var i = 0, len = pattern.length, c
    ; (i < len) && (c = pattern.charAt(i))
    ; i++) {
    this.debug('%s\t%s %s %j', pattern, i, re, c)

    // skip over any that are escaped.
    if (escaping && reSpecials[c]) {
      re += '\\' + c
      escaping = false
      continue
    }

    switch (c) {
      case '/':
        // completely not allowed, even escaped.
        // Should already be path-split by now.
        return false

      case '\\':
        clearStateChar()
        escaping = true
      continue

      // the various stateChar values
      // for the "extglob" stuff.
      case '?':
      case '*':
      case '+':
      case '@':
      case '!':
        this.debug('%s\t%s %s %j <-- stateChar', pattern, i, re, c)

        // all of those are literals inside a class, except that
        // the glob [!a] means [^a] in regexp
        if (inClass) {
          this.debug('  in class')
          if (c === '!' && i === classStart + 1) c = '^'
          re += c
          continue
        }

        // if we already have a stateChar, then it means
        // that there was something like ** or +? in there.
        // Handle the stateChar, then proceed with this one.
        self.debug('call clearStateChar %j', stateChar)
        clearStateChar()
        stateChar = c
        // if extglob is disabled, then +(asdf|foo) isn't a thing.
        // just clear the statechar *now*, rather than even diving into
        // the patternList stuff.
        if (options.noext) clearStateChar()
      continue

      case '(':
        if (inClass) {
          re += '('
          continue
        }

        if (!stateChar) {
          re += '\\('
          continue
        }

        plType = stateChar
        patternListStack.push({
          type: plType,
          start: i - 1,
          reStart: re.length
        })
        // negation is (?:(?!js)[^/]*)
        re += stateChar === '!' ? '(?:(?!(?:' : '(?:'
        this.debug('plType %j %j', stateChar, re)
        stateChar = false
      continue

      case ')':
        if (inClass || !patternListStack.length) {
          re += '\\)'
          continue
        }

        clearStateChar()
        hasMagic = true
        re += ')'
        var pl = patternListStack.pop()
        plType = pl.type
        // negation is (?:(?!js)[^/]*)
        // The others are (?:<pattern>)<type>
        switch (plType) {
          case '!':
            negativeLists.push(pl)
            re += ')[^/]*?)'
            pl.reEnd = re.length
            break
          case '?':
          case '+':
          case '*':
            re += plType
            break
          case '@': break // the default anyway
        }
      continue

      case '|':
        if (inClass || !patternListStack.length || escaping) {
          re += '\\|'
          escaping = false
          continue
        }

        clearStateChar()
        re += '|'
      continue

      // these are mostly the same in regexp and glob
      case '[':
        // swallow any state-tracking char before the [
        clearStateChar()

        if (inClass) {
          re += '\\' + c
          continue
        }

        inClass = true
        classStart = i
        reClassStart = re.length
        re += c
      continue

      case ']':
        //  a right bracket shall lose its special
        //  meaning and represent itself in
        //  a bracket expression if it occurs
        //  first in the list.  -- POSIX.2 2.8.3.2
        if (i === classStart + 1 || !inClass) {
          re += '\\' + c
          escaping = false
          continue
        }

        // handle the case where we left a class open.
        // "[z-a]" is valid, equivalent to "\[z-a\]"
        if (inClass) {
          // split where the last [ was, make sure we don't have
          // an invalid re. if so, re-walk the contents of the
          // would-be class to re-translate any characters that
          // were passed through as-is
          // TODO: It would probably be faster to determine this
          // without a try/catch and a new RegExp, but it's tricky
          // to do safely.  For now, this is safe and works.
          var cs = pattern.substring(classStart + 1, i)
          try {
            RegExp('[' + cs + ']')
          } catch (er) {
            // not a valid class!
            var sp = this.parse(cs, SUBPARSE)
            re = re.substr(0, reClassStart) + '\\[' + sp[0] + '\\]'
            hasMagic = hasMagic || sp[1]
            inClass = false
            continue
          }
        }

        // finish up the class.
        hasMagic = true
        inClass = false
        re += c
      continue

      default:
        // swallow any state char that wasn't consumed
        clearStateChar()

        if (escaping) {
          // no need
          escaping = false
        } else if (reSpecials[c]
          && !(c === '^' && inClass)) {
          re += '\\'
        }

        re += c

    } // switch
  } // for

  // handle the case where we left a class open.
  // "[abc" is valid, equivalent to "\[abc"
  if (inClass) {
    // split where the last [ was, and escape it
    // this is a huge pita.  We now have to re-walk
    // the contents of the would-be class to re-translate
    // any characters that were passed through as-is
    cs = pattern.substr(classStart + 1)
    sp = this.parse(cs, SUBPARSE)
    re = re.substr(0, reClassStart) + '\\[' + sp[0]
    hasMagic = hasMagic || sp[1]
  }

  // handle the case where we had a +( thing at the *end*
  // of the pattern.
  // each pattern list stack adds 3 chars, and we need to go through
  // and escape any | chars that were passed through as-is for the regexp.
  // Go through and escape them, taking care not to double-escape any
  // | chars that were already escaped.
  for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
    var tail = re.slice(pl.reStart + 3)
    // maybe some even number of \, then maybe 1 \, followed by a |
    tail = tail.replace(/((?:\\{2})*)(\\?)\|/g, function (_, $1, $2) {
      if (!$2) {
        // the | isn't already escaped, so escape it.
        $2 = '\\'
      }

      // need to escape all those slashes *again*, without escaping the
      // one that we need for escaping the | character.  As it works out,
      // escaping an even number of slashes can be done by simply repeating
      // it exactly after itself.  That's why this trick works.
      //
      // I am sorry that you have to see this.
      return $1 + $1 + $2 + '|'
    })

    this.debug('tail=%j\n   %s', tail, tail)
    var t = pl.type === '*' ? star
      : pl.type === '?' ? qmark
      : '\\' + pl.type

    hasMagic = true
    re = re.slice(0, pl.reStart) + t + '\\(' + tail
  }

  // handle trailing things that only matter at the very end.
  clearStateChar()
  if (escaping) {
    // trailing \\
    re += '\\\\'
  }

  // only need to apply the nodot start if the re starts with
  // something that could conceivably capture a dot
  var addPatternStart = false
  switch (re.charAt(0)) {
    case '.':
    case '[':
    case '(': addPatternStart = true
  }

  // Hack to work around lack of negative lookbehind in JS
  // A pattern like: *.!(x).!(y|z) needs to ensure that a name
  // like 'a.xyz.yz' doesn't match.  So, the first negative
  // lookahead, has to look ALL the way ahead, to the end of
  // the pattern.
  for (var n = negativeLists.length - 1; n > -1; n--) {
    var nl = negativeLists[n]

    var nlBefore = re.slice(0, nl.reStart)
    var nlFirst = re.slice(nl.reStart, nl.reEnd - 8)
    var nlLast = re.slice(nl.reEnd - 8, nl.reEnd)
    var nlAfter = re.slice(nl.reEnd)

    nlLast += nlAfter

    // Handle nested stuff like *(*.js|!(*.json)), where open parens
    // mean that we should *not* include the ) in the bit that is considered
    // "after" the negated section.
    var openParensBefore = nlBefore.split('(').length - 1
    var cleanAfter = nlAfter
    for (i = 0; i < openParensBefore; i++) {
      cleanAfter = cleanAfter.replace(/\)[+*?]?/, '')
    }
    nlAfter = cleanAfter

    var dollar = ''
    if (nlAfter === '' && isSub !== SUBPARSE) {
      dollar = '$'
    }
    var newRe = nlBefore + nlFirst + nlAfter + dollar + nlLast
    re = newRe
  }

  // if the re is not "" at this point, then we need to make sure
  // it doesn't match against an empty path part.
  // Otherwise a/* will match a/, which it should not.
  if (re !== '' && hasMagic) {
    re = '(?=.)' + re
  }

  if (addPatternStart) {
    re = patternStart + re
  }

  // parsing just a piece of a larger pattern.
  if (isSub === SUBPARSE) {
    return [re, hasMagic]
  }

  // skip the regexp for non-magical patterns
  // unescape anything in it, though, so that it'll be
  // an exact match against a file etc.
  if (!hasMagic) {
    return globUnescape(pattern)
  }

  var flags = options.nocase ? 'i' : ''
  var regExp = new RegExp('^' + re + '$', flags)

  regExp._glob = pattern
  regExp._src = re

  return regExp
}

minimatch.makeRe = function (pattern, options) {
  return new Minimatch(pattern, options || {}).makeRe()
}

Minimatch.prototype.makeRe = makeRe
function makeRe () {
  if (this.regexp || this.regexp === false) return this.regexp

  // at this point, this.set is a 2d array of partial
  // pattern strings, or "**".
  //
  // It's better to use .match().  This function shouldn't
  // be used, really, but it's pretty convenient sometimes,
  // when you just want to work with a regex.
  var set = this.set

  if (!set.length) {
    this.regexp = false
    return this.regexp
  }
  var options = this.options

  var twoStar = options.noglobstar ? star
    : options.dot ? twoStarDot
    : twoStarNoDot
  var flags = options.nocase ? 'i' : ''

  var re = set.map(function (pattern) {
    return pattern.map(function (p) {
      return (p === GLOBSTAR) ? twoStar
      : (typeof p === 'string') ? regExpEscape(p)
      : p._src
    }).join('\\\/')
  }).join('|')

  // must match entire pattern
  // ending in a * or ** will make it less strict.
  re = '^(?:' + re + ')$'

  // can match anything, as long as it's not this.
  if (this.negate) re = '^(?!' + re + ').*$'

  try {
    this.regexp = new RegExp(re, flags)
  } catch (ex) {
    this.regexp = false
  }
  return this.regexp
}

minimatch.match = function (list, pattern, options) {
  options = options || {}
  var mm = new Minimatch(pattern, options)
  list = list.filter(function (f) {
    return mm.match(f)
  })
  if (mm.options.nonull && !list.length) {
    list.push(pattern)
  }
  return list
}

Minimatch.prototype.match = match
function match (f, partial) {
  this.debug('match', f, this.pattern)
  // short-circuit in the case of busted things.
  // comments, etc.
  if (this.comment) return false
  if (this.empty) return f === ''

  if (f === '/' && partial) return true

  var options = this.options

  // windows: need to use /, not \
  if (path.sep !== '/') {
    f = f.split(path.sep).join('/')
  }

  // treat the test path as a set of pathparts.
  f = f.split(slashSplit)
  this.debug(this.pattern, 'split', f)

  // just ONE of the pattern sets in this.set needs to match
  // in order for it to be valid.  If negating, then just one
  // match means that we have failed.
  // Either way, return on the first hit.

  var set = this.set
  this.debug(this.pattern, 'set', set)

  // Find the basename of the path by looking for the last non-empty segment
  var filename
  var i
  for (i = f.length - 1; i >= 0; i--) {
    filename = f[i]
    if (filename) break
  }

  for (i = 0; i < set.length; i++) {
    var pattern = set[i]
    var file = f
    if (options.matchBase && pattern.length === 1) {
      file = [filename]
    }
    var hit = this.matchOne(file, pattern, partial)
    if (hit) {
      if (options.flipNegate) return true
      return !this.negate
    }
  }

  // didn't get any hits.  this is success if it's a negative
  // pattern, failure otherwise.
  if (options.flipNegate) return false
  return this.negate
}

// set partial to true to test if, for example,
// "/a/b" matches the start of "/*/b/*/d"
// Partial means, if you run out of file before you run
// out of pattern, then that's fine, as long as all
// the parts match.
Minimatch.prototype.matchOne = function (file, pattern, partial) {
  var options = this.options

  this.debug('matchOne',
    { 'this': this, file: file, pattern: pattern })

  this.debug('matchOne', file.length, pattern.length)

  for (var fi = 0,
      pi = 0,
      fl = file.length,
      pl = pattern.length
      ; (fi < fl) && (pi < pl)
      ; fi++, pi++) {
    this.debug('matchOne loop')
    var p = pattern[pi]
    var f = file[fi]

    this.debug(pattern, p, f)

    // should be impossible.
    // some invalid regexp stuff in the set.
    if (p === false) return false

    if (p === GLOBSTAR) {
      this.debug('GLOBSTAR', [pattern, p, f])

      // "**"
      // a/**/b/**/c would match the following:
      // a/b/x/y/z/c
      // a/x/y/z/b/c
      // a/b/x/b/x/c
      // a/b/c
      // To do this, take the rest of the pattern after
      // the **, and see if it would match the file remainder.
      // If so, return success.
      // If not, the ** "swallows" a segment, and try again.
      // This is recursively awful.
      //
      // a/**/b/**/c matching a/b/x/y/z/c
      // - a matches a
      // - doublestar
      //   - matchOne(b/x/y/z/c, b/**/c)
      //     - b matches b
      //     - doublestar
      //       - matchOne(x/y/z/c, c) -> no
      //       - matchOne(y/z/c, c) -> no
      //       - matchOne(z/c, c) -> no
      //       - matchOne(c, c) yes, hit
      var fr = fi
      var pr = pi + 1
      if (pr === pl) {
        this.debug('** at the end')
        // a ** at the end will just swallow the rest.
        // We have found a match.
        // however, it will not swallow /.x, unless
        // options.dot is set.
        // . and .. are *never* matched by **, for explosively
        // exponential reasons.
        for (; fi < fl; fi++) {
          if (file[fi] === '.' || file[fi] === '..' ||
            (!options.dot && file[fi].charAt(0) === '.')) return false
        }
        return true
      }

      // ok, let's see if we can swallow whatever we can.
      while (fr < fl) {
        var swallowee = file[fr]

        this.debug('\nglobstar while', file, fr, pattern, pr, swallowee)

        // XXX remove this slice.  Just pass the start index.
        if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
          this.debug('globstar found match!', fr, fl, swallowee)
          // found a match.
          return true
        } else {
          // can't swallow "." or ".." ever.
          // can only swallow ".foo" when explicitly asked.
          if (swallowee === '.' || swallowee === '..' ||
            (!options.dot && swallowee.charAt(0) === '.')) {
            this.debug('dot detected!', file, fr, pattern, pr)
            break
          }

          // ** swallows a segment, and continue.
          this.debug('globstar swallow a segment, and continue')
          fr++
        }
      }

      // no match was found.
      // However, in partial mode, we can't say this is necessarily over.
      // If there's more *pattern* left, then
      if (partial) {
        // ran out of file
        this.debug('\n>>> no match, partial?', file, fr, pattern, pr)
        if (fr === fl) return true
      }
      return false
    }

    // something other than **
    // non-magic patterns just have to match exactly
    // patterns with magic have been turned into regexps.
    var hit
    if (typeof p === 'string') {
      if (options.nocase) {
        hit = f.toLowerCase() === p.toLowerCase()
      } else {
        hit = f === p
      }
      this.debug('string match', p, f, hit)
    } else {
      hit = f.match(p)
      this.debug('pattern match', p, f, hit)
    }

    if (!hit) return false
  }

  // Note: ending in / means that we'll get a final ""
  // at the end of the pattern.  This can only match a
  // corresponding "" at the end of the file.
  // If the file ends in /, then it can only match a
  // a pattern that ends in /, unless the pattern just
  // doesn't have any more for it. But, a/b/ should *not*
  // match "a/b/*", even though "" matches against the
  // [^/]*? pattern, except in partial mode, where it might
  // simply not be reached yet.
  // However, a/b/ should still satisfy a/*

  // now either we fell off the end of the pattern, or we're done.
  if (fi === fl && pi === pl) {
    // ran out of pattern and filename at the same time.
    // an exact hit!
    return true
  } else if (fi === fl) {
    // ran out of file, but still had pattern left.
    // this is ok if we're doing the match as part of
    // a glob fs traversal.
    return partial
  } else if (pi === pl) {
    // ran out of pattern, still have file left.
    // this is only acceptable if we're on the very last
    // empty segment of a file with a trailing slash.
    // a/* should match a/b/
    var emptyFileEnd = (fi === fl - 1) && (file[fi] === '')
    return emptyFileEnd
  }

  // should be unreachable.
  throw new Error('wtf?')
}

// replace stuff like \* with *
function globUnescape (s) {
  return s.replace(/\\(.)/g, '$1')
}

function regExpEscape (s) {
  return s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&')
}

},{"brace-expansion":25,"path":undefined}],38:[function(require,module,exports){
// mkdir-parents.js

'use strict';

var fs = require('fs');
var path = require('path');


//######################################################################
/**
 * Function: make directory with parents recursively (async)
 * Param   : dir: path to make directory
 *           [mode]: {optional} file mode to make directory
 *           [cb]: {optional} callback(err) function
 */
function mkdirParents(dir, mode, cb) {
  // check arguments
  if (typeof dir !== 'string')
    throw new Error('mkdirParents: directory path required');

  if (typeof mode === 'function') {
    cb = mode;
    mode = undefined;
  }

  if (mode !== undefined && typeof mode !== 'number')
    throw new Error('mkdirParents: mode must be a number');

  if (cb !== undefined && typeof cb !== 'function')
    throw new Error('mkdirParents: callback must be function');

  dir = path.resolve(dir);

  var ctx = this, called, results;

  // local variables
  var dirList = []; // directories that we have to make directory

  fs.exists(dir, existsCallback);

  // fs.exists callback...
  function existsCallback(exists) {
    if (exists) {
      return mkdirCallback(null);
    }

    // if dir does not exist, then we have to make directory
    dirList.push(dir);
    dir = path.resolve(dir, '..');

    return fs.exists(dir, existsCallback);
  } // existsCallback

  // fs.mkdir callback...
  function mkdirCallback(err) {
    if (err && err.code !== 'EEXIST') {
      return mkdirParentsCallback(err);
    }

    dir = dirList.pop();
    if (!dir) {
      return mkdirParentsCallback(null);
    }

    return fs.mkdir(dir, mode, mkdirCallback);
  } // mkdirCallback

  // mkdirParentsCallback(err)
  function mkdirParentsCallback(err) {
    if (err && err.code === 'EEXIST') err = arguments[0] = null;
    if (!results) results = arguments;
    if (!cb || called) return;
    called = true;
    cb.apply(ctx, results);
  } // mkdirParentsCallback

  // return mkdirParentsYieldable
  return function mkdirParentsYieldable(fn) {
    if (!cb) cb = fn;
    if (!results || called) return;
    called = true;
    cb.apply(ctx, results);
  }; // mkdirParentsYieldable

} // mkdirParents


//######################################################################
/**
 * Function: make directory with parents recursively (sync)
 * Param   : dir: path to make directory
 *           mode: file mode to make directory
 */
function mkdirParentsSync(dir, mode) {
  // check arguments
  if (typeof dir !== 'string')
    throw new Error('mkdirParentsSync: directory path required');

  if (mode !== undefined && typeof mode !== 'number')
    throw new Error('mkdirParents: mode must be a number');

  dir = path.resolve(dir);

  var dirList = [];
  while (!fs.existsSync(dir)) {
    dirList.push(dir);
    dir = path.resolve(dir, '..');
  }

  while (dir = dirList.pop()) {
    try {
      fs.mkdirSync(dir, mode);
    } catch (err) {
      if (err && err.code !== 'EEXIST') throw err;
    }
  }

} // mkdirParentsSync


exports = module.exports = mkdirParents;
exports.mkdirParents     = mkdirParents;
exports.mkdirParentsSync = mkdirParentsSync;
exports.sync             = mkdirParentsSync;

},{"fs":undefined,"path":undefined}],39:[function(require,module,exports){
var wrappy = require('wrappy')
module.exports = wrappy(once)

once.proto = once(function () {
  Object.defineProperty(Function.prototype, 'once', {
    value: function () {
      return once(this)
    },
    configurable: true
  })
})

function once (fn) {
  var f = function () {
    if (f.called) return f.value
    f.called = true
    return f.value = fn.apply(this, arguments)
  }
  f.called = false
  return f
}

},{"wrappy":65}],40:[function(require,module,exports){
'use strict';
var os = require('os');

function homedir() {
	var env = process.env;
	var home = env.HOME;
	var user = env.LOGNAME || env.USER || env.LNAME || env.USERNAME;

	if (process.platform === 'win32') {
		return env.USERPROFILE || env.HOMEDRIVE + env.HOMEPATH || home || null;
	}

	if (process.platform === 'darwin') {
		return home || (user ? '/Users/' + user : null);
	}

	if (process.platform === 'linux') {
		return home || (process.getuid() === 0 ? '/root' : (user ? '/home/' + user : null));
	}

	return home || null;
}

module.exports = typeof os.homedir === 'function' ? os.homedir : homedir;

},{"os":undefined}],41:[function(require,module,exports){
'use strict';
var childProcess = require('child_process');
var execFileSync = childProcess.execFileSync;
var lcid = require('lcid');
var defaultOpts = {spawn: true};
var cache;

function fallback() {
	cache = 'en_US';
	return cache;
}

function getEnvLocale(env) {
	env = env || process.env;
	var ret = env.LC_ALL || env.LC_MESSAGES || env.LANG || env.LANGUAGE;
	cache = getLocale(ret);
	return ret;
}

function parseLocale(x) {
	var env = x.split('\n').reduce(function (env, def) {
		def = def.split('=');
		env[def[0]] = def[1];
		return env;
	}, {});
	return getEnvLocale(env);
}

function getLocale(str) {
	return (str && str.replace(/[.:].*/, '')) || fallback();
}

module.exports = function (opts, cb) {
	if (typeof opts === 'function') {
		cb = opts;
		opts = defaultOpts;
	} else {
		opts = opts || defaultOpts;
	}

	if (cache || getEnvLocale() || opts.spawn === false) {
		setImmediate(cb, null, cache);
		return;
	}

	var getAppleLocale = function () {
		childProcess.execFile('defaults', ['read', '-g', 'AppleLocale'], function (err, stdout) {
			if (err) {
				fallback();
				return;
			}

			cache = stdout.trim() || fallback();
			cb(null, cache);
		});
	};

	if (process.platform === 'win32') {
		childProcess.execFile('wmic', ['os', 'get', 'locale'], function (err, stdout) {
			if (err) {
				fallback();
				return;
			}

			var lcidCode = parseInt(stdout.replace('Locale', ''), 16);
			cache = lcid.from(lcidCode) || fallback();
			cb(null, cache);
		});
	} else {
		childProcess.execFile('locale', function (err, stdout) {
			if (err) {
				fallback();
				return;
			}

			var res = parseLocale(stdout);

			if (!res && process.platform === 'darwin') {
				getAppleLocale();
				return;
			}

			cache = getLocale(res);
			cb(null, cache);
		});
	}
};

module.exports.sync = function (opts) {
	opts = opts || defaultOpts;

	if (cache || getEnvLocale() || !execFileSync || opts.spawn === false) {
		return cache;
	}

	if (process.platform === 'win32') {
		var stdout;

		try {
			stdout = execFileSync('wmic', ['os', 'get', 'locale'], {encoding: 'utf8'});
		} catch (err) {
			return fallback();
		}

		var lcidCode = parseInt(stdout.replace('Locale', ''), 16);
		cache = lcid.from(lcidCode) || fallback();
		return cache;
	}

	var res;

	try {
		res = parseLocale(execFileSync('locale', {encoding: 'utf8'}));
	} catch (err) {}

	if (!res && process.platform === 'darwin') {
		try {
			cache = execFileSync('defaults', ['read', '-g', 'AppleLocale'], {encoding: 'utf8'}).trim() || fallback();
			return cache;
		} catch (err) {
			return fallback();
		}
	}

	cache = getLocale(res);
	return cache;
};

},{"child_process":undefined,"lcid":35}],42:[function(require,module,exports){
'use strict';
var isWindows = process.platform === 'win32';
var trailingSlashRe = isWindows ? /[^:]\\$/ : /.\/$/;

// https://github.com/nodejs/io.js/blob/3e7a14381497a3b73dda68d05b5130563cdab420/lib/os.js#L25-L43
module.exports = function () {
	var path;

	if (isWindows) {
		path = process.env.TEMP ||
			process.env.TMP ||
			(process.env.SystemRoot || process.env.windir) + '\\temp';
	} else {
		path = process.env.TMPDIR ||
			process.env.TMP ||
			process.env.TEMP ||
			'/tmp';
	}

	if (trailingSlashRe.test(path)) {
		path = path.slice(0, -1);
	}

	return path;
};

},{}],43:[function(require,module,exports){
'use strict';

function posix(path) {
	return path.charAt(0) === '/';
};

function win32(path) {
	// https://github.com/joyent/node/blob/b3fcc245fb25539909ef1d5eaa01dbf92e168633/lib/path.js#L56
	var splitDeviceRe = /^([a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/]+[^\\\/]+)?([\\\/])?([\s\S]*?)$/;
	var result = splitDeviceRe.exec(path);
	var device = result[1] || '';
	var isUnc = !!device && device.charAt(1) !== ':';

	// UNC paths are always absolute
	return !!result[2] || isUnc;
};

module.exports = process.platform === 'win32' ? win32 : posix;
module.exports.posix = posix;
module.exports.win32 = win32;

},{}],44:[function(require,module,exports){
// vim:ts=4:sts=4:sw=4:
/*!
 *
 * Copyright 2009-2012 Kris Kowal under the terms of the MIT
 * license found at http://github.com/kriskowal/q/raw/master/LICENSE
 *
 * With parts by Tyler Close
 * Copyright 2007-2009 Tyler Close under the terms of the MIT X license found
 * at http://www.opensource.org/licenses/mit-license.html
 * Forked at ref_send.js version: 2009-05-11
 *
 * With parts by Mark Miller
 * Copyright (C) 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

(function (definition) {
    "use strict";

    // This file will function properly as a <script> tag, or a module
    // using CommonJS and NodeJS or RequireJS module formats.  In
    // Common/Node/RequireJS, the module exports the Q API and when
    // executed as a simple <script>, it creates a Q global instead.

    // Montage Require
    if (typeof bootstrap === "function") {
        bootstrap("promise", definition);

    // CommonJS
    } else if (typeof exports === "object" && typeof module === "object") {
        module.exports = definition();

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
        define(definition);

    // SES (Secure EcmaScript)
    } else if (typeof ses !== "undefined") {
        if (!ses.ok()) {
            return;
        } else {
            ses.makeQ = definition;
        }

    // <script>
    } else if (typeof window !== "undefined" || typeof self !== "undefined") {
        // Prefer window over self for add-on scripts. Use self for
        // non-windowed contexts.
        var global = typeof window !== "undefined" ? window : self;

        // Get the `window` object, save the previous Q global
        // and initialize Q as a global.
        var previousQ = global.Q;
        global.Q = definition();

        // Add a noConflict function so Q can be removed from the
        // global namespace.
        global.Q.noConflict = function () {
            global.Q = previousQ;
            return this;
        };

    } else {
        throw new Error("This environment was not anticipated by Q. Please file a bug.");
    }

})(function () {
"use strict";

var hasStacks = false;
try {
    throw new Error();
} catch (e) {
    hasStacks = !!e.stack;
}

// All code after this point will be filtered from stack traces reported
// by Q.
var qStartingLine = captureLine();
var qFileName;

// shims

// used for fallback in "allResolved"
var noop = function () {};

// Use the fastest possible means to execute a task in a future turn
// of the event loop.
var nextTick =(function () {
    // linked list of tasks (single, with head node)
    var head = {task: void 0, next: null};
    var tail = head;
    var flushing = false;
    var requestTick = void 0;
    var isNodeJS = false;
    // queue for late tasks, used by unhandled rejection tracking
    var laterQueue = [];

    function flush() {
        /* jshint loopfunc: true */
        var task, domain;

        while (head.next) {
            head = head.next;
            task = head.task;
            head.task = void 0;
            domain = head.domain;

            if (domain) {
                head.domain = void 0;
                domain.enter();
            }
            runSingle(task, domain);

        }
        while (laterQueue.length) {
            task = laterQueue.pop();
            runSingle(task);
        }
        flushing = false;
    }
    // runs a single function in the async queue
    function runSingle(task, domain) {
        try {
            task();

        } catch (e) {
            if (isNodeJS) {
                // In node, uncaught exceptions are considered fatal errors.
                // Re-throw them synchronously to interrupt flushing!

                // Ensure continuation if the uncaught exception is suppressed
                // listening "uncaughtException" events (as domains does).
                // Continue in next event to avoid tick recursion.
                if (domain) {
                    domain.exit();
                }
                setTimeout(flush, 0);
                if (domain) {
                    domain.enter();
                }

                throw e;

            } else {
                // In browsers, uncaught exceptions are not fatal.
                // Re-throw them asynchronously to avoid slow-downs.
                setTimeout(function () {
                    throw e;
                }, 0);
            }
        }

        if (domain) {
            domain.exit();
        }
    }

    nextTick = function (task) {
        tail = tail.next = {
            task: task,
            domain: isNodeJS && process.domain,
            next: null
        };

        if (!flushing) {
            flushing = true;
            requestTick();
        }
    };

    if (typeof process === "object" &&
        process.toString() === "[object process]" && process.nextTick) {
        // Ensure Q is in a real Node environment, with a `process.nextTick`.
        // To see through fake Node environments:
        // * Mocha test runner - exposes a `process` global without a `nextTick`
        // * Browserify - exposes a `process.nexTick` function that uses
        //   `setTimeout`. In this case `setImmediate` is preferred because
        //    it is faster. Browserify's `process.toString()` yields
        //   "[object Object]", while in a real Node environment
        //   `process.nextTick()` yields "[object process]".
        isNodeJS = true;

        requestTick = function () {
            process.nextTick(flush);
        };

    } else if (typeof setImmediate === "function") {
        // In IE10, Node.js 0.9+, or https://github.com/NobleJS/setImmediate
        if (typeof window !== "undefined") {
            requestTick = setImmediate.bind(window, flush);
        } else {
            requestTick = function () {
                setImmediate(flush);
            };
        }

    } else if (typeof MessageChannel !== "undefined") {
        // modern browsers
        // http://www.nonblocking.io/2011/06/windownexttick.html
        var channel = new MessageChannel();
        // At least Safari Version 6.0.5 (8536.30.1) intermittently cannot create
        // working message ports the first time a page loads.
        channel.port1.onmessage = function () {
            requestTick = requestPortTick;
            channel.port1.onmessage = flush;
            flush();
        };
        var requestPortTick = function () {
            // Opera requires us to provide a message payload, regardless of
            // whether we use it.
            channel.port2.postMessage(0);
        };
        requestTick = function () {
            setTimeout(flush, 0);
            requestPortTick();
        };

    } else {
        // old browsers
        requestTick = function () {
            setTimeout(flush, 0);
        };
    }
    // runs a task after all other tasks have been run
    // this is useful for unhandled rejection tracking that needs to happen
    // after all `then`d tasks have been run.
    nextTick.runAfter = function (task) {
        laterQueue.push(task);
        if (!flushing) {
            flushing = true;
            requestTick();
        }
    };
    return nextTick;
})();

// Attempt to make generics safe in the face of downstream
// modifications.
// There is no situation where this is necessary.
// If you need a security guarantee, these primordials need to be
// deeply frozen anyway, and if you don’t need a security guarantee,
// this is just plain paranoid.
// However, this **might** have the nice side-effect of reducing the size of
// the minified code by reducing x.call() to merely x()
// See Mark Miller’s explanation of what this does.
// http://wiki.ecmascript.org/doku.php?id=conventions:safe_meta_programming
var call = Function.call;
function uncurryThis(f) {
    return function () {
        return call.apply(f, arguments);
    };
}
// This is equivalent, but slower:
// uncurryThis = Function_bind.bind(Function_bind.call);
// http://jsperf.com/uncurrythis

var array_slice = uncurryThis(Array.prototype.slice);

var array_reduce = uncurryThis(
    Array.prototype.reduce || function (callback, basis) {
        var index = 0,
            length = this.length;
        // concerning the initial value, if one is not provided
        if (arguments.length === 1) {
            // seek to the first value in the array, accounting
            // for the possibility that is is a sparse array
            do {
                if (index in this) {
                    basis = this[index++];
                    break;
                }
                if (++index >= length) {
                    throw new TypeError();
                }
            } while (1);
        }
        // reduce
        for (; index < length; index++) {
            // account for the possibility that the array is sparse
            if (index in this) {
                basis = callback(basis, this[index], index);
            }
        }
        return basis;
    }
);

var array_indexOf = uncurryThis(
    Array.prototype.indexOf || function (value) {
        // not a very good shim, but good enough for our one use of it
        for (var i = 0; i < this.length; i++) {
            if (this[i] === value) {
                return i;
            }
        }
        return -1;
    }
);

var array_map = uncurryThis(
    Array.prototype.map || function (callback, thisp) {
        var self = this;
        var collect = [];
        array_reduce(self, function (undefined, value, index) {
            collect.push(callback.call(thisp, value, index, self));
        }, void 0);
        return collect;
    }
);

var object_create = Object.create || function (prototype) {
    function Type() { }
    Type.prototype = prototype;
    return new Type();
};

var object_hasOwnProperty = uncurryThis(Object.prototype.hasOwnProperty);

var object_keys = Object.keys || function (object) {
    var keys = [];
    for (var key in object) {
        if (object_hasOwnProperty(object, key)) {
            keys.push(key);
        }
    }
    return keys;
};

var object_toString = uncurryThis(Object.prototype.toString);

function isObject(value) {
    return value === Object(value);
}

// generator related shims

// FIXME: Remove this function once ES6 generators are in SpiderMonkey.
function isStopIteration(exception) {
    return (
        object_toString(exception) === "[object StopIteration]" ||
        exception instanceof QReturnValue
    );
}

// FIXME: Remove this helper and Q.return once ES6 generators are in
// SpiderMonkey.
var QReturnValue;
if (typeof ReturnValue !== "undefined") {
    QReturnValue = ReturnValue;
} else {
    QReturnValue = function (value) {
        this.value = value;
    };
}

// long stack traces

var STACK_JUMP_SEPARATOR = "From previous event:";

function makeStackTraceLong(error, promise) {
    // If possible, transform the error stack trace by removing Node and Q
    // cruft, then concatenating with the stack trace of `promise`. See #57.
    if (hasStacks &&
        promise.stack &&
        typeof error === "object" &&
        error !== null &&
        error.stack &&
        error.stack.indexOf(STACK_JUMP_SEPARATOR) === -1
    ) {
        var stacks = [];
        for (var p = promise; !!p; p = p.source) {
            if (p.stack) {
                stacks.unshift(p.stack);
            }
        }
        stacks.unshift(error.stack);

        var concatedStacks = stacks.join("\n" + STACK_JUMP_SEPARATOR + "\n");
        error.stack = filterStackString(concatedStacks);
    }
}

function filterStackString(stackString) {
    var lines = stackString.split("\n");
    var desiredLines = [];
    for (var i = 0; i < lines.length; ++i) {
        var line = lines[i];

        if (!isInternalFrame(line) && !isNodeFrame(line) && line) {
            desiredLines.push(line);
        }
    }
    return desiredLines.join("\n");
}

function isNodeFrame(stackLine) {
    return stackLine.indexOf("(module.js:") !== -1 ||
           stackLine.indexOf("(node.js:") !== -1;
}

function getFileNameAndLineNumber(stackLine) {
    // Named functions: "at functionName (filename:lineNumber:columnNumber)"
    // In IE10 function name can have spaces ("Anonymous function") O_o
    var attempt1 = /at .+ \((.+):(\d+):(?:\d+)\)$/.exec(stackLine);
    if (attempt1) {
        return [attempt1[1], Number(attempt1[2])];
    }

    // Anonymous functions: "at filename:lineNumber:columnNumber"
    var attempt2 = /at ([^ ]+):(\d+):(?:\d+)$/.exec(stackLine);
    if (attempt2) {
        return [attempt2[1], Number(attempt2[2])];
    }

    // Firefox style: "function@filename:lineNumber or @filename:lineNumber"
    var attempt3 = /.*@(.+):(\d+)$/.exec(stackLine);
    if (attempt3) {
        return [attempt3[1], Number(attempt3[2])];
    }
}

function isInternalFrame(stackLine) {
    var fileNameAndLineNumber = getFileNameAndLineNumber(stackLine);

    if (!fileNameAndLineNumber) {
        return false;
    }

    var fileName = fileNameAndLineNumber[0];
    var lineNumber = fileNameAndLineNumber[1];

    return fileName === qFileName &&
        lineNumber >= qStartingLine &&
        lineNumber <= qEndingLine;
}

// discover own file name and line number range for filtering stack
// traces
function captureLine() {
    if (!hasStacks) {
        return;
    }

    try {
        throw new Error();
    } catch (e) {
        var lines = e.stack.split("\n");
        var firstLine = lines[0].indexOf("@") > 0 ? lines[1] : lines[2];
        var fileNameAndLineNumber = getFileNameAndLineNumber(firstLine);
        if (!fileNameAndLineNumber) {
            return;
        }

        qFileName = fileNameAndLineNumber[0];
        return fileNameAndLineNumber[1];
    }
}

function deprecate(callback, name, alternative) {
    return function () {
        if (typeof console !== "undefined" &&
            typeof console.warn === "function") {
            console.warn(name + " is deprecated, use " + alternative +
                         " instead.", new Error("").stack);
        }
        return callback.apply(callback, arguments);
    };
}

// end of shims
// beginning of real work

/**
 * Constructs a promise for an immediate reference, passes promises through, or
 * coerces promises from different systems.
 * @param value immediate reference or promise
 */
function Q(value) {
    // If the object is already a Promise, return it directly.  This enables
    // the resolve function to both be used to created references from objects,
    // but to tolerably coerce non-promises to promises.
    if (value instanceof Promise) {
        return value;
    }

    // assimilate thenables
    if (isPromiseAlike(value)) {
        return coerce(value);
    } else {
        return fulfill(value);
    }
}
Q.resolve = Q;

/**
 * Performs a task in a future turn of the event loop.
 * @param {Function} task
 */
Q.nextTick = nextTick;

/**
 * Controls whether or not long stack traces will be on
 */
Q.longStackSupport = false;

// enable long stacks if Q_DEBUG is set
if (typeof process === "object" && process && process.env && process.env.Q_DEBUG) {
    Q.longStackSupport = true;
}

/**
 * Constructs a {promise, resolve, reject} object.
 *
 * `resolve` is a callback to invoke with a more resolved value for the
 * promise. To fulfill the promise, invoke `resolve` with any value that is
 * not a thenable. To reject the promise, invoke `resolve` with a rejected
 * thenable, or invoke `reject` with the reason directly. To resolve the
 * promise to another thenable, thus putting it in the same state, invoke
 * `resolve` with that other thenable.
 */
Q.defer = defer;
function defer() {
    // if "messages" is an "Array", that indicates that the promise has not yet
    // been resolved.  If it is "undefined", it has been resolved.  Each
    // element of the messages array is itself an array of complete arguments to
    // forward to the resolved promise.  We coerce the resolution value to a
    // promise using the `resolve` function because it handles both fully
    // non-thenable values and other thenables gracefully.
    var messages = [], progressListeners = [], resolvedPromise;

    var deferred = object_create(defer.prototype);
    var promise = object_create(Promise.prototype);

    promise.promiseDispatch = function (resolve, op, operands) {
        var args = array_slice(arguments);
        if (messages) {
            messages.push(args);
            if (op === "when" && operands[1]) { // progress operand
                progressListeners.push(operands[1]);
            }
        } else {
            Q.nextTick(function () {
                resolvedPromise.promiseDispatch.apply(resolvedPromise, args);
            });
        }
    };

    // XXX deprecated
    promise.valueOf = function () {
        if (messages) {
            return promise;
        }
        var nearerValue = nearer(resolvedPromise);
        if (isPromise(nearerValue)) {
            resolvedPromise = nearerValue; // shorten chain
        }
        return nearerValue;
    };

    promise.inspect = function () {
        if (!resolvedPromise) {
            return { state: "pending" };
        }
        return resolvedPromise.inspect();
    };

    if (Q.longStackSupport && hasStacks) {
        try {
            throw new Error();
        } catch (e) {
            // NOTE: don't try to use `Error.captureStackTrace` or transfer the
            // accessor around; that causes memory leaks as per GH-111. Just
            // reify the stack trace as a string ASAP.
            //
            // At the same time, cut off the first line; it's always just
            // "[object Promise]\n", as per the `toString`.
            promise.stack = e.stack.substring(e.stack.indexOf("\n") + 1);
        }
    }

    // NOTE: we do the checks for `resolvedPromise` in each method, instead of
    // consolidating them into `become`, since otherwise we'd create new
    // promises with the lines `become(whatever(value))`. See e.g. GH-252.

    function become(newPromise) {
        resolvedPromise = newPromise;
        promise.source = newPromise;

        array_reduce(messages, function (undefined, message) {
            Q.nextTick(function () {
                newPromise.promiseDispatch.apply(newPromise, message);
            });
        }, void 0);

        messages = void 0;
        progressListeners = void 0;
    }

    deferred.promise = promise;
    deferred.resolve = function (value) {
        if (resolvedPromise) {
            return;
        }

        become(Q(value));
    };

    deferred.fulfill = function (value) {
        if (resolvedPromise) {
            return;
        }

        become(fulfill(value));
    };
    deferred.reject = function (reason) {
        if (resolvedPromise) {
            return;
        }

        become(reject(reason));
    };
    deferred.notify = function (progress) {
        if (resolvedPromise) {
            return;
        }

        array_reduce(progressListeners, function (undefined, progressListener) {
            Q.nextTick(function () {
                progressListener(progress);
            });
        }, void 0);
    };

    return deferred;
}

/**
 * Creates a Node-style callback that will resolve or reject the deferred
 * promise.
 * @returns a nodeback
 */
defer.prototype.makeNodeResolver = function () {
    var self = this;
    return function (error, value) {
        if (error) {
            self.reject(error);
        } else if (arguments.length > 2) {
            self.resolve(array_slice(arguments, 1));
        } else {
            self.resolve(value);
        }
    };
};

/**
 * @param resolver {Function} a function that returns nothing and accepts
 * the resolve, reject, and notify functions for a deferred.
 * @returns a promise that may be resolved with the given resolve and reject
 * functions, or rejected by a thrown exception in resolver
 */
Q.Promise = promise; // ES6
Q.promise = promise;
function promise(resolver) {
    if (typeof resolver !== "function") {
        throw new TypeError("resolver must be a function.");
    }
    var deferred = defer();
    try {
        resolver(deferred.resolve, deferred.reject, deferred.notify);
    } catch (reason) {
        deferred.reject(reason);
    }
    return deferred.promise;
}

promise.race = race; // ES6
promise.all = all; // ES6
promise.reject = reject; // ES6
promise.resolve = Q; // ES6

// XXX experimental.  This method is a way to denote that a local value is
// serializable and should be immediately dispatched to a remote upon request,
// instead of passing a reference.
Q.passByCopy = function (object) {
    //freeze(object);
    //passByCopies.set(object, true);
    return object;
};

Promise.prototype.passByCopy = function () {
    //freeze(object);
    //passByCopies.set(object, true);
    return this;
};

/**
 * If two promises eventually fulfill to the same value, promises that value,
 * but otherwise rejects.
 * @param x {Any*}
 * @param y {Any*}
 * @returns {Any*} a promise for x and y if they are the same, but a rejection
 * otherwise.
 *
 */
Q.join = function (x, y) {
    return Q(x).join(y);
};

Promise.prototype.join = function (that) {
    return Q([this, that]).spread(function (x, y) {
        if (x === y) {
            // TODO: "===" should be Object.is or equiv
            return x;
        } else {
            throw new Error("Can't join: not the same: " + x + " " + y);
        }
    });
};

/**
 * Returns a promise for the first of an array of promises to become settled.
 * @param answers {Array[Any*]} promises to race
 * @returns {Any*} the first promise to be settled
 */
Q.race = race;
function race(answerPs) {
    return promise(function (resolve, reject) {
        // Switch to this once we can assume at least ES5
        // answerPs.forEach(function (answerP) {
        //     Q(answerP).then(resolve, reject);
        // });
        // Use this in the meantime
        for (var i = 0, len = answerPs.length; i < len; i++) {
            Q(answerPs[i]).then(resolve, reject);
        }
    });
}

Promise.prototype.race = function () {
    return this.then(Q.race);
};

/**
 * Constructs a Promise with a promise descriptor object and optional fallback
 * function.  The descriptor contains methods like when(rejected), get(name),
 * set(name, value), post(name, args), and delete(name), which all
 * return either a value, a promise for a value, or a rejection.  The fallback
 * accepts the operation name, a resolver, and any further arguments that would
 * have been forwarded to the appropriate method above had a method been
 * provided with the proper name.  The API makes no guarantees about the nature
 * of the returned object, apart from that it is usable whereever promises are
 * bought and sold.
 */
Q.makePromise = Promise;
function Promise(descriptor, fallback, inspect) {
    if (fallback === void 0) {
        fallback = function (op) {
            return reject(new Error(
                "Promise does not support operation: " + op
            ));
        };
    }
    if (inspect === void 0) {
        inspect = function () {
            return {state: "unknown"};
        };
    }

    var promise = object_create(Promise.prototype);

    promise.promiseDispatch = function (resolve, op, args) {
        var result;
        try {
            if (descriptor[op]) {
                result = descriptor[op].apply(promise, args);
            } else {
                result = fallback.call(promise, op, args);
            }
        } catch (exception) {
            result = reject(exception);
        }
        if (resolve) {
            resolve(result);
        }
    };

    promise.inspect = inspect;

    // XXX deprecated `valueOf` and `exception` support
    if (inspect) {
        var inspected = inspect();
        if (inspected.state === "rejected") {
            promise.exception = inspected.reason;
        }

        promise.valueOf = function () {
            var inspected = inspect();
            if (inspected.state === "pending" ||
                inspected.state === "rejected") {
                return promise;
            }
            return inspected.value;
        };
    }

    return promise;
}

Promise.prototype.toString = function () {
    return "[object Promise]";
};

Promise.prototype.then = function (fulfilled, rejected, progressed) {
    var self = this;
    var deferred = defer();
    var done = false;   // ensure the untrusted promise makes at most a
                        // single call to one of the callbacks

    function _fulfilled(value) {
        try {
            return typeof fulfilled === "function" ? fulfilled(value) : value;
        } catch (exception) {
            return reject(exception);
        }
    }

    function _rejected(exception) {
        if (typeof rejected === "function") {
            makeStackTraceLong(exception, self);
            try {
                return rejected(exception);
            } catch (newException) {
                return reject(newException);
            }
        }
        return reject(exception);
    }

    function _progressed(value) {
        return typeof progressed === "function" ? progressed(value) : value;
    }

    Q.nextTick(function () {
        self.promiseDispatch(function (value) {
            if (done) {
                return;
            }
            done = true;

            deferred.resolve(_fulfilled(value));
        }, "when", [function (exception) {
            if (done) {
                return;
            }
            done = true;

            deferred.resolve(_rejected(exception));
        }]);
    });

    // Progress propagator need to be attached in the current tick.
    self.promiseDispatch(void 0, "when", [void 0, function (value) {
        var newValue;
        var threw = false;
        try {
            newValue = _progressed(value);
        } catch (e) {
            threw = true;
            if (Q.onerror) {
                Q.onerror(e);
            } else {
                throw e;
            }
        }

        if (!threw) {
            deferred.notify(newValue);
        }
    }]);

    return deferred.promise;
};

Q.tap = function (promise, callback) {
    return Q(promise).tap(callback);
};

/**
 * Works almost like "finally", but not called for rejections.
 * Original resolution value is passed through callback unaffected.
 * Callback may return a promise that will be awaited for.
 * @param {Function} callback
 * @returns {Q.Promise}
 * @example
 * doSomething()
 *   .then(...)
 *   .tap(console.log)
 *   .then(...);
 */
Promise.prototype.tap = function (callback) {
    callback = Q(callback);

    return this.then(function (value) {
        return callback.fcall(value).thenResolve(value);
    });
};

/**
 * Registers an observer on a promise.
 *
 * Guarantees:
 *
 * 1. that fulfilled and rejected will be called only once.
 * 2. that either the fulfilled callback or the rejected callback will be
 *    called, but not both.
 * 3. that fulfilled and rejected will not be called in this turn.
 *
 * @param value      promise or immediate reference to observe
 * @param fulfilled  function to be called with the fulfilled value
 * @param rejected   function to be called with the rejection exception
 * @param progressed function to be called on any progress notifications
 * @return promise for the return value from the invoked callback
 */
Q.when = when;
function when(value, fulfilled, rejected, progressed) {
    return Q(value).then(fulfilled, rejected, progressed);
}

Promise.prototype.thenResolve = function (value) {
    return this.then(function () { return value; });
};

Q.thenResolve = function (promise, value) {
    return Q(promise).thenResolve(value);
};

Promise.prototype.thenReject = function (reason) {
    return this.then(function () { throw reason; });
};

Q.thenReject = function (promise, reason) {
    return Q(promise).thenReject(reason);
};

/**
 * If an object is not a promise, it is as "near" as possible.
 * If a promise is rejected, it is as "near" as possible too.
 * If it’s a fulfilled promise, the fulfillment value is nearer.
 * If it’s a deferred promise and the deferred has been resolved, the
 * resolution is "nearer".
 * @param object
 * @returns most resolved (nearest) form of the object
 */

// XXX should we re-do this?
Q.nearer = nearer;
function nearer(value) {
    if (isPromise(value)) {
        var inspected = value.inspect();
        if (inspected.state === "fulfilled") {
            return inspected.value;
        }
    }
    return value;
}

/**
 * @returns whether the given object is a promise.
 * Otherwise it is a fulfilled value.
 */
Q.isPromise = isPromise;
function isPromise(object) {
    return object instanceof Promise;
}

Q.isPromiseAlike = isPromiseAlike;
function isPromiseAlike(object) {
    return isObject(object) && typeof object.then === "function";
}

/**
 * @returns whether the given object is a pending promise, meaning not
 * fulfilled or rejected.
 */
Q.isPending = isPending;
function isPending(object) {
    return isPromise(object) && object.inspect().state === "pending";
}

Promise.prototype.isPending = function () {
    return this.inspect().state === "pending";
};

/**
 * @returns whether the given object is a value or fulfilled
 * promise.
 */
Q.isFulfilled = isFulfilled;
function isFulfilled(object) {
    return !isPromise(object) || object.inspect().state === "fulfilled";
}

Promise.prototype.isFulfilled = function () {
    return this.inspect().state === "fulfilled";
};

/**
 * @returns whether the given object is a rejected promise.
 */
Q.isRejected = isRejected;
function isRejected(object) {
    return isPromise(object) && object.inspect().state === "rejected";
}

Promise.prototype.isRejected = function () {
    return this.inspect().state === "rejected";
};

//// BEGIN UNHANDLED REJECTION TRACKING

// This promise library consumes exceptions thrown in handlers so they can be
// handled by a subsequent promise.  The exceptions get added to this array when
// they are created, and removed when they are handled.  Note that in ES6 or
// shimmed environments, this would naturally be a `Set`.
var unhandledReasons = [];
var unhandledRejections = [];
var reportedUnhandledRejections = [];
var trackUnhandledRejections = true;

function resetUnhandledRejections() {
    unhandledReasons.length = 0;
    unhandledRejections.length = 0;

    if (!trackUnhandledRejections) {
        trackUnhandledRejections = true;
    }
}

function trackRejection(promise, reason) {
    if (!trackUnhandledRejections) {
        return;
    }
    if (typeof process === "object" && typeof process.emit === "function") {
        Q.nextTick.runAfter(function () {
            if (array_indexOf(unhandledRejections, promise) !== -1) {
                process.emit("unhandledRejection", reason, promise);
                reportedUnhandledRejections.push(promise);
            }
        });
    }

    unhandledRejections.push(promise);
    if (reason && typeof reason.stack !== "undefined") {
        unhandledReasons.push(reason.stack);
    } else {
        unhandledReasons.push("(no stack) " + reason);
    }
}

function untrackRejection(promise) {
    if (!trackUnhandledRejections) {
        return;
    }

    var at = array_indexOf(unhandledRejections, promise);
    if (at !== -1) {
        if (typeof process === "object" && typeof process.emit === "function") {
            Q.nextTick.runAfter(function () {
                var atReport = array_indexOf(reportedUnhandledRejections, promise);
                if (atReport !== -1) {
                    process.emit("rejectionHandled", unhandledReasons[at], promise);
                    reportedUnhandledRejections.splice(atReport, 1);
                }
            });
        }
        unhandledRejections.splice(at, 1);
        unhandledReasons.splice(at, 1);
    }
}

Q.resetUnhandledRejections = resetUnhandledRejections;

Q.getUnhandledReasons = function () {
    // Make a copy so that consumers can't interfere with our internal state.
    return unhandledReasons.slice();
};

Q.stopUnhandledRejectionTracking = function () {
    resetUnhandledRejections();
    trackUnhandledRejections = false;
};

resetUnhandledRejections();

//// END UNHANDLED REJECTION TRACKING

/**
 * Constructs a rejected promise.
 * @param reason value describing the failure
 */
Q.reject = reject;
function reject(reason) {
    var rejection = Promise({
        "when": function (rejected) {
            // note that the error has been handled
            if (rejected) {
                untrackRejection(this);
            }
            return rejected ? rejected(reason) : this;
        }
    }, function fallback() {
        return this;
    }, function inspect() {
        return { state: "rejected", reason: reason };
    });

    // Note that the reason has not been handled.
    trackRejection(rejection, reason);

    return rejection;
}

/**
 * Constructs a fulfilled promise for an immediate reference.
 * @param value immediate reference
 */
Q.fulfill = fulfill;
function fulfill(value) {
    return Promise({
        "when": function () {
            return value;
        },
        "get": function (name) {
            return value[name];
        },
        "set": function (name, rhs) {
            value[name] = rhs;
        },
        "delete": function (name) {
            delete value[name];
        },
        "post": function (name, args) {
            // Mark Miller proposes that post with no name should apply a
            // promised function.
            if (name === null || name === void 0) {
                return value.apply(void 0, args);
            } else {
                return value[name].apply(value, args);
            }
        },
        "apply": function (thisp, args) {
            return value.apply(thisp, args);
        },
        "keys": function () {
            return object_keys(value);
        }
    }, void 0, function inspect() {
        return { state: "fulfilled", value: value };
    });
}

/**
 * Converts thenables to Q promises.
 * @param promise thenable promise
 * @returns a Q promise
 */
function coerce(promise) {
    var deferred = defer();
    Q.nextTick(function () {
        try {
            promise.then(deferred.resolve, deferred.reject, deferred.notify);
        } catch (exception) {
            deferred.reject(exception);
        }
    });
    return deferred.promise;
}

/**
 * Annotates an object such that it will never be
 * transferred away from this process over any promise
 * communication channel.
 * @param object
 * @returns promise a wrapping of that object that
 * additionally responds to the "isDef" message
 * without a rejection.
 */
Q.master = master;
function master(object) {
    return Promise({
        "isDef": function () {}
    }, function fallback(op, args) {
        return dispatch(object, op, args);
    }, function () {
        return Q(object).inspect();
    });
}

/**
 * Spreads the values of a promised array of arguments into the
 * fulfillment callback.
 * @param fulfilled callback that receives variadic arguments from the
 * promised array
 * @param rejected callback that receives the exception if the promise
 * is rejected.
 * @returns a promise for the return value or thrown exception of
 * either callback.
 */
Q.spread = spread;
function spread(value, fulfilled, rejected) {
    return Q(value).spread(fulfilled, rejected);
}

Promise.prototype.spread = function (fulfilled, rejected) {
    return this.all().then(function (array) {
        return fulfilled.apply(void 0, array);
    }, rejected);
};

/**
 * The async function is a decorator for generator functions, turning
 * them into asynchronous generators.  Although generators are only part
 * of the newest ECMAScript 6 drafts, this code does not cause syntax
 * errors in older engines.  This code should continue to work and will
 * in fact improve over time as the language improves.
 *
 * ES6 generators are currently part of V8 version 3.19 with the
 * --harmony-generators runtime flag enabled.  SpiderMonkey has had them
 * for longer, but under an older Python-inspired form.  This function
 * works on both kinds of generators.
 *
 * Decorates a generator function such that:
 *  - it may yield promises
 *  - execution will continue when that promise is fulfilled
 *  - the value of the yield expression will be the fulfilled value
 *  - it returns a promise for the return value (when the generator
 *    stops iterating)
 *  - the decorated function returns a promise for the return value
 *    of the generator or the first rejected promise among those
 *    yielded.
 *  - if an error is thrown in the generator, it propagates through
 *    every following yield until it is caught, or until it escapes
 *    the generator function altogether, and is translated into a
 *    rejection for the promise returned by the decorated generator.
 */
Q.async = async;
function async(makeGenerator) {
    return function () {
        // when verb is "send", arg is a value
        // when verb is "throw", arg is an exception
        function continuer(verb, arg) {
            var result;

            // Until V8 3.19 / Chromium 29 is released, SpiderMonkey is the only
            // engine that has a deployed base of browsers that support generators.
            // However, SM's generators use the Python-inspired semantics of
            // outdated ES6 drafts.  We would like to support ES6, but we'd also
            // like to make it possible to use generators in deployed browsers, so
            // we also support Python-style generators.  At some point we can remove
            // this block.

            if (typeof StopIteration === "undefined") {
                // ES6 Generators
                try {
                    result = generator[verb](arg);
                } catch (exception) {
                    return reject(exception);
                }
                if (result.done) {
                    return Q(result.value);
                } else {
                    return when(result.value, callback, errback);
                }
            } else {
                // SpiderMonkey Generators
                // FIXME: Remove this case when SM does ES6 generators.
                try {
                    result = generator[verb](arg);
                } catch (exception) {
                    if (isStopIteration(exception)) {
                        return Q(exception.value);
                    } else {
                        return reject(exception);
                    }
                }
                return when(result, callback, errback);
            }
        }
        var generator = makeGenerator.apply(this, arguments);
        var callback = continuer.bind(continuer, "next");
        var errback = continuer.bind(continuer, "throw");
        return callback();
    };
}

/**
 * The spawn function is a small wrapper around async that immediately
 * calls the generator and also ends the promise chain, so that any
 * unhandled errors are thrown instead of forwarded to the error
 * handler. This is useful because it's extremely common to run
 * generators at the top-level to work with libraries.
 */
Q.spawn = spawn;
function spawn(makeGenerator) {
    Q.done(Q.async(makeGenerator)());
}

// FIXME: Remove this interface once ES6 generators are in SpiderMonkey.
/**
 * Throws a ReturnValue exception to stop an asynchronous generator.
 *
 * This interface is a stop-gap measure to support generator return
 * values in older Firefox/SpiderMonkey.  In browsers that support ES6
 * generators like Chromium 29, just use "return" in your generator
 * functions.
 *
 * @param value the return value for the surrounding generator
 * @throws ReturnValue exception with the value.
 * @example
 * // ES6 style
 * Q.async(function* () {
 *      var foo = yield getFooPromise();
 *      var bar = yield getBarPromise();
 *      return foo + bar;
 * })
 * // Older SpiderMonkey style
 * Q.async(function () {
 *      var foo = yield getFooPromise();
 *      var bar = yield getBarPromise();
 *      Q.return(foo + bar);
 * })
 */
Q["return"] = _return;
function _return(value) {
    throw new QReturnValue(value);
}

/**
 * The promised function decorator ensures that any promise arguments
 * are settled and passed as values (`this` is also settled and passed
 * as a value).  It will also ensure that the result of a function is
 * always a promise.
 *
 * @example
 * var add = Q.promised(function (a, b) {
 *     return a + b;
 * });
 * add(Q(a), Q(B));
 *
 * @param {function} callback The function to decorate
 * @returns {function} a function that has been decorated.
 */
Q.promised = promised;
function promised(callback) {
    return function () {
        return spread([this, all(arguments)], function (self, args) {
            return callback.apply(self, args);
        });
    };
}

/**
 * sends a message to a value in a future turn
 * @param object* the recipient
 * @param op the name of the message operation, e.g., "when",
 * @param args further arguments to be forwarded to the operation
 * @returns result {Promise} a promise for the result of the operation
 */
Q.dispatch = dispatch;
function dispatch(object, op, args) {
    return Q(object).dispatch(op, args);
}

Promise.prototype.dispatch = function (op, args) {
    var self = this;
    var deferred = defer();
    Q.nextTick(function () {
        self.promiseDispatch(deferred.resolve, op, args);
    });
    return deferred.promise;
};

/**
 * Gets the value of a property in a future turn.
 * @param object    promise or immediate reference for target object
 * @param name      name of property to get
 * @return promise for the property value
 */
Q.get = function (object, key) {
    return Q(object).dispatch("get", [key]);
};

Promise.prototype.get = function (key) {
    return this.dispatch("get", [key]);
};

/**
 * Sets the value of a property in a future turn.
 * @param object    promise or immediate reference for object object
 * @param name      name of property to set
 * @param value     new value of property
 * @return promise for the return value
 */
Q.set = function (object, key, value) {
    return Q(object).dispatch("set", [key, value]);
};

Promise.prototype.set = function (key, value) {
    return this.dispatch("set", [key, value]);
};

/**
 * Deletes a property in a future turn.
 * @param object    promise or immediate reference for target object
 * @param name      name of property to delete
 * @return promise for the return value
 */
Q.del = // XXX legacy
Q["delete"] = function (object, key) {
    return Q(object).dispatch("delete", [key]);
};

Promise.prototype.del = // XXX legacy
Promise.prototype["delete"] = function (key) {
    return this.dispatch("delete", [key]);
};

/**
 * Invokes a method in a future turn.
 * @param object    promise or immediate reference for target object
 * @param name      name of method to invoke
 * @param value     a value to post, typically an array of
 *                  invocation arguments for promises that
 *                  are ultimately backed with `resolve` values,
 *                  as opposed to those backed with URLs
 *                  wherein the posted value can be any
 *                  JSON serializable object.
 * @return promise for the return value
 */
// bound locally because it is used by other methods
Q.mapply = // XXX As proposed by "Redsandro"
Q.post = function (object, name, args) {
    return Q(object).dispatch("post", [name, args]);
};

Promise.prototype.mapply = // XXX As proposed by "Redsandro"
Promise.prototype.post = function (name, args) {
    return this.dispatch("post", [name, args]);
};

/**
 * Invokes a method in a future turn.
 * @param object    promise or immediate reference for target object
 * @param name      name of method to invoke
 * @param ...args   array of invocation arguments
 * @return promise for the return value
 */
Q.send = // XXX Mark Miller's proposed parlance
Q.mcall = // XXX As proposed by "Redsandro"
Q.invoke = function (object, name /*...args*/) {
    return Q(object).dispatch("post", [name, array_slice(arguments, 2)]);
};

Promise.prototype.send = // XXX Mark Miller's proposed parlance
Promise.prototype.mcall = // XXX As proposed by "Redsandro"
Promise.prototype.invoke = function (name /*...args*/) {
    return this.dispatch("post", [name, array_slice(arguments, 1)]);
};

/**
 * Applies the promised function in a future turn.
 * @param object    promise or immediate reference for target function
 * @param args      array of application arguments
 */
Q.fapply = function (object, args) {
    return Q(object).dispatch("apply", [void 0, args]);
};

Promise.prototype.fapply = function (args) {
    return this.dispatch("apply", [void 0, args]);
};

/**
 * Calls the promised function in a future turn.
 * @param object    promise or immediate reference for target function
 * @param ...args   array of application arguments
 */
Q["try"] =
Q.fcall = function (object /* ...args*/) {
    return Q(object).dispatch("apply", [void 0, array_slice(arguments, 1)]);
};

Promise.prototype.fcall = function (/*...args*/) {
    return this.dispatch("apply", [void 0, array_slice(arguments)]);
};

/**
 * Binds the promised function, transforming return values into a fulfilled
 * promise and thrown errors into a rejected one.
 * @param object    promise or immediate reference for target function
 * @param ...args   array of application arguments
 */
Q.fbind = function (object /*...args*/) {
    var promise = Q(object);
    var args = array_slice(arguments, 1);
    return function fbound() {
        return promise.dispatch("apply", [
            this,
            args.concat(array_slice(arguments))
        ]);
    };
};
Promise.prototype.fbind = function (/*...args*/) {
    var promise = this;
    var args = array_slice(arguments);
    return function fbound() {
        return promise.dispatch("apply", [
            this,
            args.concat(array_slice(arguments))
        ]);
    };
};

/**
 * Requests the names of the owned properties of a promised
 * object in a future turn.
 * @param object    promise or immediate reference for target object
 * @return promise for the keys of the eventually settled object
 */
Q.keys = function (object) {
    return Q(object).dispatch("keys", []);
};

Promise.prototype.keys = function () {
    return this.dispatch("keys", []);
};

/**
 * Turns an array of promises into a promise for an array.  If any of
 * the promises gets rejected, the whole array is rejected immediately.
 * @param {Array*} an array (or promise for an array) of values (or
 * promises for values)
 * @returns a promise for an array of the corresponding values
 */
// By Mark Miller
// http://wiki.ecmascript.org/doku.php?id=strawman:concurrency&rev=1308776521#allfulfilled
Q.all = all;
function all(promises) {
    return when(promises, function (promises) {
        var pendingCount = 0;
        var deferred = defer();
        array_reduce(promises, function (undefined, promise, index) {
            var snapshot;
            if (
                isPromise(promise) &&
                (snapshot = promise.inspect()).state === "fulfilled"
            ) {
                promises[index] = snapshot.value;
            } else {
                ++pendingCount;
                when(
                    promise,
                    function (value) {
                        promises[index] = value;
                        if (--pendingCount === 0) {
                            deferred.resolve(promises);
                        }
                    },
                    deferred.reject,
                    function (progress) {
                        deferred.notify({ index: index, value: progress });
                    }
                );
            }
        }, void 0);
        if (pendingCount === 0) {
            deferred.resolve(promises);
        }
        return deferred.promise;
    });
}

Promise.prototype.all = function () {
    return all(this);
};

/**
 * Returns the first resolved promise of an array. Prior rejected promises are
 * ignored.  Rejects only if all promises are rejected.
 * @param {Array*} an array containing values or promises for values
 * @returns a promise fulfilled with the value of the first resolved promise,
 * or a rejected promise if all promises are rejected.
 */
Q.any = any;

function any(promises) {
    if (promises.length === 0) {
        return Q.resolve();
    }

    var deferred = Q.defer();
    var pendingCount = 0;
    array_reduce(promises, function (prev, current, index) {
        var promise = promises[index];

        pendingCount++;

        when(promise, onFulfilled, onRejected, onProgress);
        function onFulfilled(result) {
            deferred.resolve(result);
        }
        function onRejected() {
            pendingCount--;
            if (pendingCount === 0) {
                deferred.reject(new Error(
                    "Can't get fulfillment value from any promise, all " +
                    "promises were rejected."
                ));
            }
        }
        function onProgress(progress) {
            deferred.notify({
                index: index,
                value: progress
            });
        }
    }, undefined);

    return deferred.promise;
}

Promise.prototype.any = function () {
    return any(this);
};

/**
 * Waits for all promises to be settled, either fulfilled or
 * rejected.  This is distinct from `all` since that would stop
 * waiting at the first rejection.  The promise returned by
 * `allResolved` will never be rejected.
 * @param promises a promise for an array (or an array) of promises
 * (or values)
 * @return a promise for an array of promises
 */
Q.allResolved = deprecate(allResolved, "allResolved", "allSettled");
function allResolved(promises) {
    return when(promises, function (promises) {
        promises = array_map(promises, Q);
        return when(all(array_map(promises, function (promise) {
            return when(promise, noop, noop);
        })), function () {
            return promises;
        });
    });
}

Promise.prototype.allResolved = function () {
    return allResolved(this);
};

/**
 * @see Promise#allSettled
 */
Q.allSettled = allSettled;
function allSettled(promises) {
    return Q(promises).allSettled();
}

/**
 * Turns an array of promises into a promise for an array of their states (as
 * returned by `inspect`) when they have all settled.
 * @param {Array[Any*]} values an array (or promise for an array) of values (or
 * promises for values)
 * @returns {Array[State]} an array of states for the respective values.
 */
Promise.prototype.allSettled = function () {
    return this.then(function (promises) {
        return all(array_map(promises, function (promise) {
            promise = Q(promise);
            function regardless() {
                return promise.inspect();
            }
            return promise.then(regardless, regardless);
        }));
    });
};

/**
 * Captures the failure of a promise, giving an oportunity to recover
 * with a callback.  If the given promise is fulfilled, the returned
 * promise is fulfilled.
 * @param {Any*} promise for something
 * @param {Function} callback to fulfill the returned promise if the
 * given promise is rejected
 * @returns a promise for the return value of the callback
 */
Q.fail = // XXX legacy
Q["catch"] = function (object, rejected) {
    return Q(object).then(void 0, rejected);
};

Promise.prototype.fail = // XXX legacy
Promise.prototype["catch"] = function (rejected) {
    return this.then(void 0, rejected);
};

/**
 * Attaches a listener that can respond to progress notifications from a
 * promise's originating deferred. This listener receives the exact arguments
 * passed to ``deferred.notify``.
 * @param {Any*} promise for something
 * @param {Function} callback to receive any progress notifications
 * @returns the given promise, unchanged
 */
Q.progress = progress;
function progress(object, progressed) {
    return Q(object).then(void 0, void 0, progressed);
}

Promise.prototype.progress = function (progressed) {
    return this.then(void 0, void 0, progressed);
};

/**
 * Provides an opportunity to observe the settling of a promise,
 * regardless of whether the promise is fulfilled or rejected.  Forwards
 * the resolution to the returned promise when the callback is done.
 * The callback can return a promise to defer completion.
 * @param {Any*} promise
 * @param {Function} callback to observe the resolution of the given
 * promise, takes no arguments.
 * @returns a promise for the resolution of the given promise when
 * ``fin`` is done.
 */
Q.fin = // XXX legacy
Q["finally"] = function (object, callback) {
    return Q(object)["finally"](callback);
};

Promise.prototype.fin = // XXX legacy
Promise.prototype["finally"] = function (callback) {
    callback = Q(callback);
    return this.then(function (value) {
        return callback.fcall().then(function () {
            return value;
        });
    }, function (reason) {
        // TODO attempt to recycle the rejection with "this".
        return callback.fcall().then(function () {
            throw reason;
        });
    });
};

/**
 * Terminates a chain of promises, forcing rejections to be
 * thrown as exceptions.
 * @param {Any*} promise at the end of a chain of promises
 * @returns nothing
 */
Q.done = function (object, fulfilled, rejected, progress) {
    return Q(object).done(fulfilled, rejected, progress);
};

Promise.prototype.done = function (fulfilled, rejected, progress) {
    var onUnhandledError = function (error) {
        // forward to a future turn so that ``when``
        // does not catch it and turn it into a rejection.
        Q.nextTick(function () {
            makeStackTraceLong(error, promise);
            if (Q.onerror) {
                Q.onerror(error);
            } else {
                throw error;
            }
        });
    };

    // Avoid unnecessary `nextTick`ing via an unnecessary `when`.
    var promise = fulfilled || rejected || progress ?
        this.then(fulfilled, rejected, progress) :
        this;

    if (typeof process === "object" && process && process.domain) {
        onUnhandledError = process.domain.bind(onUnhandledError);
    }

    promise.then(void 0, onUnhandledError);
};

/**
 * Causes a promise to be rejected if it does not get fulfilled before
 * some milliseconds time out.
 * @param {Any*} promise
 * @param {Number} milliseconds timeout
 * @param {Any*} custom error message or Error object (optional)
 * @returns a promise for the resolution of the given promise if it is
 * fulfilled before the timeout, otherwise rejected.
 */
Q.timeout = function (object, ms, error) {
    return Q(object).timeout(ms, error);
};

Promise.prototype.timeout = function (ms, error) {
    var deferred = defer();
    var timeoutId = setTimeout(function () {
        if (!error || "string" === typeof error) {
            error = new Error(error || "Timed out after " + ms + " ms");
            error.code = "ETIMEDOUT";
        }
        deferred.reject(error);
    }, ms);

    this.then(function (value) {
        clearTimeout(timeoutId);
        deferred.resolve(value);
    }, function (exception) {
        clearTimeout(timeoutId);
        deferred.reject(exception);
    }, deferred.notify);

    return deferred.promise;
};

/**
 * Returns a promise for the given value (or promised value), some
 * milliseconds after it resolved. Passes rejections immediately.
 * @param {Any*} promise
 * @param {Number} milliseconds
 * @returns a promise for the resolution of the given promise after milliseconds
 * time has elapsed since the resolution of the given promise.
 * If the given promise rejects, that is passed immediately.
 */
Q.delay = function (object, timeout) {
    if (timeout === void 0) {
        timeout = object;
        object = void 0;
    }
    return Q(object).delay(timeout);
};

Promise.prototype.delay = function (timeout) {
    return this.then(function (value) {
        var deferred = defer();
        setTimeout(function () {
            deferred.resolve(value);
        }, timeout);
        return deferred.promise;
    });
};

/**
 * Passes a continuation to a Node function, which is called with the given
 * arguments provided as an array, and returns a promise.
 *
 *      Q.nfapply(FS.readFile, [__filename])
 *      .then(function (content) {
 *      })
 *
 */
Q.nfapply = function (callback, args) {
    return Q(callback).nfapply(args);
};

Promise.prototype.nfapply = function (args) {
    var deferred = defer();
    var nodeArgs = array_slice(args);
    nodeArgs.push(deferred.makeNodeResolver());
    this.fapply(nodeArgs).fail(deferred.reject);
    return deferred.promise;
};

/**
 * Passes a continuation to a Node function, which is called with the given
 * arguments provided individually, and returns a promise.
 * @example
 * Q.nfcall(FS.readFile, __filename)
 * .then(function (content) {
 * })
 *
 */
Q.nfcall = function (callback /*...args*/) {
    var args = array_slice(arguments, 1);
    return Q(callback).nfapply(args);
};

Promise.prototype.nfcall = function (/*...args*/) {
    var nodeArgs = array_slice(arguments);
    var deferred = defer();
    nodeArgs.push(deferred.makeNodeResolver());
    this.fapply(nodeArgs).fail(deferred.reject);
    return deferred.promise;
};

/**
 * Wraps a NodeJS continuation passing function and returns an equivalent
 * version that returns a promise.
 * @example
 * Q.nfbind(FS.readFile, __filename)("utf-8")
 * .then(console.log)
 * .done()
 */
Q.nfbind =
Q.denodeify = function (callback /*...args*/) {
    var baseArgs = array_slice(arguments, 1);
    return function () {
        var nodeArgs = baseArgs.concat(array_slice(arguments));
        var deferred = defer();
        nodeArgs.push(deferred.makeNodeResolver());
        Q(callback).fapply(nodeArgs).fail(deferred.reject);
        return deferred.promise;
    };
};

Promise.prototype.nfbind =
Promise.prototype.denodeify = function (/*...args*/) {
    var args = array_slice(arguments);
    args.unshift(this);
    return Q.denodeify.apply(void 0, args);
};

Q.nbind = function (callback, thisp /*...args*/) {
    var baseArgs = array_slice(arguments, 2);
    return function () {
        var nodeArgs = baseArgs.concat(array_slice(arguments));
        var deferred = defer();
        nodeArgs.push(deferred.makeNodeResolver());
        function bound() {
            return callback.apply(thisp, arguments);
        }
        Q(bound).fapply(nodeArgs).fail(deferred.reject);
        return deferred.promise;
    };
};

Promise.prototype.nbind = function (/*thisp, ...args*/) {
    var args = array_slice(arguments, 0);
    args.unshift(this);
    return Q.nbind.apply(void 0, args);
};

/**
 * Calls a method of a Node-style object that accepts a Node-style
 * callback with a given array of arguments, plus a provided callback.
 * @param object an object that has the named method
 * @param {String} name name of the method of object
 * @param {Array} args arguments to pass to the method; the callback
 * will be provided by Q and appended to these arguments.
 * @returns a promise for the value or error
 */
Q.nmapply = // XXX As proposed by "Redsandro"
Q.npost = function (object, name, args) {
    return Q(object).npost(name, args);
};

Promise.prototype.nmapply = // XXX As proposed by "Redsandro"
Promise.prototype.npost = function (name, args) {
    var nodeArgs = array_slice(args || []);
    var deferred = defer();
    nodeArgs.push(deferred.makeNodeResolver());
    this.dispatch("post", [name, nodeArgs]).fail(deferred.reject);
    return deferred.promise;
};

/**
 * Calls a method of a Node-style object that accepts a Node-style
 * callback, forwarding the given variadic arguments, plus a provided
 * callback argument.
 * @param object an object that has the named method
 * @param {String} name name of the method of object
 * @param ...args arguments to pass to the method; the callback will
 * be provided by Q and appended to these arguments.
 * @returns a promise for the value or error
 */
Q.nsend = // XXX Based on Mark Miller's proposed "send"
Q.nmcall = // XXX Based on "Redsandro's" proposal
Q.ninvoke = function (object, name /*...args*/) {
    var nodeArgs = array_slice(arguments, 2);
    var deferred = defer();
    nodeArgs.push(deferred.makeNodeResolver());
    Q(object).dispatch("post", [name, nodeArgs]).fail(deferred.reject);
    return deferred.promise;
};

Promise.prototype.nsend = // XXX Based on Mark Miller's proposed "send"
Promise.prototype.nmcall = // XXX Based on "Redsandro's" proposal
Promise.prototype.ninvoke = function (name /*...args*/) {
    var nodeArgs = array_slice(arguments, 1);
    var deferred = defer();
    nodeArgs.push(deferred.makeNodeResolver());
    this.dispatch("post", [name, nodeArgs]).fail(deferred.reject);
    return deferred.promise;
};

/**
 * If a function would like to support both Node continuation-passing-style and
 * promise-returning-style, it can end its internal promise chain with
 * `nodeify(nodeback)`, forwarding the optional nodeback argument.  If the user
 * elects to use a nodeback, the result will be sent there.  If they do not
 * pass a nodeback, they will receive the result promise.
 * @param object a result (or a promise for a result)
 * @param {Function} nodeback a Node.js-style callback
 * @returns either the promise or nothing
 */
Q.nodeify = nodeify;
function nodeify(object, nodeback) {
    return Q(object).nodeify(nodeback);
}

Promise.prototype.nodeify = function (nodeback) {
    if (nodeback) {
        this.then(function (value) {
            Q.nextTick(function () {
                nodeback(null, value);
            });
        }, function (error) {
            Q.nextTick(function () {
                nodeback(error);
            });
        });
    } else {
        return this;
    }
};

Q.noConflict = function() {
    throw new Error("Q.noConflict only works when Q is used as a global");
};

// All code before this point will be filtered from stack traces.
var qEndingLine = captureLine();

return Q;

});

},{}],45:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var _1 = require("./");
var path = require("path");
;
var ErrorInformation = (function () {
    function ErrorInformation(options) {
        if (!options.rawError) {
            throw new Error("You must provide an error to process");
        }
        this._rawError = options.rawError;
        this._errorType = options.errorType;
        this._packageInfo = options.packageInfo;
        this._exeName = defaultValue(path.basename(process.execPath), options.exeName);
        this._errorReporter = options.errorReporter;
        this._pathMode = defaultValue(_1.pathMode.defaultMode, options.mode);
    }
    ErrorInformation.prototype.getStructuredStack = function () {
        if (!this._structuredError) {
            try {
                this._structuredError = this.rawToStructured(this._rawError.stack);
            }
            catch (e) {
                if (this.errorReporter) {
                    this.errorReporter.emitInternalError(e, this._rawError, "");
                }
                throw e;
            }
        }
        return this._structuredError;
    };
    ErrorInformation.prototype.getStandardStack = function () {
        if (!this._standardStack) {
            try {
                this._standardStack = _1.structuredToStandard(this.getStructuredStack());
            }
            catch (e) {
                if (this.errorReporter) {
                    this.errorReporter.emitInternalError(e, this._rawError, "");
                }
                throw e;
            }
        }
        return this._standardStack;
    };
    ErrorInformation.prototype.getVerboseStack = function () {
        if (!this._verboseStack) {
            try {
                this._verboseStack = _1.structuredToSemiWatson(this.getStructuredStack());
            }
            catch (e) {
                if (this.errorReporter) {
                    this.errorReporter.emitInternalError(e, this._rawError, "");
                }
                throw e;
            }
        }
        return this._verboseStack;
    };
    Object.defineProperty(ErrorInformation.prototype, "errorName", {
        get: function () {
            return this._rawError.name;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorInformation.prototype, "errorMessage", {
        get: function () {
            return this._rawError.message;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorInformation.prototype, "errorType", {
        get: function () {
            return this._errorType;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorInformation.prototype, "rawError", {
        get: function () {
            return this._rawError;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorInformation.prototype, "packageInfo", {
        get: function () {
            return this._packageInfo;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorInformation.prototype, "exeName", {
        get: function () {
            return this._exeName;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorInformation.prototype, "errorReporter", {
        get: function () {
            return this._errorReporter;
        },
        enumerable: true,
        configurable: true
    });
    ErrorInformation.prototype.rawToStructured = function (raw) {
        var stackProc = new _1.StackProcessor({
            appRoot: this.packageInfo.packageJsonFullPath,
            errorReporter: this.errorReporter,
            packageInfo: this.packageInfo,
            mode: this._pathMode });
        var originalLines = raw.split("\n");
        var structuredStack;
        try {
            structuredStack = stackProc.parseFirstLine(originalLines[0]);
        }
        catch (e) {
            structuredStack = { ErrorType: this.errorName, ErrorMessage: this.errorMessage, Stack: [] };
        }
        for (var i = 1; i < originalLines.length; i++) {
            var currentFrame = void 0;
            try {
                currentFrame = stackProc.parseStackLine(originalLines[i], true);
            }
            catch (e) {
                if (this.errorReporter) {
                    this.errorReporter.emitInternalError(e, this.rawError, originalLines[i]);
                }
                currentFrame = {
                    RelativePath: "UNSUPPORTED",
                    extra: {
                        failedToParse: true,
                        rawString: originalLines[i]
                    }
                };
            }
            structuredStack.Stack.push(currentFrame);
        }
        return structuredStack;
    };
    return ErrorInformation;
}());
exports.ErrorInformation = ErrorInformation;
function setStackTraceLimit(limit) {
    try {
        Error.stackTraceLimit(limit);
    }
    catch (e) {
        var err = Error;
        err.stackTraceLimit = limit;
    }
}
exports.setStackTraceLimit = setStackTraceLimit;
function coerceToError(e) {
    if (e instanceof Error) {
        return e;
    }
    return new NonError(e);
}
exports.coerceToError = coerceToError;
var NonError = (function (_super) {
    __extends(NonError, _super);
    function NonError(input) {
        _super.call(this);
        this.name = "NonError";
        if (input.message) {
            this.message = input.message;
        }
        else {
            this.message = JSON.stringify(input);
        }
        if (input.stack) {
            this.stack = input.stack;
        }
        else {
            var header = this.name + ": " + this.message;
            this.stack = header + "\nat NonError";
        }
        this.originalObject = input;
    }
    return NonError;
}(Error));
exports.NonError = NonError;
function defaultValue(defaultValue, actual, strict) {
    if (strict === void 0) { strict = true; }
    if ((strict && actual === undefined) || (!strict && !actual)) {
        return defaultValue;
    }
    return actual;
}
exports.defaultValue = defaultValue;

},{"./":46,"path":undefined}],46:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
__export(require("./error-info"));
__export(require("./processor"));
__export(require("./utils"));
var reporting_channel_1 = require("../reporting-channel");
exports.ReportingChannel = reporting_channel_1.ReportingChannel;
__export(require("../error-reporter-base"));

},{"../error-reporter-base":50,"../reporting-channel":52,"./error-info":45,"./processor":47,"./utils":48}],47:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var _1 = require("./");
var path_1 = require("path");
var defaultpath = require("path");
var fs = require("fs");
var NODE_MODULES_DIRNAME = "node_modules";
var PACKAGE_JSON_NAME = "package.json";
var VALID_NON_CODE_LOCATIONS = ["native", "NonError", "unknown"];
var StackProcessor = (function () {
    function StackProcessor(options) {
        this.doFileIO = true;
        this.appRoot = options.appRoot;
        this._errorReporter = options.errorReporter;
        this._packageInfo = options.packageInfo;
        switch (options.mode) {
            case _1.pathMode.defaultMode:
                this.path = defaultpath;
                break;
            case _1.pathMode.posix:
                this.path = path_1.posix;
                break;
            case _1.pathMode.windows:
                this.path = path_1.win32;
                break;
            default:
                this.path = defaultpath;
        }
    }
    StackProcessor.prototype.parseFirstLine = function (firstLine) {
        var firstLineRX = /(^.+?\b)(?:: )?(?:(.+?\b): )?(.*)/;
        var ERROR_SS = 1;
        var SYSTEM_ERROR_SS = 2;
        var MESSAGE_SS = 3;
        var matches = firstLine.match(firstLineRX);
        var type;
        if (matches[ERROR_SS] === "Error" && matches[SYSTEM_ERROR_SS]) {
            type = matches[SYSTEM_ERROR_SS];
        }
        else {
            type = matches[ERROR_SS];
        }
        var message = matches[MESSAGE_SS];
        return { ErrorType: type, ErrorMessage: message, Stack: [] };
    };
    StackProcessor.prototype.parseStackLine = function (inputLine, getPackageInfo) {
        if (getPackageInfo === void 0) { getPackageInfo = false; }
        var isEval = false;
        if (inputLine.includes("eval at")) {
            isEval = true;
            inputLine = this.cleanEvalFrames(inputLine);
        }
        inputLine = _1.replaceAll(inputLine, "(anonymous function)", "(anonymousfunction)");
        inputLine = _1.replaceAll(inputLine, "unknown location", "unknown");
        var mainRX = /\s*at (new )?(.+?)(?: \[as ([^ ]+?)\])?(?: \((.*)\))?$/;
        var newSS = 1;
        var functionNameSS = 2;
        var asMethodSS = 3;
        var locationSS = 4;
        var functionName;
        var location;
        var atNew = false;
        var asString = "";
        var mainMatches = inputLine.match(mainRX);
        if (!mainMatches) {
            var e = new Error("unrecognized stack trace format: " + inputLine);
            if (this._errorReporter) {
                this._errorReporter.emitInternalError(e, null, inputLine);
            }
            var temp = {
                RelativePath: "UNSUPPORTED",
                Package: { name: "UNSUPPORTED" },
                line: -1,
                column: -1,
                extra: { failedToParse: true } };
            return temp;
        }
        if (mainMatches[newSS]) {
            atNew = true;
        }
        if (mainMatches[asMethodSS]) {
            asString = mainMatches[asMethodSS];
        }
        if (mainMatches[locationSS]) {
            location = mainMatches[locationSS];
            functionName = mainMatches[functionNameSS];
        }
        else {
            location = mainMatches[functionNameSS];
            functionName = "";
        }
        var result = this.parseCodeLocation(location);
        result.FunctionName = functionName;
        var stripped = this.getPackageInfo(result.RelativePath);
        result.RelativePath = stripped.strippedPath;
        if (getPackageInfo && stripped.package) {
            result.Package = stripped.package;
        }
        if (atNew || asString || isEval) {
            if (atNew) {
                result.FunctionName += ".constructor";
            }
            if (asString) {
                result.FunctionName += "[" + asString + "]";
            }
            result.extra = { isNew: atNew, hasAs: asString, isEval: isEval, failedToParse: false, rawString: "" };
        }
        return result;
    };
    StackProcessor.prototype.cleanEvalFrames = function (input) {
        var evalRX = /\eval at .+\), /;
        return input.replace(evalRX, "");
    };
    StackProcessor.prototype.parseCodeLocation = function (input) {
        var i = VALID_NON_CODE_LOCATIONS.length;
        var element;
        while (i--) {
            element = VALID_NON_CODE_LOCATIONS[i];
            if (element === input) {
                return { RelativePath: input, line: -1, column: -1, FunctionName: "" };
            }
        }
        input = _1.replaceAll(input, "file:///", "");
        input = _1.replaceAll(input, "%20", " ");
        var locationRX = /(?:(^.+):(\d+):(\d+))/;
        var PATH_SS = 1;
        var LINE_SS = 2;
        var COLUMN_SS = 3;
        var line;
        var column;
        var matches = input.match(locationRX);
        if (!matches) {
            var intError = new Error("unsupported location format");
            if (this._errorReporter) {
                this._errorReporter.emitInternalError(intError, null, input);
            }
            return { RelativePath: "UNSUPPORTED", line: -1, column: -1, FunctionName: "" };
        }
        else {
            line = parseInt(matches[LINE_SS], 10);
            column = parseInt(matches[COLUMN_SS], 10);
        }
        var path = this.path.normalize(matches[PATH_SS]);
        return { RelativePath: path, line: line, column: column, FunctionName: "" };
    };
    StackProcessor.prototype.getPackageInfo = function (filePath) {
        var i = VALID_NON_CODE_LOCATIONS.length;
        var element;
        while (i--) {
            element = VALID_NON_CODE_LOCATIONS[i];
            if (element === filePath) {
                return { package: { name: "UNKNOWN" }, strippedPath: filePath };
            }
        }
        if (!this.path.isAbsolute(filePath)) {
            return {
                package: { name: "node", version: process.version },
                strippedPath: filePath };
        }
        var relPath = this.path.relative(this.appRoot, filePath);
        var nodeModIndex = filePath.lastIndexOf(NODE_MODULES_DIRNAME);
        if (nodeModIndex !== -1) {
            var modRoot = filePath.substring(0, nodeModIndex + NODE_MODULES_DIRNAME.length + 1);
            var modPath = this.path.relative(modRoot, filePath);
            var sepIndex = modPath.indexOf(this.path.sep);
            if (sepIndex !== -1) {
                var modName = modPath.substring(0, sepIndex);
                relPath = modPath.substring(sepIndex + 1);
                var pkg = { name: modName };
                if (this.doFileIO) {
                    try {
                        var fullPath = this.path.join(modRoot, modName, PACKAGE_JSON_NAME);
                        var pkgjs = JSON.parse(fs.readFileSync(fullPath, "utf8"));
                        pkg.packageJsonFullPath = fullPath;
                        if (pkgjs.name) {
                            pkg.name = pkgjs.name;
                        }
                        if (pkgjs.version) {
                            pkg.version = pkgjs.version;
                        }
                    }
                    catch (e) {
                    }
                }
                relPath = _1.convertPathToPosix(relPath);
                return { package: pkg, strippedPath: relPath };
            }
            if (this._errorReporter) {
                this._errorReporter.emitInternalError(new Error("javascript file in unexpected location"), null, filePath);
            }
            filePath = this.path.basename(filePath);
            return { package: { name: "UNKNOWN" }, strippedPath: filePath };
        }
        if (filePath.includes(".asar")) {
            var index = filePath.lastIndexOf(".asar") + ".asar".length;
            var asarName = this.path.basename(filePath.substring(0, index));
            var relativePath = _1.convertPathToPosix(filePath.substring(index + 1));
            relPath = _1.convertPathToPosix(relPath);
            return { package: { name: asarName }, strippedPath: relativePath };
        }
        if (relPath === filePath || relPath.startsWith("..") || this.appRoot === "") {
            filePath = this.path.basename(filePath);
            return { package: { name: "UNKNOWN" }, strippedPath: filePath };
        }
        relPath = _1.convertPathToPosix(relPath);
        return { package: this._packageInfo, strippedPath: relPath };
    };
    return StackProcessor;
}());
exports.StackProcessor = StackProcessor;
function removeUserName(input) {
    var userNameRX = /[a-z]:\\Users\\([^\\]+)/i;
    var match = input.match(userNameRX);
    if (match) {
        input = _1.replaceAll(input, match[1], "USERNAME");
    }
    return input;
}
exports.removeUserName = removeUserName;
function structuredToSemiWatson(input) {
    var _this = this;
    var WLB = _1.WATSON_LINE_BREAK;
    var result = "";
    input.Stack.forEach(function (frame) {
        result += (result ? WLB : "") + _this.frameToString(frame);
    });
    return result;
}
exports.structuredToSemiWatson = structuredToSemiWatson;
function structuredToStandard(input) {
    var stack = "";
    input.Stack.forEach(function (frame) {
        if (frame.FunctionName) {
            stack += (stack ? "\n" : "") + ("" + ((frame.extra && frame.extra.isEval) ? "eval " : ""))
                + ("at " + frame.FunctionName + " ") +
                ("(" + frame.RelativePath);
            if (frame.line !== -1 && frame.column !== -1) {
                stack += ":" + frame.line + ":" + frame.column;
            }
            stack += ")";
        }
        else {
            stack += (stack ? "\n" : "") + (((frame.extra && frame.extra.isEval) ? "eval " : "") + "at ") +
                ("" + frame.RelativePath);
            if (frame.line !== -1 && frame.column !== -1) {
                stack += ":" + frame.line + ":" + frame.column;
            }
        }
    });
    return stack;
}
exports.structuredToStandard = structuredToStandard;
function frameToString(frame) {
    if (!frame) {
        return "UNSUPPORTED\tUNSUPPORTED";
    }
    var packageString = frame.Package.name;
    if (!packageString) {
        packageString = "UNKNOWN";
    }
    if (frame.Package.version) {
        packageString += "@" + frame.Package.version;
    }
    var fileInfo = frame.RelativePath;
    if (!fileInfo) {
        fileInfo = "UNKNOWN";
    }
    if (frame.line !== -1 && frame.column !== -1) {
        fileInfo += ":" + frame.line + ":" + frame.column;
    }
    var result = packageString + "\t" + fileInfo;
    if (frame.FunctionName) {
        result += "\t" + frame.FunctionName;
    }
    return result;
}
exports.frameToString = frameToString;

},{"./":46,"fs":undefined,"path":undefined}],48:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var path_1 = require("path");
exports.WATSON_LINE_BREAK = "\r\n";
(function (pathMode) {
    pathMode[pathMode["windows"] = 0] = "windows";
    pathMode[pathMode["posix"] = 1] = "posix";
    pathMode[pathMode["defaultMode"] = 2] = "defaultMode";
})(exports.pathMode || (exports.pathMode = {}));
var pathMode = exports.pathMode;
function convertPathToPosix(input) {
    input = replaceAll(input, "\\", "/");
    var networkPath = input.startsWith("//");
    if (!networkPath) {
        var driveLetterRX = /^([a-zA-Z]):/;
        input = input.replace(driveLetterRX, "/$1");
    }
    input = path_1.posix.normalize(input);
    if (networkPath) {
        input = "/" + input;
    }
    return input;
}
exports.convertPathToPosix = convertPathToPosix;
function convertPathToWindows(input) {
    input = replaceAll(input, "/", "\\");
    var networkPath = input.startsWith("\\\\");
    if (input.startsWith("\\") && !networkPath) {
        var driveLetterRX = /^\\([a-zA-Z])\\/;
        var match = input.match(driveLetterRX);
        if (match) {
            input = input.replace(driveLetterRX, match[1] + ":\\");
        }
        else {
            input = "A:" + input;
        }
    }
    input = path_1.win32.normalize(input);
    return input;
}
exports.convertPathToWindows = convertPathToWindows;
function replaceAll(input, find, replace) {
    if (!find) {
        return input;
    }
    if (find === replace) {
        return input;
    }
    if (replace.includes(find)) {
        throw new Error("replacement string includes the search string. This will send you into an infinite loop.");
    }
    while (input.includes(find)) {
        input = input.replace(find, replace);
    }
    return input;
}
exports.replaceAll = replaceAll;
var SEM_VER = /^(\d+\.\d+\.\d+(?:\.\d+)?)(?:-([A-Za-z0-9\.\-]+))?(?:\+([A-Za-z0-9\.\-]+))?$/;
var MAIN = 1;
var TAG = 2;
var DATE_YYYYMMDD = /\d{4}(\d{4})/;
function convertVersion(input) {
    var match = input.match(SEM_VER);
    if (match) {
        var release = match[MAIN];
        if (release.split(".").length === 4) {
            return release;
        }
        var finalNumber = ".";
        var tag = match[TAG];
        if (tag) {
            var tagComponents = tag.split(".");
            if (tagComponents.length !== 0) {
                var date = tagComponents[0].match(DATE_YYYYMMDD);
                if (date) {
                    finalNumber += date[1];
                }
                var lastIndex = tagComponents.length - 1;
                if (!Number.isNaN(Number.parseInt(tagComponents[lastIndex]))) {
                    finalNumber += tagComponents[lastIndex];
                }
            }
        }
        if (finalNumber !== ".") {
            return release + finalNumber;
        }
        else {
            return release;
        }
    }
    else {
        return replaceAll(input, "_", "-");
    }
}
exports.convertVersion = convertVersion;

},{"path":undefined}],49:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var error_reporter_base_1 = require("./error-reporter-base");
var advanced_1 = require("./advanced");
var try_all_1 = require("./try-all");
(function (State) {
    State[State["ready"] = 0] = "ready";
    State[State["reporting"] = 1] = "reporting";
    State[State["finishing"] = 2] = "finishing";
})(exports.State || (exports.State = {}));
var State = exports.State;
var ERROR_REPORTING_ASYNC_FAILURE = "ErrorReportAsyncFailure";
var USER_CALLBACK_UNCAUGHT_EXCEPTION = "userCallbackUncaught";
var ErrorHandlerNode = (function (_super) {
    __extends(ErrorHandlerNode, _super);
    function ErrorHandlerNode(options) {
        _super.call(this, { appRoot: options.appRoot, packageInfo: options.packageInfo, exeName: options.exeName });
        this.errorType = "NodeFatal";
        this.finalCallback = options.finalCallback;
        this.currentState = State.ready;
        advanced_1.setStackTraceLimit(Infinity);
        process.on("uncaughtException", this.handleUncaughtMain.bind(this));
    }
    ErrorHandlerNode.prototype.handleUncaughtMain = function (err) {
        var _this = this;
        if (this.currentState === State.ready) {
            this.currentState = State.reporting;
        }
        else if (this.currentState === State.reporting) {
            try {
                this.emitAsyncFailure(err);
            }
            catch (e) {
            }
            return;
        }
        else if (this.currentState === State.finishing) {
            this.finalExit();
        }
        var e = advanced_1.coerceToError(err);
        this.reportError(e, this.errorType).then(function () { _this.finishHandling(e); });
    };
    ErrorHandlerNode.prototype.finishHandling = function (err) {
        this.currentState = State.finishing;
        try {
            if (this.finalCallback && this.finalCallback(err)) {
                this.currentState = State.ready;
                return;
            }
        }
        catch (e) {
            try {
                this.emitUserCallbackUncaughtException(e);
            }
            catch (e1) {
            }
        }
        try {
            this.emitAboutToExit().then(this.finalExit, this.finalExit);
            setTimeout(this.finalExit, 500);
        }
        catch (e2) {
            this.finalExit();
        }
    };
    ErrorHandlerNode.prototype.finalExit = function () {
        if (process.platform === "win32") {
            process.abort();
        }
        process.exit(1);
    };
    ErrorHandlerNode.prototype.onAboutToExit = function (callback) {
        if (this.aboutToExitPromises === undefined) {
            this.aboutToExitPromises = [];
        }
        this.aboutToExitPromises.push(callback);
    };
    ErrorHandlerNode.prototype.emitAboutToExit = function () {
        if (this.aboutToExitPromises) {
            var promises_1 = [];
            this.aboutToExitPromises.forEach(function (element) {
                try {
                    promises_1.push(element());
                }
                catch (e) {
                }
            });
            return try_all_1.tryAll(promises_1);
        }
        return Promise.resolve();
    };
    ErrorHandlerNode.prototype.onAsyncFailure = function (callback) {
        this.emitter.on(ERROR_REPORTING_ASYNC_FAILURE, callback);
    };
    ErrorHandlerNode.prototype.emitAsyncFailure = function (asyncError) {
        return this.emitter.emit(ERROR_REPORTING_ASYNC_FAILURE, asyncError);
    };
    ErrorHandlerNode.prototype.onUserCallbackUncaughtException = function (callback) {
        this.emitter.on(USER_CALLBACK_UNCAUGHT_EXCEPTION, callback);
    };
    ErrorHandlerNode.prototype.emitUserCallbackUncaughtException = function (uncaughtException) {
        this.emitter.emit(USER_CALLBACK_UNCAUGHT_EXCEPTION, uncaughtException);
    };
    return ErrorHandlerNode;
}(error_reporter_base_1.ErrorReporter));
exports.ErrorHandlerNode = ErrorHandlerNode;

},{"./advanced":46,"./error-reporter-base":50,"./try-all":53}],50:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var try_all_1 = require("./try-all");
var path = require("path");
var advanced_1 = require("./advanced");
var events_1 = require("events");
var INTERNAL_ERROR = "internalError";
var ERROR_REPORTING_STARTED = "reportingStarted";
var ERROR_REPORTING_FINISHED = "reportingFinished";
var ErrorReporter = (function () {
    function ErrorReporter(config) {
        this._packageInfo = config.packageInfo;
        if (config.appRoot === "" || path.isAbsolute(config.appRoot)) {
            this._packageInfo.packageJsonFullPath = config.appRoot;
        }
        else {
            throw new Error(("Invalid app root \"" + config.appRoot + "\". ") +
                "You must provide an absolute path or an empty string");
        }
        this._exeName = config.exeName;
        this.emitter = new events_1.EventEmitter();
        this.channels = [];
    }
    ErrorReporter.prototype.addReportingChannel = function (channel) {
        this.channels.push(channel);
        channel.registerListeners(this);
    };
    ErrorReporter.prototype.removeReportingChannel = function (channel) {
        var index = this.channels.indexOf(channel);
        if (index !== -1) {
            this.channels.splice(index, 1);
        }
    };
    Object.defineProperty(ErrorReporter.prototype, "appName", {
        get: function () {
            return this._packageInfo.name;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorReporter.prototype, "appVersion", {
        get: function () {
            return this._packageInfo.version;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorReporter.prototype, "appRoot", {
        get: function () {
            return this._packageInfo.packageJsonFullPath;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ErrorReporter.prototype, "branch", {
        get: function () {
            return this._packageInfo.branch;
        },
        enumerable: true,
        configurable: true
    });
    ErrorReporter.prototype.reportError = function (err, errorType) {
        var _this = this;
        this.emitReportingStarted();
        var stack;
        try {
            stack = new advanced_1.ErrorInformation({ rawError: err,
                packageInfo: this._packageInfo,
                errorType: errorType,
                exeName: this._exeName,
                errorReporter: this });
        }
        catch (e) {
            try {
                this.emitInternalError(e, err, "");
            }
            catch (e1) {
            }
            if (!stack) {
                return Promise.resolve({});
            }
        }
        var reportPromises = [];
        var rejectionFunctions = [];
        var timeoutLimits = [];
        this.channels.forEach(function (channel) {
            var prom;
            try {
                prom = channel.report(stack);
            }
            catch (e) {
                prom = Promise.reject(e);
            }
            var timeoutPromise = new Promise(function (resolve, reject) {
                rejectionFunctions.push(reject);
                timeoutLimits.push(channel.timeout);
            });
            var compositeProm = Promise.race([prom, timeoutPromise]);
            reportPromises.push(compositeProm);
        });
        for (var i = 0; i < rejectionFunctions.length; i++) {
            if (timeoutLimits[i] >= 0) {
                setTimeout(rejectionFunctions[i], timeoutLimits[i], "timed out after " + timeoutLimits[i] + " ms");
            }
        }
        return try_all_1.tryAll(reportPromises)
            .then(function (results) {
            _this.reportInternalFailures(results, _this.channels);
            _this.emitReportingFinished(results);
            return results;
        })
            .catch(function (reason) {
            return reason;
        });
    };
    ;
    ErrorReporter.prototype.reportInternalFailures = function (results, channels) {
        for (var i = 0; i < channels.length; i++) {
            if (channels[i].reportOnFailure && !results.resolved[i]) {
                this.emitInternalError(results.failReasons[i], null, null);
            }
        }
    };
    ErrorReporter.prototype.onInternalError = function (callback) {
        this.emitter.on(INTERNAL_ERROR, callback);
    };
    ErrorReporter.prototype.emitInternalError = function (internalError, errorBeingProcessed, problemString) {
        if (this.emitter.listenerCount(INTERNAL_ERROR) > 0) {
            var proc = new advanced_1.ErrorInformation({ rawError: internalError });
            var stack = void 0;
            try {
                stack = proc.getVerboseStack();
            }
            catch (e) {
                stack = "UNKNOWN\tUNKNOWN";
            }
            var info = {
                props: {
                    InternalErrorStack: stack,
                    InternalErrorType: proc.errorName
                },
                PIIProps: {
                    InternalErrorMessage: proc.errorMessage,
                    RawInternalError: internalError,
                    OriginalError: errorBeingProcessed,
                    ProblemString: problemString
                }
            };
            this.emitter.emit(INTERNAL_ERROR, info);
        }
    };
    ErrorReporter.prototype.onReportingStarted = function (callback) {
        this.emitter.on(ERROR_REPORTING_STARTED, callback);
    };
    ErrorReporter.prototype.emitReportingStarted = function () {
        return this.emitter.emit(ERROR_REPORTING_STARTED);
    };
    ErrorReporter.prototype.onReportingFinished = function (callback) {
        this.emitter.on(ERROR_REPORTING_FINISHED, callback);
    };
    ErrorReporter.prototype.emitReportingFinished = function (results) {
        return this.emitter.emit(ERROR_REPORTING_FINISHED, results);
    };
    return ErrorReporter;
}());
exports.ErrorReporter = ErrorReporter;

},{"./advanced":46,"./try-all":53,"events":undefined,"path":undefined}],51:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var error_handler_node_1 = require("./error-handler-node");
exports.ErrorHandlerNode = error_handler_node_1.ErrorHandlerNode;
var reporting_channel_1 = require("./reporting-channel");
exports.ConsoleReporter = reporting_channel_1.ConsoleReporter;
exports.FileReporter = reporting_channel_1.FileReporter;

},{"./error-handler-node":49,"./reporting-channel":52}],52:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var advanced_1 = require("./advanced");
var fs = require("fs");
var path = require("path");
var DEFAULT_REPORT_ON_FAILURE = false;
var DEFAULT_TIMEOUT = 500;
var ReportingChannel = (function () {
    function ReportingChannel(reportOnFailure, timeoutMS) {
        this._reportOnFailure = reportOnFailure !== undefined ? reportOnFailure : DEFAULT_REPORT_ON_FAILURE;
        this._timeout = timeoutMS !== undefined ? timeoutMS : DEFAULT_TIMEOUT;
    }
    Object.defineProperty(ReportingChannel.prototype, "reportOnFailure", {
        get: function () {
            return this._reportOnFailure;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ReportingChannel.prototype, "timeout", {
        get: function () {
            return this._timeout;
        },
        enumerable: true,
        configurable: true
    });
    ReportingChannel.prototype.registerListeners = function (reporter) {
    };
    ;
    return ReportingChannel;
}());
exports.ReportingChannel = ReportingChannel;
var ConsoleReporter = (function (_super) {
    __extends(ConsoleReporter, _super);
    function ConsoleReporter() {
        _super.call(this);
    }
    ConsoleReporter.prototype.report = function (error) {
        return new Promise(function (resolve, reject) {
            if (error.rawError.stack.length > 2000) {
                var shortened = error.rawError.stack.substr(0, 1000);
                shortened += "\n...shortened to avoid blocking while printing...\n" +
                    "...see other reporting methods for full stack...\n";
                shortened += error.rawError.stack.substring(error.rawError.stack.length - 1000);
                console.log(shortened);
            }
            else {
                console.log(error.rawError.stack);
            }
            console.log();
            resolve();
        });
    };
    return ConsoleReporter;
}(ReportingChannel));
exports.ConsoleReporter = ConsoleReporter;
var FileReporter = (function (_super) {
    __extends(FileReporter, _super);
    function FileReporter(filePath, fileName, stripStack) {
        _super.call(this);
        this.fileName = fileName;
        this.filePath = filePath;
        this.stripStack = stripStack;
    }
    FileReporter.prototype.report = function (error) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var fullPath = path.join(_this.filePath, _this.fileName);
            var content;
            if (_this.stripStack) {
                content = error.errorName + advanced_1.WATSON_LINE_BREAK;
                content += error.errorMessage + advanced_1.WATSON_LINE_BREAK;
                content += error.getVerboseStack() + advanced_1.WATSON_LINE_BREAK + advanced_1.WATSON_LINE_BREAK;
            }
            else {
                content = error.rawError.stack + "\n";
            }
            fs.appendFile(fullPath, content, {}, function (err) { if (err) {
                reject(err.stack);
            }
            else {
                resolve(fullPath);
            } });
        });
    };
    return FileReporter;
}(ReportingChannel));
exports.FileReporter = FileReporter;

},{"./advanced":46,"fs":undefined,"path":undefined}],53:[function(require,module,exports){
/*!---------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/
"use strict";
var ResultsImpl = (function () {
    function ResultsImpl() {
        this.resolved = [];
        this.results = [];
        this.failReasons = [];
    }
    return ResultsImpl;
}());
function tryAll(input) {
    if (input.length === 0) {
        return Promise.resolve(new ResultsImpl());
    }
    var internalInstance = new ResultsImpl();
    var promisesInProgress = [];
    var _loop_1 = function(i) {
        if (input[i] && input[i].then) {
            promisesInProgress.push(input[i].then(function (value) {
                internalInstance.results[i] = value;
                internalInstance.resolved[i] = true;
                return value;
            }, function (reason) {
                internalInstance.resolved[i] = false;
                internalInstance.failReasons[i] = reason;
            }));
        }
        else {
            internalInstance.resolved[i] = false;
            internalInstance.failReasons[i] = "Invalid Promise: " + JSON.stringify(input[i]);
        }
    };
    for (var i = 0; i < input.length; i++) {
        _loop_1(i);
    }
    var internalPromise = Promise.all(promisesInProgress)
        .then(function () {
        return internalInstance;
    }, function (reason) {
        return Promise.reject(reason);
    });
    return internalPromise;
}
exports.tryAll = tryAll;

},{}],54:[function(require,module,exports){
// rmdir-recursive.js

'use strict';

var fs = require('fs');
var path = require('path');


//######################################################################
/**
 * Function: remove directory recursively (async)
 * Param   : dir: path to make directory
 *           [cb]: {optional} callback(err) function
 */
function rmdirRecursive(dir, cb) {
  // check arguments
  if (typeof dir !== 'string') {
    throw new Error('rmdirRecursive: directory path required');
  }

  if (cb !== undefined && typeof cb !== 'function') {
    throw new Error('rmdirRecursive: callback must be function');
  }

  var ctx = this, called, results;

  fs.exists(dir, function existsCallback(exists) {

    // already removed? then nothing to do
    if (!exists) return rmdirRecursiveCallback(null);

    fs.stat(dir, function statCallback(err, stat) {

      if (err) return rmdirRecursiveCallback(err);

      if (!stat.isDirectory())
        return fs.unlink(dir, rmdirRecursiveCallback);

      var files = fs.readdir(dir, readdirCallback);

    }); // fs.stat callback...

    // fs.readdir callback...
    function readdirCallback(err, files) {

      if (err) return rmdirRecursiveCallback(err);

      var n = files.length;
      if (n === 0) return fs.rmdir(dir, rmdirRecursiveCallback);

      files.forEach(function (name) {

        rmdirRecursive(path.resolve(dir, name), function (err) {

          if (err) return rmdirRecursiveCallback(err);

          if (--n === 0)
            return fs.rmdir(dir, rmdirRecursiveCallback);

        }); // rmdirRecursive

      }); // files.forEach

    } // readdirCallback

  }); // fs.exists

  // rmdirRecursiveCallback(err)
  function rmdirRecursiveCallback(err) {
    if (err && err.code === 'ENOENT') err = arguments[0] = null;

    if (!results) results = arguments;
    if (!cb || called) return;
    called = true;
    cb.apply(ctx, results);
  } // rmdirRecursiveCallback

  // return rmdirRecursiveYieldable
  return function rmdirRecursiveYieldable(fn) {
    if (!cb) cb = fn;
    if (!results || called) return;
    called = true;
    cb.apply(ctx, results);
  }; // rmdirRecursiveYieldable

} // rmdirRecursive


//######################################################################
/**
 * Function: remove directory recursively (sync)
 * Param   : dir: path to remove directory
 */
function rmdirRecursiveSync(dir) {
  // check arguments
  if (typeof dir !== 'string')
    throw new Error('rmdirRecursiveSync: directory path required');

  // already removed? then nothing to do
  if (!fs.existsSync(dir)) return;

  // is file? is not directory? then remove file
  try {
    var stat = fs.statSync(dir);
  } catch (err) {
    if (err.code === 'ENOENT') return;
    throw err;
  }
  if (!stat.isDirectory()) {
    try {
      return fs.unlinkSync(dir);
    } catch (err) {
      if (err.code === 'ENOENT') return;
      throw err;
    }
  }

  // remove all contents in it
  fs.readdirSync(dir).forEach(function (name) {
    rmdirRecursiveSync(path.resolve(dir, name));
  });

  try {
    return fs.rmdirSync(dir);
  } catch (err) {
    if (err.code === 'ENOENT') return;
    throw err;
  }
}


exports = module.exports   = rmdirRecursive;
exports.rmdirRecursive     = rmdirRecursive;
exports.rmdirRecursiveSync = rmdirRecursiveSync;
exports.sync               = rmdirRecursiveSync;

},{"fs":undefined,"path":undefined}],55:[function(require,module,exports){
/*!
 * Tmp
 *
 * Copyright (c) 2011-2015 KARASZI Istvan <github@spam.raszi.hu>
 *
 * MIT Licensed
 */

/**
 * Module dependencies.
 */
var
  fs     = require('fs'),
  path   = require('path'),
  os     = require('os'),
  crypto = require('crypto'),
  exists = fs.exists || path.exists,
  existsSync = fs.existsSync || path.existsSync,
  tmpDir = require('os-tmpdir'),
  _c     = require('constants');


/**
 * The working inner variables.
 */
var
  // store the actual TMP directory
  _TMP = tmpDir(),

  // the random characters to choose from
  RANDOM_CHARS = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',

  TEMPLATE_PATTERN = /XXXXXX/,

  DEFAULT_TRIES = 3,

  CREATE_FLAGS = _c.O_CREAT | _c.O_EXCL | _c.O_RDWR,

  DIR_MODE = 448 /* 0700 */,
  FILE_MODE = 384 /* 0600 */,

  // this will hold the objects need to be removed on exit
  _removeObjects = [],

  _gracefulCleanup = false,
  _uncaughtException = false;

/**
 * Random name generator based on crypto.
 * Adapted from http://blog.tompawlak.org/how-to-generate-random-values-nodejs-javascript
 *
 * @param {Number} howMany
 * @return {String}
 * @api private
 */
function _randomChars(howMany) {
  var
    value = [],
    rnd = null;

  // make sure that we do not fail because we ran out of entropy
  try {
    rnd = crypto.randomBytes(howMany);
  } catch (e) {
    rnd = crypto.pseudoRandomBytes(howMany);
  }

  for (var i = 0; i < howMany; i++) {
    value.push(RANDOM_CHARS[rnd[i] % RANDOM_CHARS.length]);
  }

  return value.join('');
}

/**
 * Checks whether the `obj` parameter is defined or not.
 *
 * @param {Object} obj
 * @return {Boolean}
 * @api private
 */
function _isUndefined(obj) {
  return typeof obj === 'undefined';
}

/**
 * Parses the function arguments.
 *
 * This function helps to have optional arguments.
 *
 * @param {Object} options
 * @param {Function} callback
 * @api private
 */
function _parseArguments(options, callback) {
  if (typeof options == 'function') {
    var
      tmp = options;
      options = callback || {};
      callback = tmp;
  } else if (typeof options == 'undefined') {
    options = {};
  }

  return [options, callback];
}

/**
 * Generates a new temporary name.
 *
 * @param {Object} opts
 * @returns {String}
 * @api private
 */
function _generateTmpName(opts) {
  if (opts.name) {
    return path.join(opts.dir || _TMP, opts.name);
  }

  // mkstemps like template
  if (opts.template) {
    return opts.template.replace(TEMPLATE_PATTERN, _randomChars(6));
  }

  // prefix and postfix
  var name = [
    opts.prefix || 'tmp-',
    process.pid,
    _randomChars(12),
    opts.postfix || ''
  ].join('');

  return path.join(opts.dir || _TMP, name);
}

/**
 * Gets a temporary file name.
 *
 * @param {Object} options
 * @param {Function} callback
 * @api private
 */
function _getTmpName(options, callback) {
  var
    args = _parseArguments(options, callback),
    opts = args[0],
    cb = args[1],
    tries = opts.tries || DEFAULT_TRIES;

  if (isNaN(tries) || tries < 0)
    return cb(new Error('Invalid tries'));

  if (opts.template && !opts.template.match(TEMPLATE_PATTERN))
    return cb(new Error('Invalid template provided'));

  (function _getUniqueName() {
    var name = _generateTmpName(opts);

    // check whether the path exists then retry if needed
    exists(name, function _pathExists(pathExists) {
      if (pathExists) {
        if (tries-- > 0) return _getUniqueName();

        return cb(new Error('Could not get a unique tmp filename, max tries reached ' + name));
      }

      cb(null, name);
    });
  }());
}

/**
 * Synchronous version of _getTmpName.
 *
 * @param {Object} options
 * @returns {String}
 * @api private
 */
function _getTmpNameSync(options) {
  var
    args = _parseArguments(options),
    opts = args[0],
    tries = opts.tries || DEFAULT_TRIES;

  if (isNaN(tries) || tries < 0)
    throw new Error('Invalid tries');

  if (opts.template && !opts.template.match(TEMPLATE_PATTERN))
    throw new Error('Invalid template provided');

  do {
    var name = _generateTmpName(opts);
    if (!existsSync(name)) {
      return name;
    }
  } while (tries-- > 0);

  throw new Error('Could not get a unique tmp filename, max tries reached');
}

/**
 * Creates and opens a temporary file.
 *
 * @param {Object} options
 * @param {Function} callback
 * @api public
 */
function _createTmpFile(options, callback) {
  var
    args = _parseArguments(options, callback),
    opts = args[0],
    cb = args[1];

    opts.postfix = (_isUndefined(opts.postfix)) ? '.tmp' : opts.postfix;

  // gets a temporary filename
  _getTmpName(opts, function _tmpNameCreated(err, name) {
    if (err) return cb(err);

    // create and open the file
    fs.open(name, CREATE_FLAGS, opts.mode || FILE_MODE, function _fileCreated(err, fd) {
      if (err) return cb(err);

      cb(null, name, fd, _prepareTmpFileRemoveCallback(name, fd, opts));
    });
  });
}

/**
 * Synchronous version of _createTmpFile.
 *
 * @param {Object} options
 * @returns {Object} object consists of name, fd and removeCallback
 * @api private
 */
function _createTmpFileSync(options) {
  var
    args = _parseArguments(options),
    opts = args[0];

    opts.postfix = opts.postfix || '.tmp';

  var name = _getTmpNameSync(opts);
  var fd = fs.openSync(name, CREATE_FLAGS, opts.mode || FILE_MODE);

  return {
    name : name,
    fd : fd,
    removeCallback : _prepareTmpFileRemoveCallback(name, fd, opts)
  };
}

/**
 * Removes files and folders in a directory recursively.
 *
 * @param {String} root
 * @api private
 */
function _rmdirRecursiveSync(root) {
  var dirs = [root];

  do {
    var
      dir = dirs.pop(),
      deferred = false,
      files = fs.readdirSync(dir);

    for (var i = 0, length = files.length; i < length; i++) {
      var
        file = path.join(dir, files[i]),
        stat = fs.lstatSync(file); // lstat so we don't recurse into symlinked directories

      if (stat.isDirectory()) {
        if (!deferred) {
          deferred = true;
          dirs.push(dir);
        }  
        dirs.push(file);
      } else {
        fs.unlinkSync(file);
      }
    }

    if (!deferred) {
      fs.rmdirSync(dir);
    }
  } while (dirs.length !== 0);
}

/**
 * Creates a temporary directory.
 *
 * @param {Object} options
 * @param {Function} callback
 * @api public
 */
function _createTmpDir(options, callback) {
  var
    args = _parseArguments(options, callback),
    opts = args[0],
    cb = args[1];

  // gets a temporary filename
  _getTmpName(opts, function _tmpNameCreated(err, name) {
    if (err) return cb(err);

    // create the directory
    fs.mkdir(name, opts.mode || DIR_MODE, function _dirCreated(err) {
      if (err) return cb(err);

      cb(null, name, _prepareTmpDirRemoveCallback(name, opts));
    });
  });
}

/**
 * Synchronous version of _createTmpDir.
 *
 * @param {Object} options
 * @returns {Object} object consists of name and removeCallback
 * @api private
 */
function _createTmpDirSync(options) {
  var
    args = _parseArguments(options),
    opts = args[0];

  var name = _getTmpNameSync(opts);
  fs.mkdirSync(name, opts.mode || DIR_MODE);

  return {
    name : name,
    removeCallback : _prepareTmpDirRemoveCallback(name, opts)
  };
}

/**
 * Prepares the callback for removal of the temporary file.
 *
 * @param {String} name
 * @param {int} fd
 * @param {Object} opts
 * @api private
 * @returns {Function} the callback
 */
function _prepareTmpFileRemoveCallback(name, fd, opts) {
  var removeCallback = _prepareRemoveCallback(function _removeCallback(fdPath) {
    try {
      fs.closeSync(fdPath[0]);
    }
    catch (e) {
      // under some node/windows related circumstances, a temporary file 
      // may have not be created as expected or the file was already closed
      // by the user, in which case we will simply ignore the error
      if (e.errno != -_c.EBADF && e.errno != -c.ENOENT) {
        // reraise any unanticipated error
        throw e;
      }
    }
    fs.unlinkSync(fdPath[1]);
  }, [fd, name]);

  if (!opts.keep) {
    _removeObjects.unshift(removeCallback);
  }

  return removeCallback;
}

/**
 * Prepares the callback for removal of the temporary directory.
 *
 * @param {String} name
 * @param {Object} opts
 * @returns {Function} the callback
 * @api private
 */
function _prepareTmpDirRemoveCallback(name, opts) {
  var removeFunction = opts.unsafeCleanup ? _rmdirRecursiveSync : fs.rmdirSync.bind(fs);
  var removeCallback = _prepareRemoveCallback(removeFunction, name);

  if (!opts.keep) {
    _removeObjects.unshift(removeCallback);
  }

  return removeCallback;
}

/**
 * Creates a guarded function wrapping the removeFunction call.
 *
 * @param {Function} removeFunction
 * @param {Object} arg
 * @returns {Function}
 * @api private
 */
function _prepareRemoveCallback(removeFunction, arg) {
  var called = false;

  return function _cleanupCallback() {
    if (called) return;

    var index = _removeObjects.indexOf(removeFunction);
    if (index >= 0) {
      _removeObjects.splice(index, 1);
    }

    called = true;
    removeFunction(arg);
  };
}

/**
 * The garbage collector.
 *
 * @api private
 */
function _garbageCollector() {
  if (_uncaughtException && !_gracefulCleanup) {
    return;
  }

  for (var i = 0, length = _removeObjects.length; i < length; i++) {
    try {
      _removeObjects[i].call(null);
    } catch (e) {
      // already removed?
    }
  }
}

function _setGracefulCleanup() {
  _gracefulCleanup = true;
}

var version = process.versions.node.split('.').map(function (value) {
  return parseInt(value, 10);
});

if (version[0] === 0 && (version[1] < 9 || version[1] === 9 && version[2] < 5)) {
  process.addListener('uncaughtException', function _uncaughtExceptionThrown(err) {
    _uncaughtException = true;
    _garbageCollector();

    throw err;
  });
}

process.addListener('exit', function _exit(code) {
  if (code) _uncaughtException = true;
  _garbageCollector();
});

// exporting all the needed methods
module.exports.tmpdir = _TMP;
module.exports.dir = _createTmpDir;
module.exports.dirSync = _createTmpDirSync;
module.exports.file = _createTmpFile;
module.exports.fileSync = _createTmpFileSync;
module.exports.tmpName = _getTmpName;
module.exports.tmpNameSync = _getTmpNameSync;
module.exports.setGracefulCleanup = _setGracefulCleanup;

},{"constants":undefined,"crypto":undefined,"fs":undefined,"os":undefined,"os-tmpdir":42,"path":undefined}],56:[function(require,module,exports){
'use strict';
module.exports = require('os-homedir')();

},{"os-homedir":40}],57:[function(require,module,exports){
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
'use strict';
var events_1 = require('./events');
var CancellationToken;
(function (CancellationToken) {
    CancellationToken.None = Object.freeze({
        isCancellationRequested: false,
        onCancellationRequested: events_1.Event.None
    });
    CancellationToken.Cancelled = Object.freeze({
        isCancellationRequested: true,
        onCancellationRequested: events_1.Event.None
    });
})(CancellationToken = exports.CancellationToken || (exports.CancellationToken = {}));
var shortcutEvent = Object.freeze(function (callback, context) {
    var handle = setTimeout(callback.bind(context), 0);
    return { dispose: function () { clearTimeout(handle); } };
});
var MutableToken = (function () {
    function MutableToken() {
        this._isCancelled = false;
    }
    MutableToken.prototype.cancel = function () {
        if (!this._isCancelled) {
            this._isCancelled = true;
            if (this._emitter) {
                this._emitter.fire(undefined);
                this._emitter = undefined;
            }
        }
    };
    Object.defineProperty(MutableToken.prototype, "isCancellationRequested", {
        get: function () {
            return this._isCancelled;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MutableToken.prototype, "onCancellationRequested", {
        get: function () {
            if (this._isCancelled) {
                return shortcutEvent;
            }
            if (!this._emitter) {
                this._emitter = new events_1.Emitter();
            }
            return this._emitter.event;
        },
        enumerable: true,
        configurable: true
    });
    return MutableToken;
})();
var CancellationTokenSource = (function () {
    function CancellationTokenSource() {
    }
    Object.defineProperty(CancellationTokenSource.prototype, "token", {
        get: function () {
            if (!this._token) {
                // be lazy and create the token only when
                // actually needed
                this._token = new MutableToken();
            }
            return this._token;
        },
        enumerable: true,
        configurable: true
    });
    CancellationTokenSource.prototype.cancel = function () {
        if (!this._token) {
            // save an object by returning the default
            // cancelled token when cancellation happens
            // before someone asks for the token
            this._token = CancellationToken.Cancelled;
        }
        else {
            this._token.cancel();
        }
    };
    CancellationTokenSource.prototype.dispose = function () {
        this.cancel();
    };
    return CancellationTokenSource;
})();
exports.CancellationTokenSource = CancellationTokenSource;

},{"./events":58}],58:[function(require,module,exports){
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
var Event;
(function (Event) {
    var _disposable = { dispose: function () { } };
    Event.None = function () { return _disposable; };
})(Event = exports.Event || (exports.Event = {}));
/**
 * Represents a type which can release resources, such
 * as event listening or a timer.
 */
var DisposableImpl = (function () {
    function DisposableImpl(callOnDispose) {
        this._callOnDispose = callOnDispose;
    }
    /**
     * Combine many disposable-likes into one. Use this method
     * when having objects with a dispose function which are not
     * instances of Disposable.
     *
     * @return Returns a new disposable which, upon dispose, will
     * dispose all provides disposable-likes.
     */
    DisposableImpl.from = function () {
        var disposables = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            disposables[_i - 0] = arguments[_i];
        }
        return new DisposableImpl(function () {
            if (disposables) {
                for (var _i = 0; _i < disposables.length; _i++) {
                    var disposable = disposables[_i];
                    disposable.dispose();
                }
                disposables = undefined;
            }
        });
    };
    /**
     * Dispose this object.
     */
    DisposableImpl.prototype.dispose = function () {
        if (typeof this._callOnDispose === 'function') {
            this._callOnDispose();
            this._callOnDispose = undefined;
        }
    };
    return DisposableImpl;
})();
var CallbackList = (function () {
    function CallbackList() {
    }
    CallbackList.prototype.add = function (callback, context, bucket) {
        var _this = this;
        if (context === void 0) { context = null; }
        if (!this._callbacks) {
            this._callbacks = [];
            this._contexts = [];
        }
        this._callbacks.push(callback);
        this._contexts.push(context);
        if (Array.isArray(bucket)) {
            bucket.push({ dispose: function () { return _this.remove(callback, context); } });
        }
    };
    CallbackList.prototype.remove = function (callback, context) {
        if (context === void 0) { context = null; }
        if (!this._callbacks) {
            return;
        }
        var foundCallbackWithDifferentContext = false;
        for (var i = 0, len = this._callbacks.length; i < len; i++) {
            if (this._callbacks[i] === callback) {
                if (this._contexts[i] === context) {
                    // callback & context match => remove it
                    this._callbacks.splice(i, 1);
                    this._contexts.splice(i, 1);
                    return;
                }
                else {
                    foundCallbackWithDifferentContext = true;
                }
            }
        }
        if (foundCallbackWithDifferentContext) {
            throw new Error('When adding a listener with a context, you should remove it with the same context');
        }
    };
    CallbackList.prototype.invoke = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i - 0] = arguments[_i];
        }
        if (!this._callbacks) {
            return;
        }
        var ret = [], callbacks = this._callbacks.slice(0), contexts = this._contexts.slice(0);
        for (var i = 0, len = callbacks.length; i < len; i++) {
            try {
                ret.push(callbacks[i].apply(contexts[i], args));
            }
            catch (e) {
                console.error(e);
            }
        }
        return ret;
    };
    CallbackList.prototype.isEmpty = function () {
        return !this._callbacks || this._callbacks.length === 0;
    };
    CallbackList.prototype.dispose = function () {
        this._callbacks = undefined;
        this._contexts = undefined;
    };
    return CallbackList;
})();
var Emitter = (function () {
    function Emitter(_options) {
        this._options = _options;
    }
    Object.defineProperty(Emitter.prototype, "event", {
        /**
         * For the public to allow to subscribe
         * to events from this Emitter
         */
        get: function () {
            var _this = this;
            if (!this._event) {
                this._event = function (listener, thisArgs, disposables) {
                    if (!_this._callbacks) {
                        _this._callbacks = new CallbackList();
                    }
                    if (_this._options && _this._options.onFirstListenerAdd && _this._callbacks.isEmpty()) {
                        _this._options.onFirstListenerAdd(_this);
                    }
                    _this._callbacks.add(listener, thisArgs);
                    var result;
                    result = {
                        dispose: function () {
                            _this._callbacks.remove(listener, thisArgs);
                            result.dispose = Emitter._noop;
                            if (_this._options && _this._options.onLastListenerRemove && _this._callbacks.isEmpty()) {
                                _this._options.onLastListenerRemove(_this);
                            }
                        }
                    };
                    if (Array.isArray(disposables)) {
                        disposables.push(result);
                    }
                    return result;
                };
            }
            return this._event;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * To be kept private to fire an event to
     * subscribers
     */
    Emitter.prototype.fire = function (event) {
        if (this._callbacks) {
            this._callbacks.invoke.call(this._callbacks, event);
        }
    };
    Emitter.prototype.dispose = function () {
        if (this._callbacks) {
            this._callbacks.dispose();
            this._callbacks = undefined;
        }
    };
    Emitter._noop = function () { };
    return Emitter;
})();
exports.Emitter = Emitter;

},{}],59:[function(require,module,exports){
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
var toString = Object.prototype.toString;
function defined(value) {
    return typeof value !== 'undefined';
}
exports.defined = defined;
function undefined(value) {
    return typeof value === 'undefined';
}
exports.undefined = undefined;
function nil(value) {
    return value === null;
}
exports.nil = nil;
function boolean(value) {
    return value === true || value === false;
}
exports.boolean = boolean;
function string(value) {
    return toString.call(value) === '[object String]';
}
exports.string = string;
function number(value) {
    return toString.call(value) === '[object Number]';
}
exports.number = number;
function error(value) {
    return toString.call(value) === '[object Error]';
}
exports.error = error;
function func(value) {
    return toString.call(value) === '[object Function]';
}
exports.func = func;
function array(value) {
    return Array.isArray(value);
}
exports.array = array;
function stringArray(value) {
    return array(value) && value.every(function (elem) { return string(elem); });
}
exports.stringArray = stringArray;

},{}],60:[function(require,module,exports){
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
var is = require('./is');
var messages_1 = require('./messages');
exports.ResponseError = messages_1.ResponseError;
exports.ErrorCodes = messages_1.ErrorCodes;
var messageReader_1 = require('./messageReader');
exports.StreamMessageReader = messageReader_1.StreamMessageReader;
exports.IPCMessageReader = messageReader_1.IPCMessageReader;
var messageWriter_1 = require('./messageWriter');
exports.StreamMessageWriter = messageWriter_1.StreamMessageWriter;
exports.IPCMessageWriter = messageWriter_1.IPCMessageWriter;
var events_1 = require('./events');
exports.Event = events_1.Event;
exports.Emitter = events_1.Emitter;
var cancellation_1 = require('./cancellation');
exports.CancellationTokenSource = cancellation_1.CancellationTokenSource;
exports.CancellationToken = cancellation_1.CancellationToken;
var CancelNotification;
(function (CancelNotification) {
    CancelNotification.type = { get method() { return '$/cancelRequest'; } };
})(CancelNotification || (CancelNotification = {}));
(function (Trace) {
    Trace[Trace["Off"] = 0] = "Off";
    Trace[Trace["Messages"] = 1] = "Messages";
    Trace[Trace["Verbose"] = 2] = "Verbose";
})(exports.Trace || (exports.Trace = {}));
var Trace = exports.Trace;
var Trace;
(function (Trace) {
    function fromString(value) {
        value = value.toLowerCase();
        switch (value) {
            case 'off':
                return Trace.Off;
            case 'messages':
                return Trace.Messages;
            case 'verbose':
                return Trace.Verbose;
            default:
                return Trace.Off;
        }
    }
    Trace.fromString = fromString;
})(Trace = exports.Trace || (exports.Trace = {}));
var ConnectionState;
(function (ConnectionState) {
    ConnectionState[ConnectionState["Active"] = 1] = "Active";
    ConnectionState[ConnectionState["Closed"] = 2] = "Closed";
})(ConnectionState || (ConnectionState = {}));
function createMessageConnection(messageReader, messageWriter, logger, client) {
    if (client === void 0) { client = false; }
    var sequenceNumber = 0;
    var version = '2.0';
    var requestHandlers = Object.create(null);
    var eventHandlers = Object.create(null);
    var responsePromises = Object.create(null);
    var requestTokens = Object.create(null);
    var trace = Trace.Off;
    var tracer;
    var state = ConnectionState.Active;
    var errorEmitter = new events_1.Emitter();
    var closeEmitter = new events_1.Emitter();
    function closeHandler() {
        if (state !== ConnectionState.Closed) {
            state = ConnectionState.Closed;
            closeEmitter.fire(undefined);
        }
    }
    ;
    function readErrorHandler(error) {
        errorEmitter.fire([error, undefined, undefined]);
    }
    function writeErrorHandler(data) {
        errorEmitter.fire(data);
    }
    messageReader.onClose(closeHandler);
    messageReader.onError(readErrorHandler);
    messageWriter.onClose(closeHandler);
    messageWriter.onError(writeErrorHandler);
    function handleRequest(requestMessage) {
        function reply(resultOrError) {
            var message = {
                jsonrpc: version,
                id: requestMessage.id
            };
            if (resultOrError instanceof messages_1.ResponseError) {
                message.error = resultOrError.toJson();
            }
            else {
                message.result = is.undefined(resultOrError) ? null : resultOrError;
            }
            messageWriter.write(message);
        }
        function replyError(error) {
            var message = {
                jsonrpc: version,
                id: requestMessage.id,
                error: error.toJson()
            };
            messageWriter.write(message);
        }
        function replySuccess(result) {
            // The JSON RPC defines that a response must either have a result or an error
            // So we can't treat undefined as a valid response result.
            if (is.undefined(result)) {
                result = null;
            }
            var message = {
                jsonrpc: version,
                id: requestMessage.id,
                result: result
            };
            messageWriter.write(message);
        }
        var requestHandler = requestHandlers[requestMessage.method];
        if (requestHandler) {
            var cancellationSource = new cancellation_1.CancellationTokenSource();
            var tokenKey = String(requestMessage.id);
            requestTokens[tokenKey] = cancellationSource;
            try {
                var handlerResult = requestHandler(requestMessage.params, cancellationSource.token);
                var promise = handlerResult;
                if (!handlerResult) {
                    delete requestTokens[tokenKey];
                    replySuccess(handlerResult);
                }
                else if (promise.then) {
                    promise.then(function (resultOrError) {
                        delete requestTokens[tokenKey];
                        reply(resultOrError);
                    }, function (error) {
                        delete requestTokens[tokenKey];
                        if (error instanceof messages_1.ResponseError) {
                            replyError(error);
                        }
                        else if (error && is.string(error.message)) {
                            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, "Request " + requestMessage.method + " failed with message: " + error.message));
                        }
                        else {
                            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, "Request " + requestMessage.method + " failed unexpectedly without providing any details."));
                        }
                    });
                }
                else {
                    delete requestTokens[tokenKey];
                    reply(handlerResult);
                }
            }
            catch (error) {
                delete requestTokens[tokenKey];
                if (error instanceof messages_1.ResponseError) {
                    reply(error);
                }
                else if (error && is.string(error.message)) {
                    replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, "Request " + requestMessage.method + " failed with message: " + error.message));
                }
                else {
                    replyError(new messages_1.ResponseError(messages_1.ErrorCodes.InternalError, "Request " + requestMessage.method + " failed unexpectedly without providing any details."));
                }
            }
        }
        else {
            replyError(new messages_1.ResponseError(messages_1.ErrorCodes.MethodNotFound, "Unhandled method " + requestMessage.method));
        }
    }
    function handleResponse(responseMessage) {
        var key = String(responseMessage.id);
        var responsePromise = responsePromises[key];
        if (trace != Trace.Off && tracer) {
            traceResponse(responseMessage, responsePromise);
        }
        if (responsePromise) {
            delete responsePromises[key];
            try {
                if (is.defined(responseMessage.error)) {
                    responsePromise.reject(responseMessage.error);
                }
                else if (is.defined(responseMessage.result)) {
                    responsePromise.resolve(responseMessage.result);
                }
                else {
                    throw new Error('Should never happen.');
                }
            }
            catch (error) {
                if (error.message) {
                    logger.error("Response handler '" + responsePromise.method + "' failed with message: " + error.message);
                }
                else {
                    logger.error("Response handler '" + responsePromise.method + "' failed unexpectedly.");
                }
            }
        }
    }
    function handleNotification(message) {
        var eventHandler;
        if (message.method === CancelNotification.type.method) {
            eventHandler = function (params) {
                var id = params.id;
                var source = requestTokens[String(id)];
                if (source) {
                    source.cancel();
                }
            };
        }
        else {
            eventHandler = eventHandlers[message.method];
        }
        if (eventHandler) {
            try {
                if (trace != Trace.Off && tracer) {
                    traceReceivedNotification(message);
                }
                eventHandler(message.params);
            }
            catch (error) {
                if (error.message) {
                    logger.error("Notification handler '" + message.method + "' failed with message: " + error.message);
                }
                else {
                    logger.error("Notification handler '" + message.method + "' failed unexpectedly.");
                }
            }
        }
    }
    function handleInvalidMessage(message) {
        if (!message) {
            logger.error('Received empty message.');
            return;
        }
        logger.error("Recevied message which is neither a response nor a notification message:\n" + JSON.stringify(message, null, 4));
        // Test whether we find an id to reject the promise
        var responseMessage = message;
        if (is.string(responseMessage.id) || is.number(responseMessage.id)) {
            var key = String(responseMessage.id);
            var responseHandler = responsePromises[key];
            if (responseHandler) {
                responseHandler.reject(new Error('The received response has neither a result nor an error property.'));
            }
        }
    }
    function traceRequest(message) {
        tracer.log("[" + (new Date().toLocaleTimeString()) + "] Sending request '" + message.method + " - (" + message.id + ")'.");
        if (trace === Trace.Verbose && message.params) {
            tracer.log("Params: " + JSON.stringify(message.params, null, 4) + "\n\n");
        }
    }
    function traceSendNotification(message) {
        tracer.log("[" + (new Date().toLocaleTimeString()) + "] Sending notification '" + message.method + "'.");
        if (trace === Trace.Verbose) {
            if (message.params) {
                tracer.log("Params: " + JSON.stringify(message.params, null, 4) + "\n\n");
            }
            else {
                tracer.log('No parameters provided.\n\n');
            }
        }
    }
    function traceReceivedNotification(message) {
        tracer.log("[" + (new Date().toLocaleTimeString()) + "] Received notification '" + message.method + "'.");
        if (trace === Trace.Verbose) {
            if (message.params) {
                tracer.log("Params: " + JSON.stringify(message.params, null, 4) + "\n\n");
            }
            else {
                tracer.log('No parameters provided.\n\n');
            }
        }
    }
    function traceResponse(message, responsePromise) {
        if (responsePromise) {
            var error = message.error ? " Request failed: " + message.error.message + " (" + message.error.code + ")." : '';
            tracer.log("[" + (new Date().toLocaleTimeString()) + "] Recevied response '" + responsePromise.method + " - (" + message.id + ")' in " + (Date.now() - responsePromise.timerStart) + "ms." + error);
        }
        else {
            tracer.log("[" + (new Date().toLocaleTimeString()) + "] Recevied response " + message.id + " without active response promise.");
        }
        if (trace === Trace.Verbose) {
            if (message.error && message.error.data) {
                tracer.log("Error data: " + JSON.stringify(message.error.data, null, 4) + "\n\n");
            }
            else {
                if (message.result) {
                    tracer.log("Result: " + JSON.stringify(message.result, null, 4) + "\n\n");
                }
                else {
                    tracer.log('No result returned.\n\n');
                }
            }
        }
    }
    var callback = function (message) {
        if (messages_1.isRequestMessage(message)) {
            handleRequest(message);
        }
        else if (messages_1.isReponseMessage(message)) {
            handleResponse(message);
        }
        else if (messages_1.isNotificationMessage(message)) {
            handleNotification(message);
        }
        else {
            handleInvalidMessage(message);
        }
    };
    var connection = {
        sendNotification: function (type, params) {
            var notificatioMessage = {
                jsonrpc: version,
                method: type.method,
                params: params
            };
            if (trace != Trace.Off && tracer) {
                traceSendNotification(notificatioMessage);
            }
            messageWriter.write(notificatioMessage);
        },
        onNotification: function (type, handler) {
            eventHandlers[type.method] = handler;
        },
        sendRequest: function (type, params, token) {
            var id = sequenceNumber++;
            var result = new Promise(function (resolve, reject) {
                var requestMessage = {
                    jsonrpc: version,
                    id: id,
                    method: type.method,
                    params: params
                };
                var responsePromise = { method: type.method, timerStart: Date.now(), resolve: resolve, reject: reject };
                if (trace != Trace.Off && tracer) {
                    traceRequest(requestMessage);
                }
                try {
                    messageWriter.write(requestMessage);
                }
                catch (e) {
                    // Writing the message failed. So we need to reject the promise.
                    responsePromise.reject(new messages_1.ResponseError(messages_1.ErrorCodes.MessageWriteError, e.message ? e.message : 'Unknown reason'));
                    responsePromise = null;
                }
                if (responsePromise) {
                    responsePromises[String(id)] = responsePromise;
                }
            });
            if (token) {
                token.onCancellationRequested(function (event) {
                    connection.sendNotification(CancelNotification.type, { id: id });
                });
            }
            return result;
        },
        onRequest: function (type, handler) {
            requestHandlers[type.method] = handler;
        },
        trace: function (_value, _tracer) {
            trace = _value;
            if (trace === Trace.Off) {
                tracer = null;
            }
            else {
                tracer = _tracer;
            }
        },
        onError: errorEmitter.event,
        onClose: closeEmitter.event,
        dispose: function () {
        },
        listen: function () {
            messageReader.listen(callback);
        }
    };
    return connection;
}
function isMessageReader(value) {
    return is.defined(value.listen) && is.undefined(value.read);
}
function isMessageWriter(value) {
    return is.defined(value.write) && is.undefined(value.end);
}
function createServerMessageConnection(input, output, logger) {
    var reader = isMessageReader(input) ? input : new messageReader_1.StreamMessageReader(input);
    var writer = isMessageWriter(output) ? output : new messageWriter_1.StreamMessageWriter(output);
    return createMessageConnection(reader, writer, logger);
}
exports.createServerMessageConnection = createServerMessageConnection;
function createClientMessageConnection(input, output, logger) {
    var reader = isMessageReader(input) ? input : new messageReader_1.StreamMessageReader(input);
    var writer = isMessageWriter(output) ? output : new messageWriter_1.StreamMessageWriter(output);
    return createMessageConnection(reader, writer, logger, true);
}
exports.createClientMessageConnection = createClientMessageConnection;

},{"./cancellation":57,"./events":58,"./is":59,"./messageReader":61,"./messageWriter":62,"./messages":63}],61:[function(require,module,exports){
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var events_1 = require('./events');
var is = require('./is');
var DefaultSize = 8192;
var CR = new Buffer('\r', 'ascii')[0];
var LF = new Buffer('\n', 'ascii')[0];
var CRLF = '\r\n';
var MessageBuffer = (function () {
    function MessageBuffer(encoding) {
        if (encoding === void 0) { encoding = 'utf-8'; }
        this.encoding = encoding;
        this.index = 0;
        this.buffer = new Buffer(DefaultSize);
    }
    MessageBuffer.prototype.append = function (chunk) {
        var toAppend = chunk;
        if (typeof (chunk) == 'string') {
            var str = chunk;
            toAppend = new Buffer(str.length);
            toAppend.write(str, 0, str.length, this.encoding);
        }
        if (this.buffer.length - this.index >= toAppend.length) {
            toAppend.copy(this.buffer, this.index, 0, toAppend.length);
        }
        else {
            var newSize = (Math.ceil((this.index + toAppend.length) / DefaultSize) + 1) * DefaultSize;
            if (this.index === 0) {
                this.buffer = new Buffer(newSize);
                toAppend.copy(this.buffer, 0, 0, toAppend.length);
            }
            else {
                this.buffer = Buffer.concat([this.buffer.slice(0, this.index), toAppend], newSize);
            }
        }
        this.index += toAppend.length;
    };
    MessageBuffer.prototype.tryReadHeaders = function () {
        var result = undefined;
        var current = 0;
        while (current + 3 < this.index && (this.buffer[current] !== CR || this.buffer[current + 1] !== LF || this.buffer[current + 2] !== CR || this.buffer[current + 3] !== LF)) {
            current++;
        }
        // No header / body separator found (e.g CRLFCRLF)
        if (current + 3 >= this.index) {
            return result;
        }
        result = Object.create(null);
        var headers = this.buffer.toString('ascii', 0, current).split(CRLF);
        headers.forEach(function (header) {
            var index = header.indexOf(':');
            if (index === -1) {
                throw new Error('Message header must separate key and value using :');
            }
            var key = header.substr(0, index);
            var value = header.substr(index + 1).trim();
            result[key] = value;
        });
        var nextStart = current + 4;
        this.buffer = this.buffer.slice(nextStart);
        this.index = this.index - nextStart;
        return result;
    };
    MessageBuffer.prototype.tryReadContent = function (length) {
        if (this.index < length) {
            return null;
        }
        var result = this.buffer.toString(this.encoding, 0, length);
        var nextStart = length;
        this.buffer.copy(this.buffer, 0, nextStart);
        this.index = this.index - nextStart;
        return result;
    };
    Object.defineProperty(MessageBuffer.prototype, "numberOfBytes", {
        get: function () {
            return this.index;
        },
        enumerable: true,
        configurable: true
    });
    return MessageBuffer;
})();
var AbstractMessageReader = (function () {
    function AbstractMessageReader() {
        this.errorEmitter = new events_1.Emitter();
        this.closeEmitter = new events_1.Emitter();
    }
    Object.defineProperty(AbstractMessageReader.prototype, "onError", {
        get: function () {
            return this.errorEmitter.event;
        },
        enumerable: true,
        configurable: true
    });
    AbstractMessageReader.prototype.fireError = function (error) {
        this.errorEmitter.fire(this.asError(error));
    };
    Object.defineProperty(AbstractMessageReader.prototype, "onClose", {
        get: function () {
            return this.closeEmitter.event;
        },
        enumerable: true,
        configurable: true
    });
    AbstractMessageReader.prototype.fireClose = function () {
        this.closeEmitter.fire(undefined);
    };
    AbstractMessageReader.prototype.asError = function (error) {
        if (error instanceof Error) {
            return error;
        }
        else {
            return new Error("Reader recevied error. Reason: " + (is.string(error.message) ? error.message : 'unknown'));
        }
    };
    return AbstractMessageReader;
})();
exports.AbstractMessageReader = AbstractMessageReader;
var StreamMessageReader = (function (_super) {
    __extends(StreamMessageReader, _super);
    function StreamMessageReader(readable, encoding) {
        if (encoding === void 0) { encoding = 'utf-8'; }
        _super.call(this);
        this.readable = readable;
        this.buffer = new MessageBuffer(encoding);
    }
    StreamMessageReader.prototype.listen = function (callback) {
        var _this = this;
        this.nextMessageLength = -1;
        this.callback = callback;
        this.readable.on('data', function (data) {
            _this.onData(data);
        });
        this.readable.on('error', function (error) { return _this.fireError(error); });
        this.readable.on('close', function () { return _this.fireClose(); });
    };
    StreamMessageReader.prototype.onData = function (data) {
        this.buffer.append(data);
        while (true) {
            if (this.nextMessageLength === -1) {
                var headers = this.buffer.tryReadHeaders();
                if (!headers) {
                    return;
                }
                var contentLength = headers['Content-Length'];
                if (!contentLength) {
                    throw new Error('Header must provide a Content-Length property.');
                }
                var length_1 = parseInt(contentLength);
                if (isNaN(length_1)) {
                    throw new Error('Content-Length value must be a number.');
                }
                this.nextMessageLength = length_1;
            }
            var msg = this.buffer.tryReadContent(this.nextMessageLength);
            if (msg === null) {
                return;
            }
            this.nextMessageLength = -1;
            var json = JSON.parse(msg);
            this.callback(json);
        }
    };
    return StreamMessageReader;
})(AbstractMessageReader);
exports.StreamMessageReader = StreamMessageReader;
var IPCMessageReader = (function (_super) {
    __extends(IPCMessageReader, _super);
    function IPCMessageReader(process) {
        var _this = this;
        _super.call(this);
        this.process = process;
        this.process.on('error', function (error) { return _this.fireError(error); });
        this.process.on('close', function () { return _this.fireClose(); });
    }
    IPCMessageReader.prototype.listen = function (callback) {
        this.process.on('message', callback);
    };
    return IPCMessageReader;
})(AbstractMessageReader);
exports.IPCMessageReader = IPCMessageReader;

},{"./events":58,"./is":59}],62:[function(require,module,exports){
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var events_1 = require('./events');
var is = require('./is');
var ContentLength = 'Content-Length: ';
var CRLF = '\r\n';
var AbstractMessageWriter = (function () {
    function AbstractMessageWriter() {
        this.errorEmitter = new events_1.Emitter();
        this.closeEmitter = new events_1.Emitter();
    }
    Object.defineProperty(AbstractMessageWriter.prototype, "onError", {
        get: function () {
            return this.errorEmitter.event;
        },
        enumerable: true,
        configurable: true
    });
    AbstractMessageWriter.prototype.fireError = function (error, message, count) {
        this.errorEmitter.fire([this.asError(error), message, count]);
    };
    Object.defineProperty(AbstractMessageWriter.prototype, "onClose", {
        get: function () {
            return this.closeEmitter.event;
        },
        enumerable: true,
        configurable: true
    });
    AbstractMessageWriter.prototype.fireClose = function () {
        this.closeEmitter.fire(undefined);
    };
    AbstractMessageWriter.prototype.asError = function (error) {
        if (error instanceof Error) {
            return error;
        }
        else {
            return new Error("Writer recevied error. Reason: " + (is.string(error.message) ? error.message : 'unknown'));
        }
    };
    return AbstractMessageWriter;
})();
exports.AbstractMessageWriter = AbstractMessageWriter;
var StreamMessageWriter = (function (_super) {
    __extends(StreamMessageWriter, _super);
    function StreamMessageWriter(writable, encoding) {
        var _this = this;
        if (encoding === void 0) { encoding = 'utf8'; }
        _super.call(this);
        this.writable = writable;
        this.encoding = encoding;
        this.errorCount = 0;
        this.writable.on('error', function (error) { return _this.fireError(error); });
        this.writable.on('close', function () { return _this.fireClose(); });
    }
    StreamMessageWriter.prototype.write = function (msg) {
        var json = JSON.stringify(msg);
        var contentLength = Buffer.byteLength(json, this.encoding);
        var headers = [
            ContentLength, contentLength.toString(), CRLF,
            CRLF
        ];
        try {
            // Header must be written in ASCII encoding
            this.writable.write(headers.join(''), 'ascii');
            // Now write the content. This can be written in any encoding
            this.writable.write(json, this.encoding);
            this.errorCount = 0;
        }
        catch (error) {
            this.errorCount++;
            this.fireError(error, msg, this.errorCount);
        }
    };
    return StreamMessageWriter;
})(AbstractMessageWriter);
exports.StreamMessageWriter = StreamMessageWriter;
var IPCMessageWriter = (function (_super) {
    __extends(IPCMessageWriter, _super);
    function IPCMessageWriter(process) {
        var _this = this;
        _super.call(this);
        this.process = process;
        this.errorCount = 0;
        this.process.on('error', function (error) { return _this.fireError(error); });
        this.process.on('close', function () { return _this.fireClose; });
    }
    IPCMessageWriter.prototype.write = function (msg) {
        try {
            this.process.send(msg);
            this.errorCount = 0;
        }
        catch (error) {
            this.errorCount++;
            this.fireError(error, msg, this.errorCount);
        }
    };
    return IPCMessageWriter;
})(AbstractMessageWriter);
exports.IPCMessageWriter = IPCMessageWriter;

},{"./events":58,"./is":59}],63:[function(require,module,exports){
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var is = require('./is');
/**
 * Predefined error codes.
 */
var ErrorCodes;
(function (ErrorCodes) {
    // Defined by JSON RPC
    ErrorCodes.ParseError = -32700;
    ErrorCodes.InvalidRequest = -32600;
    ErrorCodes.MethodNotFound = -32601;
    ErrorCodes.InvalidParams = -32602;
    ErrorCodes.InternalError = -32603;
    ErrorCodes.serverErrorStart = -32099;
    ErrorCodes.serverErrorEnd = -32000;
    // Defined by VSCode.
    ErrorCodes.MessageWriteError = 1;
    ErrorCodes.MessageReadError = 2;
})(ErrorCodes = exports.ErrorCodes || (exports.ErrorCodes = {}));
/**
 * A error object return in a response in case a request
 * has failed.
 */
var ResponseError = (function (_super) {
    __extends(ResponseError, _super);
    function ResponseError(code, message, data) {
        _super.call(this, message);
        this.code = code;
        this.message = message;
        if (is.defined(data)) {
            this.data = data;
        }
    }
    ResponseError.prototype.toJson = function () {
        var result = {
            code: this.code,
            message: this.message
        };
        if (is.defined(this.data)) {
            result.data = this.data;
        }
        ;
        return result;
    };
    return ResponseError;
})(Error);
exports.ResponseError = ResponseError;
/**
 * Tests if the given message is a request message
 */
function isRequestMessage(message) {
    var candidate = message;
    return candidate && is.string(candidate.method) && (is.string(candidate.id) || is.number(candidate.id));
}
exports.isRequestMessage = isRequestMessage;
/**
 * Tests if the given message is a notification message
 */
function isNotificationMessage(message) {
    var candidate = message;
    return candidate && is.string(candidate.method) && is.undefined(message.id);
}
exports.isNotificationMessage = isNotificationMessage;
/**
 * Tests if the given message is a response message
 */
function isReponseMessage(message) {
    var candidate = message;
    return candidate && (is.defined(candidate.result) || is.defined(candidate.error)) && (is.string(candidate.id) || is.number(candidate.id));
}
exports.isReponseMessage = isReponseMessage;

},{"./is":59}],64:[function(require,module,exports){
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
'use strict';
var path = require('path');
var fs = require('fs');
var _options = { locale: undefined, cacheLanguageResolution: true };
var _isPseudo = false;
var _resolvedLanguage = null;
var toString = Object.prototype.toString;
function isDefined(value) {
    return typeof value !== 'undefined';
}
function isNumber(value) {
    return toString.call(value) === '[object Number]';
}
function isString(value) {
    return toString.call(value) === '[object String]';
}
function isBoolean(value) {
    return value === true || value === false;
}
function format(message, args) {
    var result;
    if (_isPseudo) {
        // FF3B and FF3D is the Unicode zenkaku representation for [ and ]
        message = '\uFF3B' + message.replace(/[aouei]/g, '$&$&') + '\uFF3D';
    }
    if (args.length === 0) {
        result = message;
    }
    else {
        result = message.replace(/\{(\d+)\}/g, function (match, rest) {
            var index = rest[0];
            return typeof args[index] !== 'undefined' ? args[index] : match;
        });
    }
    return result;
}
function createScopedLocalizeFunction(messages) {
    return function (key, message) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        if (isNumber(key)) {
            if (key >= messages.length) {
                console.error("Broken localize call found. Index out of bounds. Stacktrace is\n: " + (new Error('')).stack);
                return;
            }
            return format(messages[key], args);
        }
        else {
            if (isString(message)) {
                console.warn("Message " + message + " didn't get externalized correctly.");
                return format(message, args);
            }
            else {
                console.error("Broken localize call found. Stacktrace is\n: " + (new Error('')).stack);
            }
        }
    };
}
function localize(key, message) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    return format(message, args);
}
function resolveLanguage(file) {
    var ext = path.extname(file);
    if (ext) {
        file = file.substr(0, file.length - ext.length);
    }
    var resolvedLanguage;
    if (_options.cacheLanguageResolution && _resolvedLanguage) {
        resolvedLanguage = _resolvedLanguage;
    }
    else {
        if (_isPseudo || !_options.locale) {
            resolvedLanguage = '.nls.json';
        }
        else {
            var locale = _options.locale;
            while (locale) {
                var candidate = '.nls.' + locale + '.json';
                if (fs.existsSync(file + candidate)) {
                    resolvedLanguage = candidate;
                    break;
                }
                else {
                    var index = locale.lastIndexOf('-');
                    if (index > 0) {
                        locale = locale.substring(0, index);
                    }
                    else {
                        resolvedLanguage = '.nls.json';
                        locale = null;
                    }
                }
            }
        }
        if (_options.cacheLanguageResolution) {
            _resolvedLanguage = resolvedLanguage;
        }
    }
    return file + resolvedLanguage;
}
function loadMessageBundle(file) {
    if (!file) {
        return localize;
    }
    else {
        var resolvedFile = resolveLanguage(file);
        try {
            var json = require(resolvedFile);
            if (Array.isArray(json)) {
                return createScopedLocalizeFunction(json);
            }
            else {
                if (isDefined(json.messages) && isDefined(json.keys)) {
                    return createScopedLocalizeFunction(json.messages);
                }
                else {
                    console.error("String bundle '" + file + "' uses an unsupported format.");
                    return localize;
                }
            }
        }
        catch (e) {
            console.error("Can't load string bundle for " + file);
            return localize;
        }
    }
}
exports.loadMessageBundle = loadMessageBundle;
function config(opt) {
    var options;
    if (isString(opt)) {
        try {
            options = JSON.parse(opt);
        }
        catch (e) {
            console.error("Error parsing nls options: " + opt);
        }
    }
    else {
        options = opt;
    }
    if (options) {
        if (isString(options.locale)) {
            _options.locale = options.locale.toLowerCase();
            _resolvedLanguage = null;
        }
        if (isBoolean(options.cacheLanguageResolution)) {
            _options.cacheLanguageResolution = options.cacheLanguageResolution;
        }
    }
    _isPseudo = _options.locale === 'pseudo';
    return loadMessageBundle;
}
exports.config = config;

},{"fs":undefined,"path":undefined}],65:[function(require,module,exports){
// Returns a wrapper function that returns a wrapped callback
// The wrapper function should do some stuff, and return a
// presumably different callback function.
// This makes sure that own properties are retained, so that
// decorations and such are not lost along the way.
module.exports = wrappy
function wrappy (fn, cb) {
  if (fn && cb) return wrappy(fn)(cb)

  if (typeof fn !== 'function')
    throw new TypeError('need wrapper function')

  Object.keys(fn).forEach(function (k) {
    wrapper[k] = fn[k]
  })

  return wrapper

  function wrapper() {
    var args = new Array(arguments.length)
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i]
    }
    var ret = fn.apply(this, args)
    var cb = args[args.length-1]
    if (typeof ret === 'function' && ret !== cb) {
      Object.keys(cb).forEach(function (k) {
        ret[k] = cb[k]
      })
    }
    return ret
  }
}

},{}]},{},[10])
//# sourceMappingURL=hubController.all.js.map

// SIG // Begin signature block
// SIG // MIIiAAYJKoZIhvcNAQcCoIIh8TCCIe0CAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // I+UDT83pcIkIdWXG4EsNutVuQ9A1JmNJfUjQkh5e6y+g
// SIG // gguEMIIFDDCCA/SgAwIBAgITMwAAAU/nxmLJRvSpfwAA
// SIG // AAABTzANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDEwMB4XDTE2MTExNzIxNTkxNFoX
// SIG // DTE4MDIxNzIxNTkxNFowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBALSJkIp2DKzFPaG8gejXUAi7
// SIG // WmmnrsfMuFu9OA8hUUYII9G9Iplztyjv9werK/lI96UU
// SIG // BalNJBttYZacg50zwCx5mfBd8+zVRN+lzVn6dq0GP8ZK
// SIG // A+bqLZQQwmZv/WLQUIrRIpEjl2U0ocSaAl6S4rh8KHjC
// SIG // XuNG98rvOFeIrFYGWMqYG8eo1142rppFMOO2tz0Ywqcn
// SIG // sHlNU9gy5najUCr2P7q7QR4khk2Ym3qe9izivJBgZfuW
// SIG // afrgE2jiiSoudRidwm24IfSZXip/MaCnDczvTxFu/klC
// SIG // TmHeN8srnkDvzqtecAhzpXJ7t0bOWzJTXYo5UW+w16h4
// SIG // 3aMob17uQh8CAwEAAaOCAXswggF3MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjc9BgEGCCsGAQUFBwMDMB0GA1UdDgQWBBSS
// SIG // DqERcbYvVQ3DD/TJXHQuWgxqvzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwODY1
// SIG // K2I0YjEyODc4LWUyOTMtNDNlOS1iMjFlLTdkMzA3MTlk
// SIG // NDUyZjAfBgNVHSMEGDAWgBTm/F97uyIAWORyTrX0IXQj
// SIG // MubvrDBWBgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3Js
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9N
// SIG // aWNDb2RTaWdQQ0FfMjAxMC0wNy0wNi5jcmwwWgYIKwYB
// SIG // BQUHAQEETjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY0NvZFNp
// SIG // Z1BDQV8yMDEwLTA3LTA2LmNydDAMBgNVHRMBAf8EAjAA
// SIG // MA0GCSqGSIb3DQEBCwUAA4IBAQARwLlqQzX+hbE4gA24
// SIG // dHUsjXFJuDxB7S294gY2kHYrieW2gemG4xiMlpMyQqen
// SIG // 9rc0JTnQxnpD6tt3cMzU6ULrqMVVAnV4ntgQvgcbypRj
// SIG // +zwPce7UVWfXKfZqvwe85Y+C6vih4nMzPxSSXqG6ZVc3
// SIG // RYWAXNYsxos8aoejBxHL7NlxOCA1JD1UvcxVifR3EJvl
// SIG // maoPrsY8jp/aAE/PfeGzwCD3UjH3IkjVYY1/JgIZfYPM
// SIG // YZMq3bjc4gizp9/hBHdgyPSsNcsx5Wx1UcU3exNqTpVr
// SIG // j0CeyE0+rr1ZxSDWwnitt2RbO9DAFXA0FOXFnqYcx/T/
// SIG // 9stIweKN827OqrSgMIIGcDCCBFigAwIBAgIKYQxSTAAA
// SIG // AAAAAzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3Qg
// SIG // Q2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAw
// SIG // NzA2MjA0MDE3WhcNMjUwNzA2MjA1MDE3WjB+MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQSAyMDEwMIIBIjANBgkqhkiG
// SIG // 9w0BAQEFAAOCAQ8AMIIBCgKCAQEA6Q5kUHlntcTj/QkA
// SIG // TJ6UrPdWaOpE2M/FWE+ppXZ8bUW60zmStKQe+fllguQX
// SIG // 0o/9RJwI6GWTzixVhL99COMuK6hBKxi3oktuSUxrFQfe
// SIG // 0dLCiR5xlM21f0u0rwjYzIjWaxeUOpPOJj/s5v40mFfV
// SIG // HV1J9rIqLtWFu1k/+JC0K4N0yiuzO0bj8EZJwRdmVMkc
// SIG // vR3EVWJXcvhnuSUgNN5dpqWVXqsogM3Vsp7lA7Vj07IU
// SIG // yMHIiiYKWX8H7P8O7YASNUwSpr5SW/Wm2uCLC0h31oVH
// SIG // 1RC5xuiq7otqLQVcYMa0KlucIxxfReMaFB5vN8sZM4Bq
// SIG // iU2jamZjeJPVMM+VHwIDAQABo4IB4zCCAd8wEAYJKwYB
// SIG // BAGCNxUBBAMCAQAwHQYDVR0OBBYEFOb8X3u7IgBY5HJO
// SIG // tfQhdCMy5u+sMBkGCSsGAQQBgjcUAgQMHgoAUwB1AGIA
// SIG // QwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/
// SIG // MB8GA1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjE
// SIG // MFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
// SIG // b0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcB
// SIG // AQROMEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2VyQXV0
// SIG // XzIwMTAtMDYtMjMuY3J0MIGdBgNVHSAEgZUwgZIwgY8G
// SIG // CSsGAQQBgjcuAzCBgTA9BggrBgEFBQcCARYxaHR0cDov
// SIG // L3d3dy5taWNyb3NvZnQuY29tL1BLSS9kb2NzL0NQUy9k
// SIG // ZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUA
// SIG // ZwBhAGwAXwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBt
// SIG // AGUAbgB0AC4gHTANBgkqhkiG9w0BAQsFAAOCAgEAGnTv
// SIG // V08pe8QWhXi4UNMi/AmdrIKX+DT/KiyXlRLl5L/Pv5PI
// SIG // 4zSp24G43B4AvtI1b6/lf3mVd+UC1PHr2M1OHhthosJa
// SIG // IxrwjKhiUUVnCOM/PB6T+DCFF8g5QKbXDrMhKeWloWmM
// SIG // IpPMdJjnoUdD8lOswA8waX/+0iUgbW9h098H1dlyACxp
// SIG // hnY9UdumOUjJN2FtB91TGcun1mHCv+KDqw/ga5uV1n0o
// SIG // UbCJSlGkmmzItx9KGg5pqdfcwX7RSXCqtq27ckdjF/qm
// SIG // 1qKmhuyoEESbY7ayaYkGx0aGehg/6MUdIdV7+QIjLcVB
// SIG // y78dTMgW77Gcf/wiS0mKbhXjpn92W9FTeZGFndXS2z1z
// SIG // NfM8rlSyUkdqwKoTldKOEdqZZ14yjPs3hdHcdYWch8Za
// SIG // V4XCv90Nj4ybLeu07s8n07VeafqkFgQBpyRnc89NT7be
// SIG // BVaXevfpUk30dwVPhcbYC/GO7UIJ0Q124yNWeCImNr7K
// SIG // sYxuqh3khdpHM2KPpMmRM19xHkCvmGXJIuhCISWKHC1g
// SIG // 2TeJQYkqFg/XYTyUaGBS79ZHmaCAQO4VgXc+nOBTGBpQ
// SIG // HTiVmx5mMxMnORd4hzbOTsNfsvU9R1O24OXbC2E9KteS
// SIG // LM43Wj5AQjGkHxAIwlacvyRdUQKdannSF9PawZSOB3sl
// SIG // cUSrBmrm1MbfI5qWdcUxghXUMIIV0AIBATCBlTB+MQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3Nv
// SIG // ZnQgQ29kZSBTaWduaW5nIFBDQSAyMDEwAhMzAAABT+fG
// SIG // YslG9Kl/AAAAAAFPMA0GCWCGSAFlAwQCAQUAoIHAMBkG
// SIG // CSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQB
// SIG // gjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJ
// SIG // BDEiBCBfK3Xv2PsFUQ3o4Yd2lPOnaq6VI9oEKZ0tKMXq
// SIG // IMf9XTBUBgorBgEEAYI3AgEMMUYwRKAqgCgAaAB1AGIA
// SIG // QwBvAG4AdAByAG8AbABsAGUAcgAuAGEAbABsAC4AagBz
// SIG // oRaAFGh0dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqGSIb3
// SIG // DQEBAQUABIIBAJrpQzXLhE5M7oP8fgXHlJeLH28lLDdY
// SIG // Yl9Vo6z5kpoZsjvouBAkGrucZmOs2cdaQy+vBmfxH+j3
// SIG // 0T4fsbSRAVo5/Y3o1v4EED/fnBmwkR2Pu1ptw3f8doWZ
// SIG // NxQjghul59LlFdP07ywqO6Ih3BZYUjXO6vTCf9MqpO9F
// SIG // /RMa1YLfkRkZRl4N4fE29+2brCkjEWyptxVSvnNFjvcc
// SIG // JeJ5GwkoI3R3ASxmDk6WQ4vKj3LrVHG6M/se9gUgOVXk
// SIG // 3oedFtBnSZXPrOKvaXtLVaxKTDTSyND3CwuXIFHSQf+5
// SIG // o7woeLXtIn+n7JAaj+bnze4NoyR55jOD6AGCIrLNal3D
// SIG // qHOhghNMMIITSAYKKwYBBAGCNwMDATGCEzgwghM0Bgkq
// SIG // hkiG9w0BBwKgghMlMIITIQIBAzEPMA0GCWCGSAFlAwQC
// SIG // AQUAMIIBPQYLKoZIhvcNAQkQAQSgggEsBIIBKDCCASQC
// SIG // AQEGCisGAQQBhFkKAwEwMTANBglghkgBZQMEAgEFAAQg
// SIG // 7yBMZ8fyIgII+NaAc7oP/zgE8WllS5G/wBQsdTnTnvAC
// SIG // Blg/MBoXXRgTMjAxNjEyMjgwMDQ1NTEuMjQyWjAHAgEB
// SIG // gAIB9KCBuaSBtjCBszELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEN
// SIG // MAsGA1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBE
// SIG // U0UgRVNOOjU4NDctRjc2MS00RjcwMSUwIwYDVQQDExxN
// SIG // aWNyb3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNloIIOzzCC
// SIG // BnEwggRZoAMCAQICCmEJgSoAAAAAAAIwDQYJKoZIhvcN
// SIG // AQELBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpX
// SIG // YXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYD
// SIG // VQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xMjAwBgNV
// SIG // BAMTKU1pY3Jvc29mdCBSb290IENlcnRpZmljYXRlIEF1
// SIG // dGhvcml0eSAyMDEwMB4XDTEwMDcwMTIxMzY1NVoXDTI1
// SIG // MDcwMTIxNDY1NVowfDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEm
// SIG // MCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENB
// SIG // IDIwMTAwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEK
// SIG // AoIBAQCpHQ28dxGKOiDs/BOX9fp/aZRrdFQQ1aUKAIKF
// SIG // ++18aEssX8XD5WHCdrc+Zitb8BVTJwQxH0EbGpUdzgkT
// SIG // jnxhMFmxMEQP8WCIhFRDDNdNuDgIs0Ldk6zWczBXJoKj
// SIG // RQ3Q6vVHgc2/JGAyWGBG8lhHhjKEHnRhZ5FfgVSxz5NM
// SIG // ksHEpl3RYRNuKMYa+YaAu99h/EbBJx0kZxJyGiGKr0tk
// SIG // iVBisV39dx898Fd1rL2KQk1AUdEPnAY+Z3/1ZsADlkR+
// SIG // 79BL/W7lmsqxqPJ6Kgox8NpOBpG2iAg16HgcsOmZzTzn
// SIG // L0S6p/TcZL2kAcEgCZN4zfy8wMlEXV4WnAEFTyJNAgMB
// SIG // AAGjggHmMIIB4jAQBgkrBgEEAYI3FQEEAwIBADAdBgNV
// SIG // HQ4EFgQU1WM6XIoxkPNDe3xGG8UzaFqFbVUwGQYJKwYB
// SIG // BAGCNxQCBAweCgBTAHUAYgBDAEEwCwYDVR0PBAQDAgGG
// SIG // MA8GA1UdEwEB/wQFMAMBAf8wHwYDVR0jBBgwFoAU1fZW
// SIG // y4/oolxiaNE9lJBb186aGMQwVgYDVR0fBE8wTTBLoEmg
// SIG // R4ZFaHR0cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9j
// SIG // cmwvcHJvZHVjdHMvTWljUm9vQ2VyQXV0XzIwMTAtMDYt
// SIG // MjMuY3JsMFoGCCsGAQUFBwEBBE4wTDBKBggrBgEFBQcw
// SIG // AoY+aHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraS9j
// SIG // ZXJ0cy9NaWNSb29DZXJBdXRfMjAxMC0wNi0yMy5jcnQw
// SIG // gaAGA1UdIAEB/wSBlTCBkjCBjwYJKwYBBAGCNy4DMIGB
// SIG // MD0GCCsGAQUFBwIBFjFodHRwOi8vd3d3Lm1pY3Jvc29m
// SIG // dC5jb20vUEtJL2RvY3MvQ1BTL2RlZmF1bHQuaHRtMEAG
// SIG // CCsGAQUFBwICMDQeMiAdAEwAZQBnAGEAbABfAFAAbwBs
// SIG // AGkAYwB5AF8AUwB0AGEAdABlAG0AZQBuAHQALiAdMA0G
// SIG // CSqGSIb3DQEBCwUAA4ICAQAH5ohRDeLG4Jg/gXEDPZ2j
// SIG // oSFvs+umzPUxvs8F4qn++ldtGTCzwsVmyWrf9efweL3H
// SIG // qJ4l4/m87WtUVwgrUYJEEvu5U4zM9GASinbMQEBBm9xc
// SIG // F/9c+V4XNZgkVkt070IQyK+/f8Z/8jd9Wj8c8pl5SpFS
// SIG // AK84Dxf1L3mBZdmptWvkx872ynoAb0swRCQiPM/tA6WW
// SIG // j1kpvLb9BOFwnzJKJ/1Vry/+tuWOM7tiX5rbV0Dp8c6Z
// SIG // ZpCM/2pif93FSguRJuI57BlKcWOdeyFtw5yjojz6f32W
// SIG // apB4pm3S4Zz5Hfw42JT0xqUKloakvZ4argRCg7i1gJsi
// SIG // OCC1JeVk7Pf0v35jWSUPei45V3aicaoGig+JFrphpxHL
// SIG // mtgOR5qAxdDNp9DvfYPw4TtxCd9ddJgiCGHasFAeb73x
// SIG // 4QDf5zEHpJM692VHeOj4qEir995yfmFrb3epgcunCaw5
// SIG // u+zGy9iCtHLNHfS4hQEegPsbiSpUObJb2sgNVZl6h3M7
// SIG // COaYLeqN4DMuEin1wC9UJyH3yKxO2ii4sanblrKnQqLJ
// SIG // zxlBTeCG+SqaoxFmMNO7dDJL32N79ZmKLxvHIa9Zta7c
// SIG // RDyXUHHXodLFVeNp3lfB0d4wwP3M5k37Db9dT+mdHhk4
// SIG // L7zPWAUu7w2gUDXa7wknHNWzfjUeCLraNtvTX4/edIhJ
// SIG // EjCCBNowggPCoAMCAQICEzMAAACzObvUEpMVqf4AAAAA
// SIG // ALMwDQYJKoZIhvcNAQELBQAwfDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3Rh
// SIG // bXAgUENBIDIwMTAwHhcNMTYwOTA3MTc1NjU4WhcNMTgw
// SIG // OTA3MTc1NjU4WjCBszELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEN
// SIG // MAsGA1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhlciBE
// SIG // U0UgRVNOOjU4NDctRjc2MS00RjcwMSUwIwYDVQQDExxN
// SIG // aWNyb3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNlMIIBIjAN
// SIG // BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnjZ5eN64
// SIG // L8wdSf1+KSJYmvZiWnvLOV296SVocCZ3yyiPXG81jqto
// SIG // 1xSpgHgCD2qywRGLX2SnaztEEveXipaEPd+qf2FpoogG
// SIG // zgn0ieaGZkGElDPB1iLzVFgA2j1e/rCjiaZn7I09btMs
// SIG // gX9oi93lSExDyQ5uG34NAsa6BWpbAtQOeysN86pXk5wS
// SIG // Q/EF8lgtjvjVBkxNxssrUbzJZITw9pVqlbAzWFPUDm51
// SIG // FSK+uLPNYFsEDQlemF0ACwsAcXJ3phHiMtDTtt2qVQWD
// SIG // xodBfD4a6iIUEBzozvCSrsv7jHeh68TH3v3x8DwQMabw
// SIG // fRLIZlqVsSMmyzX2NBhLqSK5tQIDAQABo4IBGzCCARcw
// SIG // HQYDVR0OBBYEFNNd7dZbSqlovlVmZEmHc+sX8CJwMB8G
// SIG // A1UdIwQYMBaAFNVjOlyKMZDzQ3t8RhvFM2hahW1VMFYG
// SIG // A1UdHwRPME0wS6BJoEeGRWh0dHA6Ly9jcmwubWljcm9z
// SIG // b2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1RpbVN0
// SIG // YVBDQV8yMDEwLTA3LTAxLmNybDBaBggrBgEFBQcBAQRO
// SIG // MEwwSgYIKwYBBQUHMAKGPmh0dHA6Ly93d3cubWljcm9z
// SIG // b2Z0LmNvbS9wa2kvY2VydHMvTWljVGltU3RhUENBXzIw
// SIG // MTAtMDctMDEuY3J0MAwGA1UdEwEB/wQCMAAwEwYDVR0l
// SIG // BAwwCgYIKwYBBQUHAwgwDQYJKoZIhvcNAQELBQADggEB
// SIG // ACJXe6NU71LtEQygM0XkNn0Ycm4QswDPZXUZ9vWCixuq
// SIG // 5UlMQVx7/0A7aBFrlpNUBXDhbMoAY3A4azLMzJsjyojf
// SIG // IzskcEOTWeLt+alVb6fDEyDFDkExHAmmFd1GW0LphRnB
// SIG // dbNWmfxwiV6r267KkggvoRtPAgJuOG+24PNpUN+eLMm8
// SIG // xyUsadm1Jq/EMO6ks4jBa7bshxLt5BRyAsRjYsEA58qc
// SIG // uhPNnnlDuKahIXuLXqUW+tVcUo4rYyDVGyLgQmFVWfCQ
// SIG // 1ctztboHendpbZjXN5lrWdtu3u+oYLQ0z23SZlRTDIqa
// SIG // 4CIQjMDDMJnd5Dky5IuY2io2IPlMGWbPKcuhggN4MIIC
// SIG // YAIBATCB46GBuaSBtjCBszELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjENMAsGA1UECxMETU9QUjEnMCUGA1UECxMebkNpcGhl
// SIG // ciBEU0UgRVNOOjU4NDctRjc2MS00RjcwMSUwIwYDVQQD
// SIG // ExxNaWNyb3NvZnQgVGltZS1TdGFtcCBTZXJ2aWNloiUK
// SIG // AQEwCQYFKw4DAhoFAAMVAL75wfTaDxU/8JADA754pZra
// SIG // ity5oIHCMIG/pIG8MIG5MQswCQYDVQQGEwJVUzETMBEG
// SIG // A1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
// SIG // ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9u
// SIG // MQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lwaGVy
// SIG // IE5UUyBFU046NERFOS0wQzVFLTNFMDkxKzApBgNVBAMT
// SIG // Ik1pY3Jvc29mdCBUaW1lIFNvdXJjZSBNYXN0ZXIgQ2xv
// SIG // Y2swDQYJKoZIhvcNAQEFBQACBQDcDRvqMCIYDzIwMTYx
// SIG // MjI3MTY1NzE0WhgPMjAxNjEyMjgxNjU3MTRaMHYwPAYK
// SIG // KwYBBAGEWQoEATEuMCwwCgIFANwNG+oCAQAwCQIBAAIB
// SIG // AwIB/zAHAgEAAgIZkTAKAgUA3A5tagIBADA2BgorBgEE
// SIG // AYRZCgQCMSgwJjAMBgorBgEEAYRZCgMBoAowCAIBAAID
// SIG // FuNgoQowCAIBAAIDB6EgMA0GCSqGSIb3DQEBBQUAA4IB
// SIG // AQCXjaBpfruAGrmd17dlVxPpB0lzufCc324Eg5YS2m9t
// SIG // k/fbVvt+p4KLZtcBwzWYeyxQIP6lma4CAn583RLGudF4
// SIG // ZVyxDHcNWrkRodzPIA2sL7ZsxT43HW8DlZq2a1V5d+r4
// SIG // ZkdwmNUHjVOkkv9KyjGaNwXs71wLQeTdBYV03Ddklulp
// SIG // 1xkGnbo1oJqm0+jpbgTfw7flgRChssBqZyUkvO/hOSJX
// SIG // a/d1IZevrtoejoM4V83oUs09jbQwPBBHUuJ821vBblpF
// SIG // QXEIeqjPo0ql+vkIrZBMfs6e/QgIT/d6taSUSkcFNWke
// SIG // DkSKhe43SayuDa4qvwZdwbZufvKChP4I84kFMYIC9TCC
// SIG // AvECAQEwgZMwfDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
// SIG // Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAc
// SIG // BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEmMCQG
// SIG // A1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENBIDIw
// SIG // MTACEzMAAACzObvUEpMVqf4AAAAAALMwDQYJYIZIAWUD
// SIG // BAIBBQCgggEyMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0B
// SIG // CRABBDAvBgkqhkiG9w0BCQQxIgQgVZYt613t8X25O0yI
// SIG // EXrNOgt2YetE2M3WrAHBAkUC4tgwgeIGCyqGSIb3DQEJ
// SIG // EAIMMYHSMIHPMIHMMIGxBBS++cH02g8VP/CQAwO+eKWa
// SIG // 2orcuTCBmDCBgKR+MHwxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // JjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBD
// SIG // QSAyMDEwAhMzAAAAszm71BKTFan+AAAAAACzMBYEFF49
// SIG // E1lJd+0sXvEdtoRL8r7XHS5EMA0GCSqGSIb3DQEBCwUA
// SIG // BIIBAADlYVLn9JFiS4B7ndh9e6HUcycnE8be7HU/JSzP
// SIG // eukH57YyR+UgqGtGe1rfTZeoK8oXGJz11kSzI2IzPDvr
// SIG // ZPGKjd2/JP6wf90DbzD9tHLmafhfKP0+1/bfgmRMeBQk
// SIG // aU6LL5IDesHsV/BJsBlphuuV8t3u/JfQLhJ6jFIMOpGY
// SIG // Alm5z/gu+U69iTMeMXVf4BvRl1UT2aJDh7WE/gNqUBxT
// SIG // HdIG6JSLsdnDspMRzw6XOe46AD5VtL+pPWV+gPC924sA
// SIG // cN2I3Ff/YwQ1hDwW1jt5wX5w2Lbwq4WvRbaNDhPuKxNc
// SIG // XPIwQm4O+gM0pYEbSmzDCcOPG53+pSKiv6h26Yw=
// SIG // End signature block
